/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.logging;

import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.Number;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.org.openqa.selenium.Beta;
import org.rascalmpl.org.openqa.selenium.logging.LogEntries;
import org.rascalmpl.org.openqa.selenium.logging.LogEntry;
import org.rascalmpl.org.openqa.selenium.logging.LogLevelMapping;

@Beta
public class SessionLogs
extends Object {
    private final Map<String, LogEntries> logTypeToEntriesMap = new HashMap();

    public LogEntries getLogs(String logType) {
        if (logType == null || !this.logTypeToEntriesMap.containsKey((Object)logType)) {
            return new LogEntries((Iterable<LogEntry>)Collections.emptyList());
        }
        return (LogEntries)this.logTypeToEntriesMap.get((Object)logType);
    }

    public void addLog(String logType, LogEntries logEntries) {
        this.logTypeToEntriesMap.put((Object)logType, (Object)logEntries);
    }

    public Set<String> getLogTypes() {
        return this.logTypeToEntriesMap.keySet();
    }

    public Map<String, LogEntries> getAll() {
        return Collections.unmodifiableMap(this.logTypeToEntriesMap);
    }

    public static SessionLogs fromJSON(Map<String, Object> rawSessionLogs) {
        SessionLogs sessionLogs = new SessionLogs();
        for (Map.Entry entry : rawSessionLogs.entrySet()) {
            String logType = (String)entry.getKey();
            Collection rawLogEntries = (Collection)entry.getValue();
            ArrayList logEntries = new ArrayList();
            for (Object o : rawLogEntries) {
                Map rawEntry = (Map)o;
                logEntries.add((Object)new LogEntry(LogLevelMapping.toLevel(String.valueOf((Object)rawEntry.get((Object)"org.rascalmpl.level"))), ((Number)rawEntry.get((Object)"org.rascalmpl.timestamp")).longValue(), String.valueOf((Object)rawEntry.get((Object)"org.rascalmpl.message"))));
            }
            sessionLogs.addLog(logType, new LogEntries((Iterable<LogEntry>)logEntries));
        }
        return sessionLogs;
    }

    @Beta
    public Map<String, LogEntries> toJson() {
        return this.getAll();
    }
}

