/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.net;

import org.rascalmpl.java.io.BufferedReader;
import org.rascalmpl.java.io.File;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.Reader;
import org.rascalmpl.java.io.StringReader;
import org.rascalmpl.java.io.UncheckedIOException;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.NullPointerException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.nio.charset.Charset;
import org.rascalmpl.java.nio.file.Files;
import org.rascalmpl.java.nio.file.Path;
import org.rascalmpl.org.openqa.selenium.net.EphemeralPortRangeDetector;
import org.rascalmpl.org.openqa.selenium.net.FixedIANAPortRange;

public class LinuxEphemeralPortRangeDetector
extends Object
implements EphemeralPortRangeDetector {
    private final int firstEphemeralPort;
    private final int lastEphemeralPort;

    public static LinuxEphemeralPortRangeDetector getInstance() {
        File file = new File((String)"org/rascalmpl//proc/sys/net/ipv4/ip_local_port_range");
        if (file.exists() && file.canRead()) {
            LinuxEphemeralPortRangeDetector linuxEphemeralPortRangeDetector;
            block9: {
                BufferedReader inputFil = Files.newBufferedReader((Path)file.toPath(), (Charset)Charset.defaultCharset());
                try {
                    linuxEphemeralPortRangeDetector = new LinuxEphemeralPortRangeDetector((Reader)inputFil);
                    if (inputFil == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputFil != null) {
                            try {
                                inputFil.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                inputFil.close();
            }
            return linuxEphemeralPortRangeDetector;
        }
        return new LinuxEphemeralPortRangeDetector((Reader)new StringReader((String)"org.rascalmpl.49152 65535"));
    }

    LinuxEphemeralPortRangeDetector(Reader inputFil) {
        FixedIANAPortRange defaultRange = new FixedIANAPortRange();
        int lowPort = defaultRange.getLowestEphemeralPort();
        int highPort = defaultRange.getHighestEphemeralPort();
        try {
            BufferedReader in = new BufferedReader(inputFil);
            try {
                String[] split = in.readLine().split((String)"org.rascalmpl.\\s+", 3);
                lowPort = Integer.parseInt((String)split[0]);
                highPort = Integer.parseInt((String)split[1]);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            in.close();
        }
        catch (IOException | NullPointerException throwable) {
            // empty catch block
        }
        this.firstEphemeralPort = lowPort;
        this.lastEphemeralPort = highPort;
    }

    @Override
    public int getLowestEphemeralPort() {
        return this.firstEphemeralPort;
    }

    @Override
    public int getHighestEphemeralPort() {
        return this.lastEphemeralPort;
    }
}

