/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.net;

import org.rascalmpl.java.io.BufferedReader;
import org.rascalmpl.java.io.InputStreamReader;
import org.rascalmpl.java.io.Reader;
import org.rascalmpl.java.lang.Exception;
import org.rascalmpl.java.lang.InterruptedException;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.Process;
import org.rascalmpl.java.lang.Runtime;
import org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Thread;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.java.net.ConnectException;
import org.rascalmpl.java.net.InetAddress;
import org.rascalmpl.java.nio.charset.Charset;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.org.openqa.selenium.Platform;
import org.rascalmpl.org.openqa.selenium.WebDriverException;
import org.rascalmpl.org.openqa.selenium.net.DefaultNetworkInterfaceProvider;
import org.rascalmpl.org.openqa.selenium.net.NetworkInterface;
import org.rascalmpl.org.openqa.selenium.net.NetworkInterfaceProvider;

public class NetworkUtils
extends org.rascalmpl.java.lang.Object {
    private static InetAddress cachedIp4NonLoopbackAddressOfThisMachine;
    private static String cachedIp4NonLoopbackAddressHostName;
    private final NetworkInterfaceProvider networkInterfaceProvider;
    private volatile String hostname;
    private volatile String address;

    NetworkUtils(NetworkInterfaceProvider networkInterfaceProvider) {
        this.networkInterfaceProvider = networkInterfaceProvider;
    }

    public NetworkUtils() {
        this(new DefaultNetworkInterfaceProvider());
    }

    public String getHostname() {
        this.determineHostnameAndAddress();
        return this.hostname;
    }

    public String getHostAddress() {
        this.determineHostnameAndAddress();
        return this.address;
    }

    public String getPrivateLocalAddress() {
        List<InetAddress> addresses = this.getLocalInterfaceAddress();
        if (addresses.isEmpty()) {
            return "org.rascalmpl.127.0.0.1";
        }
        return ((InetAddress)addresses.get(0)).getHostAddress();
    }

    public String getNonLoopbackAddressOfThisMachine() {
        InetAddress ip4NonLoopbackAddressOfThisMachine = this.getIp4NonLoopbackAddressOfThisMachine();
        if (!Objects.equals((org.rascalmpl.java.lang.Object)cachedIp4NonLoopbackAddressOfThisMachine, (org.rascalmpl.java.lang.Object)ip4NonLoopbackAddressOfThisMachine)) {
            cachedIp4NonLoopbackAddressOfThisMachine = ip4NonLoopbackAddressOfThisMachine;
            cachedIp4NonLoopbackAddressHostName = ip4NonLoopbackAddressOfThisMachine.getHostAddress();
        }
        return cachedIp4NonLoopbackAddressHostName;
    }

    public InetAddress getIp4NonLoopbackAddressOfThisMachine() {
        for (NetworkInterface iface : this.networkInterfaceProvider.getNetworkInterfaces()) {
            InetAddress ip4NonLoopback = iface.getIp4NonLoopBackOnly();
            if (ip4NonLoopback == null) continue;
            return ip4NonLoopback;
        }
        throw new WebDriverException((String)"org.rascalmpl.Could not find a non-loopback ip4 address for this machine");
    }

    public String obtainLoopbackIp4Address() {
        InetAddress netAddress;
        NetworkInterface linuxLoopback;
        NetworkInterface networkInterface = this.getLoopBackAndIp4Only();
        if (networkInterface != null) {
            return networkInterface.getIp4LoopbackOnly().getHostName();
        }
        String ipOfIp4LoopBack = this.getIpOfLoopBackIp4();
        if (ipOfIp4LoopBack != null) {
            return ipOfIp4LoopBack;
        }
        if (Platform.getCurrent().is(Platform.UNIX) && (linuxLoopback = this.networkInterfaceProvider.getLoInterface()) != null && (netAddress = linuxLoopback.getIp4LoopbackOnly()) != null) {
            return netAddress.getHostAddress();
        }
        throw new WebDriverException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.Unable to resolve local loopback address, please file an issue with the full message of this error:\n\u0001\n==== End of error message"}, (String)NetworkUtils.getNetWorkDiags()));
    }

    private InetAddress grabFirstNetworkAddress() {
        NetworkInterface firstInterface = (NetworkInterface)this.networkInterfaceProvider.getNetworkInterfaces().iterator().next();
        InetAddress firstAddress = null;
        if (firstInterface != null) {
            firstAddress = (InetAddress)firstInterface.getInetAddresses().iterator().next();
        }
        if (firstAddress == null) {
            throw new WebDriverException((String)"org.rascalmpl.Unable to find any network address for localhost");
        }
        return firstAddress;
    }

    public String getIpOfLoopBackIp4() {
        for (NetworkInterface iface : this.networkInterfaceProvider.getNetworkInterfaces()) {
            InetAddress netAddress = iface.getIp4LoopbackOnly();
            if (netAddress == null) continue;
            return netAddress.getHostAddress();
        }
        return null;
    }

    private NetworkInterface getLoopBackAndIp4Only() {
        for (NetworkInterface iface : this.networkInterfaceProvider.getNetworkInterfaces()) {
            if (!iface.isIp4AddressBindingOnly() || !iface.isLoopBack()) continue;
            return iface;
        }
        return null;
    }

    private List<InetAddress> getLocalInterfaceAddress() {
        NetworkInterface linuxLoopback;
        ArrayList localAddresses = new ArrayList();
        for (NetworkInterface iface : this.networkInterfaceProvider.getNetworkInterfaces()) {
            for (InetAddress addr : iface.getInetAddresses()) {
                if (!addr.isLoopbackAddress() || NetworkInterface.isIpv6(addr)) continue;
                localAddresses.add((org.rascalmpl.java.lang.Object)addr);
            }
        }
        if (Platform.getCurrent().is(Platform.UNIX) && (linuxLoopback = this.networkInterfaceProvider.getLoInterface()) != null) {
            for (InetAddress inetAddress : linuxLoopback.getInetAddresses()) {
                if (NetworkInterface.isIpv6(inetAddress)) continue;
                localAddresses.add((org.rascalmpl.java.lang.Object)inetAddress);
            }
        }
        if (localAddresses.isEmpty()) {
            return Collections.singletonList((org.rascalmpl.java.lang.Object)this.grabFirstNetworkAddress());
        }
        return localAddresses;
    }

    public static String getNetWorkDiags() {
        StringBuilder result = new StringBuilder();
        DefaultNetworkInterfaceProvider defaultNetworkInterfaceProvider = new DefaultNetworkInterfaceProvider();
        for (NetworkInterface networkInterface : defaultNetworkInterfaceProvider.getNetworkInterfaces()) {
            NetworkUtils.dumpToConsole(result, networkInterface);
        }
        NetworkInterface byName = defaultNetworkInterfaceProvider.getLoInterface();
        if (byName != null) {
            result.append((String)"org.rascalmpl.Loopback interface LO:\n");
            NetworkUtils.dumpToConsole(result, byName);
        }
        return result.toString();
    }

    private static void dumpToConsole(StringBuilder result, NetworkInterface inNetworkInterface) {
        if (inNetworkInterface == null) {
            return;
        }
        result.append(inNetworkInterface.getName());
        result.append((String)"org.rascalmpl.\n");
        NetworkUtils.dumpAddresses(result, inNetworkInterface.getInetAddresses());
    }

    private static void dumpAddresses(StringBuilder result, Iterable<InetAddress> inetAddresses) {
        for (InetAddress address : inetAddresses) {
            result.append((String)"org.rascalmpl.   address.getHostName() = ");
            result.append(address.getHostName());
            result.append((String)"org.rascalmpl.\n");
            result.append((String)"org.rascalmpl.   address.getHostAddress() = ");
            result.append(address.getHostAddress());
            result.append((String)"org.rascalmpl.\n");
            result.append((String)"org.rascalmpl.   address.isLoopbackAddress() = ");
            result.append(address.isLoopbackAddress());
            result.append((String)"org.rascalmpl.\n");
        }
    }

    private synchronized void determineHostnameAndAddress() {
        Object host;
        block29: {
            if (this.hostname != null) {
                return;
            }
            host = System.getenv((String)"org.rascalmpl.HOSTNAME");
            if (host == null) {
                host = System.getenv((String)"org.rascalmpl.COMPUTERNAME");
            }
            if (host == null && Platform.getCurrent().is(Platform.MAC)) {
                try {
                    Process process = Runtime.getRuntime().exec((String)"org.rascalmpl.hostname");
                    if (!process.waitFor(2L, TimeUnit.SECONDS)) {
                        process.destroyForcibly();
                        process.waitFor(2L, TimeUnit.SECONDS);
                    }
                    if (process.exitValue() != 0) break block29;
                    Iterator isr = new InputStreamReader(process.getInputStream(), Charset.defaultCharset());
                    try {
                        BufferedReader reader = new BufferedReader((Reader)isr);
                        try {
                            host = reader.readLine();
                        }
                        catch (Throwable throwable) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        reader.close();
                    }
                    catch (Throwable reader) {
                        try {
                            isr.close();
                        }
                        catch (Throwable throwable) {
                            reader.addSuppressed(throwable);
                        }
                        throw reader;
                    }
                    isr.close();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException((Throwable)((Object)e));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (host == null) {
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                host = "org.rascalmpl.localhost";
            }
        }
        this.hostname = host;
        Object address = null;
        if (Platform.getCurrent().is(Platform.MAC)) {
            try {
                for (NetworkInterface iface : this.networkInterfaceProvider.getNetworkInterfaces()) {
                    if (iface.getName().startsWith((String)"org.rascalmpl.en")) {
                        for (InetAddress inetAddress : iface.getInetAddresses()) {
                            try {
                                if (!inetAddress.isReachable(100)) continue;
                                address = inetAddress.getHostAddress();
                                break;
                            }
                            catch (ConnectException connectException) {
                            }
                        }
                    }
                    if (address == null) continue;
                    break;
                }
            }
            catch (Exception isr) {
                // empty catch block
            }
        }
        if (address == null) {
            try {
                address = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                address = "org.rascalmpl.127.0.0.1";
            }
        }
        this.address = address;
    }
}

