/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.net;

import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.UncheckedIOException;
import org.rascalmpl.java.lang.Exception;
import org.rascalmpl.java.lang.Math;
import org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.java.net.ConnectException;
import org.rascalmpl.java.net.InetSocketAddress;
import org.rascalmpl.java.net.ServerSocket;
import org.rascalmpl.java.net.Socket;
import org.rascalmpl.java.net.SocketAddress;
import org.rascalmpl.java.net.SocketTimeoutException;
import org.rascalmpl.java.util.Random;
import org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.org.openqa.selenium.Platform;
import org.rascalmpl.org.openqa.selenium.net.EphemeralPortRangeDetector;
import org.rascalmpl.org.openqa.selenium.net.FixedIANAPortRange;
import org.rascalmpl.org.openqa.selenium.net.LinuxEphemeralPortRangeDetector;
import org.rascalmpl.org.openqa.selenium.net.OlderWindowsVersionEphemeralPortDetector;

public class PortProber
extends org.rascalmpl.java.lang.Object {
    public static final int HIGHEST_PORT = 65535;
    public static final int START_OF_USER_PORTS = 1024;
    private static final Random random = new Random();
    private static final EphemeralPortRangeDetector ephemeralRangeDetector;
    private static final Platform current;

    private PortProber() {
    }

    public static int findFreePort() {
        for (int i = 0; i < 5; ++i) {
            int seedPort = PortProber.createAcceptablePort();
            int suggestedPort = PortProber.checkPortIsFree(seedPort);
            if (suggestedPort == -1) continue;
            return suggestedPort;
        }
        throw new RuntimeException((String)"org.rascalmpl.Unable to find a free port");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int createAcceptablePort() {
        Random random = PortProber.random;
        synchronized (random) {
            int LAST_PORT;
            int FIRST_PORT;
            int freeBelow;
            int freeAbove;
            int ephemeralStart = Math.max((int)1024, (int)ephemeralRangeDetector.getLowestEphemeralPort());
            int ephemeralEnd = Math.min((int)65535, (int)ephemeralRangeDetector.getHighestEphemeralPort());
            if (ephemeralEnd - ephemeralStart < 5000) {
                FixedIANAPortRange ianaRange = new FixedIANAPortRange();
                ephemeralStart = ianaRange.getLowestEphemeralPort();
                ephemeralEnd = ianaRange.getHighestEphemeralPort();
            }
            if ((freeAbove = 65535 - ephemeralEnd) > (freeBelow = Math.max((int)0, (int)(ephemeralStart - 1024)))) {
                FIRST_PORT = ephemeralEnd;
                LAST_PORT = 65535;
            } else {
                FIRST_PORT = 1024;
                LAST_PORT = ephemeralStart;
            }
            if (FIRST_PORT == LAST_PORT) {
                return FIRST_PORT;
            }
            if (FIRST_PORT > LAST_PORT) {
                throw new UnsupportedOperationException((String)"org.rascalmpl.Could not find ephemeral port to use");
            }
            int randomInt = PortProber.random.nextInt();
            int portWithoutOffset = Math.abs((int)(randomInt % (LAST_PORT - FIRST_PORT + 1)));
            return portWithoutOffset + FIRST_PORT;
        }
    }

    private static boolean isFree(String bindHost, int port) {
        boolean bl;
        ServerSocket socket = new ServerSocket();
        try {
            socket.setReuseAddress(true);
            socket.bind((SocketAddress)new InetSocketAddress(bindHost, port));
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    static int checkPortIsFree(int port) {
        if (PortProber.isFree((String)"org.rascalmpl.localhost", port) && PortProber.isFree((String)"org.rascalmpl.0.0.0.0", port)) {
            return port;
        }
        return -1;
    }

    public static void waitForPortUp(int port, int timeout, TimeUnit unit) {
        long end = System.currentTimeMillis() + unit.toMillis((long)timeout);
        while (System.currentTimeMillis() < end) {
            try {
                Socket socket = new Socket();
                try {
                    socket.connect((SocketAddress)new InetSocketAddress((String)"org.rascalmpl.localhost", port), 1000);
                }
                catch (Throwable throwable) {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                socket.close();
                return;
            }
            catch (ConnectException | SocketTimeoutException socket) {
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    static {
        current = Platform.getCurrent();
        ephemeralRangeDetector = current.is(Platform.LINUX) ? LinuxEphemeralPortRangeDetector.getInstance() : (current.is(Platform.XP) ? new OlderWindowsVersionEphemeralPortDetector() : new FixedIANAPortRange());
    }
}

