/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.os;

import org.rascalmpl.java.io.File;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.java.nio.file.Files;
import org.rascalmpl.java.nio.file.Path;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.org.openqa.selenium.Platform;

public class ExecutableFinder
extends Object {
    private static final List<String> ENDINGS = Platform.getCurrent().is(Platform.WINDOWS) ? Arrays.asList((Object[])new String[]{"org.rascalmpl.", "org.rascalmpl..cmd", "org.rascalmpl..exe", "org.rascalmpl..com", "org.rascalmpl..bat"}) : Collections.singletonList((Object)"org.rascalmpl.");

    public String find(String named) {
        File file = new File(named);
        if (ExecutableFinder.canExecute(file)) {
            return named;
        }
        if (Platform.getCurrent().is(Platform.WINDOWS) && ExecutableFinder.canExecute(file = new File((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.\u0001.exe"}, (String)named)))) {
            return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.\u0001.exe"}, (String)named);
        }
        ArrayList pathSegments = new ArrayList(this.fromEnvironment());
        if (Platform.getCurrent().is(Platform.MAC)) {
            pathSegments.addAll(this.macSpecificPathSegments());
        }
        for (String pathSegment : pathSegments) {
            for (String ending : ENDINGS) {
                file = new File(pathSegment, (String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.\u0001\u0001"}, (String)named, (String)ending));
                if (!ExecutableFinder.canExecute(file)) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    private List<String> fromEnvironment() {
        String path;
        java.lang.String pathName = "org.rascalmpl.PATH";
        Map env = System.getenv();
        if (!env.containsKey((Object)pathName)) {
            for (String key : env.keySet()) {
                if (!pathName.equalsIgnoreCase(key)) continue;
                pathName = key;
                break;
            }
        }
        return (path = (String)env.get((Object)pathName)) != null ? Arrays.asList((Object[])path.split(File.pathSeparator)) : Collections.emptyList();
    }

    private List<String> macSpecificPathSegments() {
        File pathFile = new File((String)"org/rascalmpl//etc/paths");
        if (pathFile.exists()) {
            try {
                return Files.readAllLines((Path)pathFile.toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    private static boolean canExecute(File file) {
        return file.exists() && !file.isDirectory() && file.canExecute();
    }
}

