/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.os;

import org.rascalmpl.java.io.ByteArrayInputStream;
import org.rascalmpl.java.io.File;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.InputStream;
import org.rascalmpl.java.io.OutputStream;
import org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.InterruptedException;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.Process;
import org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Thread;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.java.nio.charset.Charset;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.concurrent.ConcurrentHashMap;
import org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.org.apache.commons.exec.CommandLine;
import org.rascalmpl.org.apache.commons.exec.DaemonExecutor;
import org.rascalmpl.org.apache.commons.exec.DefaultExecuteResultHandler;
import org.rascalmpl.org.apache.commons.exec.ExecuteWatchdog;
import org.rascalmpl.org.apache.commons.exec.Executor;
import org.rascalmpl.org.apache.commons.exec.PumpStreamHandler;
import org.rascalmpl.org.openqa.selenium.Platform;
import org.rascalmpl.org.openqa.selenium.TimeoutException;
import org.rascalmpl.org.openqa.selenium.WebDriverException;
import org.rascalmpl.org.openqa.selenium.internal.Require;
import org.rascalmpl.org.openqa.selenium.io.CircularOutputStream;
import org.rascalmpl.org.openqa.selenium.io.MultiOutputStream;
import org.rascalmpl.org.openqa.selenium.os.ExecutableFinder;

@Deprecated
class OsProcess
extends org.rascalmpl.java.lang.Object {
    private static final Logger LOG = Logger.getLogger((String)OsProcess.class.getName());
    private final CircularOutputStream inputOut = new CircularOutputStream(32768);
    private volatile String allInput;
    private final DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
    private final Executor executor = new DaemonExecutor();
    private volatile OutputStream drainTo;
    private final SeleniumWatchDog executeWatchdog = new SeleniumWatchDog(-1L);
    private PumpStreamHandler streamHandler;
    private final CommandLine cl;
    private final Map<String, String> env = new ConcurrentHashMap();

    public OsProcess(String executable, String ... args) {
        String actualExe = new ExecutableFinder().find(executable);
        Require.state((String)"org.rascalmpl.Actual executable", actualExe).nonNull((String)"org.rascalmpl.Unable to find executable for: %s", new org.rascalmpl.java.lang.Object[]{executable});
        this.cl = new CommandLine(actualExe);
        this.cl.addArguments(args, false);
    }

    public void setEnvironmentVariable(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException((String)"org.rascalmpl.Cannot have a null environment variable name!");
        }
        if (value == null) {
            throw new IllegalArgumentException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.Cannot have a null value for environment variable \u0001"}, (String)name));
        }
        this.env.put((org.rascalmpl.java.lang.Object)name, (org.rascalmpl.java.lang.Object)value);
    }

    public Map<String, String> getEnvironment() {
        return Collections.unmodifiableMap((Map)new HashMap(this.env));
    }

    private Map<String, String> getMergedEnv() {
        HashMap newEnv = new HashMap(System.getenv());
        newEnv.putAll(this.env);
        return newEnv;
    }

    private ByteArrayInputStream getInputStream() {
        return this.allInput != null ? new ByteArrayInputStream(this.allInput.getBytes(Charset.defaultCharset())) : null;
    }

    public void executeAsync() {
        try {
            OutputStream outputStream = this.getOutputStream();
            this.executeWatchdog.reset();
            this.executor.setWatchdog(this.executeWatchdog);
            this.streamHandler = new PumpStreamHandler(outputStream, outputStream, (InputStream)this.getInputStream());
            this.executor.setStreamHandler(this.streamHandler);
            this.executor.execute(this.cl, this.getMergedEnv(), this.handler);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)((Object)e));
        }
    }

    public boolean waitForProcessStarted(long duration, TimeUnit unit) {
        return this.executeWatchdog.waitForProcessStarted(duration, unit);
    }

    private OutputStream getOutputStream() {
        return this.drainTo == null ? this.inputOut : new MultiOutputStream(this.inputOut, this.drainTo);
    }

    public int destroy() {
        SeleniumWatchDog watchdog = this.executeWatchdog;
        if (watchdog.waitForProcessStarted(2L, TimeUnit.MINUTES)) {
            if (!Platform.getCurrent().is(Platform.WINDOWS)) {
                watchdog.destroyProcess();
                watchdog.waitForTerminationAfterDestroy(2, TimeUnit.SECONDS);
            }
            if (this.isRunning()) {
                watchdog.destroyHarder();
                watchdog.waitForTerminationAfterDestroy(1, TimeUnit.SECONDS);
            }
        } else {
            LOG.warning((String)"org.rascalmpl.Tried to destory a process which never started.");
        }
        if (this.streamHandler != null) {
            this.streamHandler.setStopTimeout(2000L);
            try {
                this.streamHandler.stop();
            }
            catch (IOException e) {
                LOG.log(Level.INFO, (String)"org.rascalmpl.Unable to drain process streams. Ignoring but the exception being swallowed follows.", (Throwable)((Object)e));
            }
        }
        if (!this.isRunning()) {
            return this.getExitCode();
        }
        LOG.severe(String.format((String)"org.rascalmpl.Unable to kill process %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{watchdog.process}));
        int exitCode = -1;
        this.executor.setExitValue(exitCode);
        return exitCode;
    }

    public void waitFor() throws InterruptedException {
        this.handler.waitFor();
    }

    public void waitFor(long timeout) throws InterruptedException {
        long until = System.currentTimeMillis() + timeout;
        boolean timedOut = true;
        while (System.currentTimeMillis() < until) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.handler.hasResult()) {
                timedOut = false;
                break;
            }
            Thread.sleep((long)50L);
        }
        if (timedOut) {
            throw new TimeoutException(String.format((String)"org.rascalmpl.Process timed out after waiting for %d ms.", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{Long.valueOf((long)timeout)}));
        }
    }

    public boolean isRunning() {
        return !this.handler.hasResult();
    }

    public int getExitCode() {
        if (this.isRunning()) {
            throw new IllegalStateException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.Cannot get exit code before executing command line: \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)this.cl)));
        }
        return this.handler.getExitValue();
    }

    public void checkForError() {
        if (this.handler.getException() != null) {
            LOG.severe(this.handler.getException().toString());
        }
    }

    public String getStdOut() {
        return this.inputOut.toString();
    }

    public void setInput(String allInput) {
        this.allInput = allInput;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.executor.setWorkingDirectory(workingDirectory);
    }

    public String toString() {
        return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.\u0001[ \u0001]"}, (String)this.cl.toString(), (String)String.valueOf(this.env));
    }

    public void copyOutputTo(OutputStream out) {
        this.drainTo = out;
    }

    class SeleniumWatchDog
    extends ExecuteWatchdog {
        private volatile Process process;
        private volatile boolean starting;

        SeleniumWatchDog(long timeout) {
            super(timeout);
            this.starting = true;
        }

        @Override
        public synchronized void start(Process process) {
            this.process = process;
            this.starting = false;
            super.start(process);
        }

        public void reset() {
            this.starting = true;
        }

        private boolean waitForProcessStarted(long duration, TimeUnit unit) {
            long end = System.currentTimeMillis() + unit.toMillis(duration);
            while (this.starting && System.currentTimeMillis() < end) {
                try {
                    Thread.sleep((long)50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new WebDriverException((Throwable)((Object)e));
                }
            }
            return !this.starting;
        }

        private void waitForTerminationAfterDestroy(int duration, TimeUnit unit) {
            long end = System.currentTimeMillis() + unit.toMillis((long)duration);
            while (OsProcess.this.isRunning() && System.currentTimeMillis() < end) {
                try {
                    Thread.sleep((long)50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new WebDriverException((Throwable)((Object)e));
                }
            }
        }

        private void destroyHarder() {
            try {
                Process awaitFor = this.process.destroyForcibly();
                awaitFor.waitFor(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException((Throwable)((Object)e));
            }
        }
    }
}

