/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.remote;

import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.org.openqa.selenium.Capabilities;
import org.rascalmpl.org.openqa.selenium.Cookie;
import org.rascalmpl.org.openqa.selenium.Dimension;
import org.rascalmpl.org.openqa.selenium.Point;
import org.rascalmpl.org.openqa.selenium.WindowType;
import org.rascalmpl.org.openqa.selenium.interactions.Sequence;
import org.rascalmpl.org.openqa.selenium.internal.Require;
import org.rascalmpl.org.openqa.selenium.print.PrintOptions;
import org.rascalmpl.org.openqa.selenium.remote.CommandPayload;

public interface DriverCommand {
    public static final String GET_CAPABILITIES = "org.rascalmpl.getCapabilities";
    public static final String NEW_SESSION = "org.rascalmpl.newSession";
    public static final String STATUS = "org.rascalmpl.status";
    public static final String CLOSE = "org.rascalmpl.close";
    public static final String QUIT = "org.rascalmpl.quit";
    public static final String GET = "org.rascalmpl.get";
    public static final String GO_BACK = "org.rascalmpl.goBack";
    public static final String GO_FORWARD = "org.rascalmpl.goForward";
    public static final String REFRESH = "org.rascalmpl.refresh";
    public static final String ADD_COOKIE = "org.rascalmpl.addCookie";
    public static final String GET_ALL_COOKIES = "org.rascalmpl.getCookies";
    public static final String GET_COOKIE = "org.rascalmpl.getCookie";
    public static final String DELETE_COOKIE = "org.rascalmpl.deleteCookie";
    public static final String DELETE_ALL_COOKIES = "org.rascalmpl.deleteAllCookies";
    public static final String FIND_ELEMENT = "org.rascalmpl.findElement";
    public static final String FIND_ELEMENTS = "org.rascalmpl.findElements";
    public static final String FIND_CHILD_ELEMENT = "org.rascalmpl.findChildElement";
    public static final String FIND_CHILD_ELEMENTS = "org.rascalmpl.findChildElements";
    public static final String GET_ELEMENT_SHADOW_ROOT = "org.rascalmpl.getElementShadowRoot";
    public static final String FIND_ELEMENT_FROM_SHADOW_ROOT = "org.rascalmpl.findElementFromShadowRoot";
    public static final String FIND_ELEMENTS_FROM_SHADOW_ROOT = "org.rascalmpl.findElementsFromShadowRoot";
    public static final String CLEAR_ELEMENT = "org.rascalmpl.clearElement";
    public static final String CLICK_ELEMENT = "org.rascalmpl.clickElement";
    public static final String SEND_KEYS_TO_ELEMENT = "org.rascalmpl.sendKeysToElement";
    public static final String SUBMIT_ELEMENT = "org.rascalmpl.submitElement";
    public static final String UPLOAD_FILE = "org.rascalmpl.uploadFile";
    public static final String GET_CURRENT_WINDOW_HANDLE = "org.rascalmpl.getCurrentWindowHandle";
    public static final String GET_WINDOW_HANDLES = "org.rascalmpl.getWindowHandles";
    public static final String SWITCH_TO_WINDOW = "org.rascalmpl.switchToWindow";
    public static final String SWITCH_TO_NEW_WINDOW = "org.rascalmpl.newWindow";
    public static final String SWITCH_TO_FRAME = "org.rascalmpl.switchToFrame";
    public static final String SWITCH_TO_PARENT_FRAME = "org.rascalmpl.switchToParentFrame";
    public static final String GET_ACTIVE_ELEMENT = "org.rascalmpl.getActiveElement";
    public static final String GET_CURRENT_URL = "org.rascalmpl.getCurrentUrl";
    public static final String GET_PAGE_SOURCE = "org.rascalmpl.getPageSource";
    public static final String GET_TITLE = "org.rascalmpl.getTitle";
    public static final String EXECUTE_SCRIPT = "org.rascalmpl.executeScript";
    public static final String EXECUTE_ASYNC_SCRIPT = "org.rascalmpl.executeAsyncScript";
    public static final String GET_ELEMENT_TEXT = "org.rascalmpl.getElementText";
    public static final String GET_ELEMENT_TAG_NAME = "org.rascalmpl.getElementTagName";
    public static final String IS_ELEMENT_SELECTED = "org.rascalmpl.isElementSelected";
    public static final String IS_ELEMENT_ENABLED = "org.rascalmpl.isElementEnabled";
    public static final String IS_ELEMENT_DISPLAYED = "org.rascalmpl.isElementDisplayed";
    public static final String GET_ELEMENT_RECT = "org.rascalmpl.getElementRect";
    public static final String GET_ELEMENT_LOCATION = "org.rascalmpl.getElementLocation";
    public static final String GET_ELEMENT_LOCATION_ONCE_SCROLLED_INTO_VIEW = "org.rascalmpl.getElementLocationOnceScrolledIntoView";
    public static final String GET_ELEMENT_SIZE = "org.rascalmpl.getElementSize";
    public static final String GET_ELEMENT_DOM_PROPERTY = "org.rascalmpl.getElementDomProperty";
    public static final String GET_ELEMENT_DOM_ATTRIBUTE = "org.rascalmpl.getElementDomAttribute";
    public static final String GET_ELEMENT_ATTRIBUTE = "org.rascalmpl.getElementAttribute";
    public static final String GET_ELEMENT_VALUE_OF_CSS_PROPERTY = "org.rascalmpl.getElementValueOfCssProperty";
    public static final String GET_ELEMENT_ARIA_ROLE = "org.rascalmpl.getElementAriaRole";
    public static final String GET_ELEMENT_ACCESSIBLE_NAME = "org.rascalmpl.getElementAccessibleName";
    public static final String SCREENSHOT = "org.rascalmpl.screenshot";
    public static final String ELEMENT_SCREENSHOT = "org.rascalmpl.elementScreenshot";
    public static final String ACCEPT_ALERT = "org.rascalmpl.acceptAlert";
    public static final String DISMISS_ALERT = "org.rascalmpl.dismissAlert";
    public static final String GET_ALERT_TEXT = "org.rascalmpl.getAlertText";
    public static final String SET_ALERT_VALUE = "org.rascalmpl.setAlertValue";
    public static final String GET_TIMEOUTS = "org.rascalmpl.getTimeouts";
    public static final String SET_TIMEOUT = "org.rascalmpl.setTimeout";
    public static final String PRINT_PAGE = "org.rascalmpl.printPage";
    public static final String IMPLICITLY_WAIT = "org.rascalmpl.implicitlyWait";
    public static final String SET_SCRIPT_TIMEOUT = "org.rascalmpl.setScriptTimeout";
    public static final String GET_LOCATION = "org.rascalmpl.getLocation";
    public static final String SET_LOCATION = "org.rascalmpl.setLocation";
    public static final String GET_APP_CACHE = "org.rascalmpl.getAppCache";
    public static final String CLEAR_APP_CACHE = "org.rascalmpl.clearAppCache";
    public static final String GET_LOCAL_STORAGE_ITEM = "org.rascalmpl.getLocalStorageItem";
    public static final String GET_LOCAL_STORAGE_KEYS = "org.rascalmpl.getLocalStorageKeys";
    public static final String SET_LOCAL_STORAGE_ITEM = "org.rascalmpl.setLocalStorageItem";
    public static final String REMOVE_LOCAL_STORAGE_ITEM = "org.rascalmpl.removeLocalStorageItem";
    public static final String CLEAR_LOCAL_STORAGE = "org.rascalmpl.clearLocalStorage";
    public static final String GET_LOCAL_STORAGE_SIZE = "org.rascalmpl.getLocalStorageSize";
    public static final String GET_SESSION_STORAGE_ITEM = "org.rascalmpl.getSessionStorageItem";
    public static final String GET_SESSION_STORAGE_KEYS = "org.rascalmpl.getSessionStorageKey";
    public static final String SET_SESSION_STORAGE_ITEM = "org.rascalmpl.setSessionStorageItem";
    public static final String REMOVE_SESSION_STORAGE_ITEM = "org.rascalmpl.removeSessionStorageItem";
    public static final String CLEAR_SESSION_STORAGE = "org.rascalmpl.clearSessionStorage";
    public static final String GET_SESSION_STORAGE_SIZE = "org.rascalmpl.getSessionStorageSize";
    public static final String ACTIONS = "org.rascalmpl.actions";
    public static final String CLEAR_ACTIONS_STATE = "org.rascalmpl.clearActionState";
    public static final String SET_CURRENT_WINDOW_POSITION = "org.rascalmpl.setWindowPosition";
    public static final String GET_CURRENT_WINDOW_POSITION = "org.rascalmpl.getWindowPosition";
    public static final String SET_CURRENT_WINDOW_SIZE = "org.rascalmpl.setCurrentWindowSize";
    public static final String GET_CURRENT_WINDOW_SIZE = "org.rascalmpl.getCurrentWindowSize";
    public static final String MAXIMIZE_CURRENT_WINDOW = "org.rascalmpl.maximizeCurrentWindow";
    public static final String MINIMIZE_CURRENT_WINDOW = "org.rascalmpl.minimizeCurrentWindow";
    public static final String FULLSCREEN_CURRENT_WINDOW = "org.rascalmpl.fullscreenCurrentWindow";
    public static final String GET_AVAILABLE_LOG_TYPES = "org.rascalmpl.getAvailableLogTypes";
    public static final String GET_LOG = "org.rascalmpl.getLog";
    public static final String GET_NETWORK_CONNECTION = "org.rascalmpl.getNetworkConnection";
    public static final String SET_NETWORK_CONNECTION = "org.rascalmpl.setNetworkConnection";
    public static final String ADD_VIRTUAL_AUTHENTICATOR = "org.rascalmpl.addVirtualAuthenticator";
    public static final String REMOVE_VIRTUAL_AUTHENTICATOR = "org.rascalmpl.removeVirtualAuthenticator";
    public static final String ADD_CREDENTIAL = "org.rascalmpl.addCredential";
    public static final String GET_CREDENTIALS = "org.rascalmpl.getCredentials";
    public static final String REMOVE_CREDENTIAL = "org.rascalmpl.removeCredential";
    public static final String REMOVE_ALL_CREDENTIALS = "org.rascalmpl.removeAllCredentials";
    public static final String SET_USER_VERIFIED = "org.rascalmpl.setUserVerified";
    public static final String CANCEL_DIALOG = "org.rascalmpl.cancelDialog";
    public static final String SELECT_ACCOUNT = "org.rascalmpl.selectAccount";
    public static final String CLICK_DIALOG = "org.rascalmpl.clickDialog";
    public static final String GET_ACCOUNTS = "org.rascalmpl.getAccounts";
    public static final String GET_FEDCM_TITLE = "org.rascalmpl.getFedCmTitle";
    public static final String GET_FEDCM_DIALOG_TYPE = "org.rascalmpl.getFedCmDialogType";
    public static final String SET_DELAY_ENABLED = "org.rascalmpl.setDelayEnabled";
    public static final String RESET_COOLDOWN = "org.rascalmpl.resetCooldown";
    public static final String GET_DOWNLOADABLE_FILES = "org.rascalmpl.getDownloadableFiles";
    public static final String DOWNLOAD_FILE = "org.rascalmpl.downloadFile";
    public static final String DELETE_DOWNLOADABLE_FILES = "org.rascalmpl.deleteDownloadableFiles";

    public static CommandPayload NEW_SESSION(Capabilities capabilities) {
        Require.nonNull((String)"org.rascalmpl.Capabilities", capabilities);
        return new CommandPayload((String)"org.rascalmpl.newSession", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.capabilities", (org.rascalmpl.java.lang.Object)Collections.singleton((org.rascalmpl.java.lang.Object)capabilities)));
    }

    public static CommandPayload NEW_SESSION(Collection<Capabilities> capabilities) {
        Require.nonNull((String)"org.rascalmpl.Capabilities", capabilities);
        if (capabilities.isEmpty()) {
            throw new IllegalArgumentException((String)"org.rascalmpl.Capabilities for new session must not be empty");
        }
        return new CommandPayload((String)"org.rascalmpl.newSession", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.capabilities", capabilities));
    }

    public static CommandPayload GET(String url) {
        return new CommandPayload((String)"org.rascalmpl.get", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.url", (org.rascalmpl.java.lang.Object)url));
    }

    public static CommandPayload ADD_COOKIE(Cookie cookie) {
        return new CommandPayload((String)"org.rascalmpl.addCookie", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.cookie", (org.rascalmpl.java.lang.Object)cookie));
    }

    public static CommandPayload DELETE_COOKIE(String name) {
        return new CommandPayload((String)"org.rascalmpl.deleteCookie", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.name", (org.rascalmpl.java.lang.Object)name));
    }

    public static CommandPayload FIND_ELEMENT(String strategy, org.rascalmpl.java.lang.Object value) {
        return new CommandPayload((String)"org.rascalmpl.findElement", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.using", (org.rascalmpl.java.lang.Object)strategy, (org.rascalmpl.java.lang.Object)"org.rascalmpl.value", (org.rascalmpl.java.lang.Object)value));
    }

    public static CommandPayload FIND_ELEMENTS(String strategy, org.rascalmpl.java.lang.Object value) {
        return new CommandPayload((String)"org.rascalmpl.findElements", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.using", (org.rascalmpl.java.lang.Object)strategy, (org.rascalmpl.java.lang.Object)"org.rascalmpl.value", (org.rascalmpl.java.lang.Object)value));
    }

    public static CommandPayload FIND_CHILD_ELEMENT(String id, String strategy, String value) {
        return new CommandPayload((String)"org.rascalmpl.findChildElement", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id, (org.rascalmpl.java.lang.Object)"org.rascalmpl.using", (org.rascalmpl.java.lang.Object)strategy, (org.rascalmpl.java.lang.Object)"org.rascalmpl.value", (org.rascalmpl.java.lang.Object)value));
    }

    public static CommandPayload FIND_CHILD_ELEMENTS(String id, String strategy, String value) {
        return new CommandPayload((String)"org.rascalmpl.findChildElements", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id, (org.rascalmpl.java.lang.Object)"org.rascalmpl.using", (org.rascalmpl.java.lang.Object)strategy, (org.rascalmpl.java.lang.Object)"org.rascalmpl.value", (org.rascalmpl.java.lang.Object)value));
    }

    public static CommandPayload GET_ELEMENT_SHADOW_ROOT(String id) {
        Require.nonNull((String)"org.rascalmpl.Element ID", id);
        return new CommandPayload((String)"org.rascalmpl.getElementShadowRoot", Collections.singletonMap((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id));
    }

    public static CommandPayload FIND_ELEMENT_FROM_SHADOW_ROOT(String shadowId, String strategy, String value) {
        Require.nonNull((String)"org.rascalmpl.Shadow root ID", shadowId);
        Require.nonNull((String)"org.rascalmpl.Element finding strategy", strategy);
        Require.nonNull((String)"org.rascalmpl.Value for finding strategy", value);
        return new CommandPayload((String)"org.rascalmpl.findElementFromShadowRoot", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.shadowId", (org.rascalmpl.java.lang.Object)shadowId, (org.rascalmpl.java.lang.Object)"org.rascalmpl.using", (org.rascalmpl.java.lang.Object)strategy, (org.rascalmpl.java.lang.Object)"org.rascalmpl.value", (org.rascalmpl.java.lang.Object)value));
    }

    public static CommandPayload FIND_ELEMENTS_FROM_SHADOW_ROOT(String shadowId, String strategy, String value) {
        Require.nonNull((String)"org.rascalmpl.Shadow root ID", shadowId);
        Require.nonNull((String)"org.rascalmpl.Element finding strategy", strategy);
        Require.nonNull((String)"org.rascalmpl.Value for finding strategy", value);
        return new CommandPayload((String)"org.rascalmpl.findElementsFromShadowRoot", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.shadowId", (org.rascalmpl.java.lang.Object)shadowId, (org.rascalmpl.java.lang.Object)"org.rascalmpl.using", (org.rascalmpl.java.lang.Object)strategy, (org.rascalmpl.java.lang.Object)"org.rascalmpl.value", (org.rascalmpl.java.lang.Object)value));
    }

    public static CommandPayload CLEAR_ELEMENT(String id) {
        return new CommandPayload((String)"org.rascalmpl.clearElement", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id));
    }

    public static CommandPayload CLICK_ELEMENT(String id) {
        return new CommandPayload((String)"org.rascalmpl.clickElement", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id));
    }

    public static CommandPayload SEND_KEYS_TO_ELEMENT(String id, CharSequence[] keysToSend) {
        return new CommandPayload((String)"org.rascalmpl.sendKeysToElement", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id, (org.rascalmpl.java.lang.Object)"org.rascalmpl.value", (org.rascalmpl.java.lang.Object)keysToSend));
    }

    public static CommandPayload SUBMIT_ELEMENT(String id) {
        return new CommandPayload((String)"org.rascalmpl.submitElement", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id));
    }

    public static CommandPayload UPLOAD_FILE(String file) {
        return new CommandPayload((String)"org.rascalmpl.uploadFile", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.file", (org.rascalmpl.java.lang.Object)file));
    }

    public static CommandPayload SWITCH_TO_WINDOW(String windowHandleOrName) {
        return new CommandPayload((String)"org.rascalmpl.switchToWindow", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.handle", (org.rascalmpl.java.lang.Object)windowHandleOrName));
    }

    public static CommandPayload SWITCH_TO_NEW_WINDOW(WindowType typeHint) {
        return new CommandPayload((String)"org.rascalmpl.newWindow", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.type", (org.rascalmpl.java.lang.Object)typeHint.toString()));
    }

    public static CommandPayload SWITCH_TO_FRAME(org.rascalmpl.java.lang.Object frame) {
        return new CommandPayload((String)"org.rascalmpl.switchToFrame", Collections.singletonMap((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)frame));
    }

    public static CommandPayload EXECUTE_SCRIPT(String script, List<org.rascalmpl.java.lang.Object> args) {
        return new CommandPayload((String)"org.rascalmpl.executeScript", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.script", (org.rascalmpl.java.lang.Object)script, (org.rascalmpl.java.lang.Object)"org.rascalmpl.args", args));
    }

    public static CommandPayload EXECUTE_ASYNC_SCRIPT(String script, List<org.rascalmpl.java.lang.Object> args) {
        return new CommandPayload((String)"org.rascalmpl.executeAsyncScript", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.script", (org.rascalmpl.java.lang.Object)script, (org.rascalmpl.java.lang.Object)"org.rascalmpl.args", args));
    }

    public static CommandPayload GET_ELEMENT_TEXT(String id) {
        return new CommandPayload((String)"org.rascalmpl.getElementText", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id));
    }

    public static CommandPayload GET_ELEMENT_TAG_NAME(String id) {
        return new CommandPayload((String)"org.rascalmpl.getElementTagName", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id));
    }

    public static CommandPayload IS_ELEMENT_SELECTED(String id) {
        return new CommandPayload((String)"org.rascalmpl.isElementSelected", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id));
    }

    public static CommandPayload IS_ELEMENT_ENABLED(String id) {
        return new CommandPayload((String)"org.rascalmpl.isElementEnabled", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id));
    }

    public static CommandPayload IS_ELEMENT_DISPLAYED(String id) {
        return new CommandPayload((String)"org.rascalmpl.isElementDisplayed", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id));
    }

    public static CommandPayload GET_ELEMENT_RECT(String id) {
        return new CommandPayload((String)"org.rascalmpl.getElementRect", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id));
    }

    public static CommandPayload GET_ELEMENT_LOCATION(String id) {
        return new CommandPayload((String)"org.rascalmpl.getElementLocation", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id));
    }

    public static CommandPayload GET_ELEMENT_LOCATION_ONCE_SCROLLED_INTO_VIEW(String id) {
        return new CommandPayload((String)"org.rascalmpl.getElementLocationOnceScrolledIntoView", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id));
    }

    public static CommandPayload GET_ELEMENT_SIZE(String id) {
        return new CommandPayload((String)"org.rascalmpl.getElementSize", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id));
    }

    public static CommandPayload GET_ELEMENT_DOM_PROPERTY(String id, String name) {
        return new CommandPayload((String)"org.rascalmpl.getElementDomProperty", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id, (org.rascalmpl.java.lang.Object)"org.rascalmpl.name", (org.rascalmpl.java.lang.Object)name));
    }

    public static CommandPayload GET_ELEMENT_DOM_ATTRIBUTE(String id, String name) {
        return new CommandPayload((String)"org.rascalmpl.getElementDomAttribute", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id, (org.rascalmpl.java.lang.Object)"org.rascalmpl.name", (org.rascalmpl.java.lang.Object)name));
    }

    public static CommandPayload GET_ELEMENT_ATTRIBUTE(String id, String name) {
        return new CommandPayload((String)"org.rascalmpl.getElementAttribute", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id, (org.rascalmpl.java.lang.Object)"org.rascalmpl.name", (org.rascalmpl.java.lang.Object)name));
    }

    public static CommandPayload GET_ELEMENT_VALUE_OF_CSS_PROPERTY(String id, String name) {
        return new CommandPayload((String)"org.rascalmpl.getElementValueOfCssProperty", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id, (org.rascalmpl.java.lang.Object)"org.rascalmpl.propertyName", (org.rascalmpl.java.lang.Object)name));
    }

    public static CommandPayload GET_ELEMENT_ARIA_ROLE(String id) {
        return new CommandPayload((String)"org.rascalmpl.getElementAriaRole", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id));
    }

    public static CommandPayload GET_ELEMENT_ACCESSIBLE_NAME(String id) {
        return new CommandPayload((String)"org.rascalmpl.getElementAccessibleName", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id));
    }

    public static CommandPayload ELEMENT_SCREENSHOT(String id) {
        return new CommandPayload((String)"org.rascalmpl.elementScreenshot", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.id", (org.rascalmpl.java.lang.Object)id));
    }

    public static CommandPayload SET_ALERT_VALUE(String keysToSend) {
        return new CommandPayload((String)"org.rascalmpl.setAlertValue", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.text", (org.rascalmpl.java.lang.Object)keysToSend));
    }

    public static CommandPayload PRINT_PAGE(PrintOptions options) {
        return new CommandPayload((String)"org.rascalmpl.printPage", options.toMap());
    }

    @Deprecated
    public static CommandPayload SET_IMPLICIT_WAIT_TIMEOUT(long time, TimeUnit unit) {
        return new CommandPayload((String)"org.rascalmpl.setTimeout", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.implicit", (org.rascalmpl.java.lang.Object)Long.valueOf((long)TimeUnit.MILLISECONDS.convert(time, unit))));
    }

    public static CommandPayload SET_IMPLICIT_WAIT_TIMEOUT(Duration duration) {
        return new CommandPayload((String)"org.rascalmpl.setTimeout", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.implicit", (org.rascalmpl.java.lang.Object)Long.valueOf((long)duration.toMillis())));
    }

    @Deprecated
    public static CommandPayload SET_SCRIPT_TIMEOUT(long time, TimeUnit unit) {
        return new CommandPayload((String)"org.rascalmpl.setTimeout", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.script", (org.rascalmpl.java.lang.Object)Long.valueOf((long)TimeUnit.MILLISECONDS.convert(time, unit))));
    }

    public static CommandPayload SET_SCRIPT_TIMEOUT(Duration duration) {
        return new CommandPayload((String)"org.rascalmpl.setTimeout", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.script", (org.rascalmpl.java.lang.Object)Long.valueOf((long)duration.toMillis())));
    }

    @Deprecated
    public static CommandPayload SET_PAGE_LOAD_TIMEOUT(long time, TimeUnit unit) {
        return new CommandPayload((String)"org.rascalmpl.setTimeout", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.pageLoad", (org.rascalmpl.java.lang.Object)Long.valueOf((long)TimeUnit.MILLISECONDS.convert(time, unit))));
    }

    public static CommandPayload SET_PAGE_LOAD_TIMEOUT(Duration duration) {
        return new CommandPayload((String)"org.rascalmpl.setTimeout", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.pageLoad", (org.rascalmpl.java.lang.Object)Long.valueOf((long)duration.toMillis())));
    }

    public static CommandPayload ACTIONS(Collection<Sequence> actions) {
        return new CommandPayload((String)"org.rascalmpl.actions", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.actions", actions));
    }

    public static CommandPayload IME_ACTIVATE_ENGINE(String engine) {
        return new CommandPayload((String)"org.rascalmpl.setAlertValue", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.engine", (org.rascalmpl.java.lang.Object)engine));
    }

    public static CommandPayload SET_CURRENT_WINDOW_POSITION(Point targetPosition) {
        return new CommandPayload((String)"org.rascalmpl.setWindowPosition", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.x", (org.rascalmpl.java.lang.Object)Integer.valueOf((int)targetPosition.x), (org.rascalmpl.java.lang.Object)"org.rascalmpl.y", (org.rascalmpl.java.lang.Object)Integer.valueOf((int)targetPosition.y)));
    }

    public static CommandPayload GET_CURRENT_WINDOW_POSITION() {
        return new CommandPayload((String)"org.rascalmpl.getWindowPosition", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.windowHandle", (org.rascalmpl.java.lang.Object)"org.rascalmpl.current"));
    }

    public static CommandPayload SET_CURRENT_WINDOW_SIZE(Dimension targetSize) {
        return new CommandPayload((String)"org.rascalmpl.setCurrentWindowSize", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.width", (org.rascalmpl.java.lang.Object)Integer.valueOf((int)targetSize.width), (org.rascalmpl.java.lang.Object)"org.rascalmpl.height", (org.rascalmpl.java.lang.Object)Integer.valueOf((int)targetSize.height)));
    }

    public static CommandPayload SELECT_ACCOUNT(int index) {
        return new CommandPayload((String)"org.rascalmpl.selectAccount", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.accountIndex", (org.rascalmpl.java.lang.Object)Integer.valueOf((int)index)));
    }

    public static CommandPayload SET_DELAY_ENABLED(boolean enabled) {
        return new CommandPayload((String)"org.rascalmpl.setDelayEnabled", Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.enabled", (org.rascalmpl.java.lang.Object)Boolean.valueOf((boolean)enabled)));
    }
}

