/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.remote.codec;

import org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.java.lang.ClassCastException;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.java.lang.reflect.Type;
import org.rascalmpl.java.nio.charset.StandardCharsets;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.Optional;
import org.rascalmpl.java.util.function.Supplier;
import org.rascalmpl.org.openqa.selenium.json.Json;
import org.rascalmpl.org.openqa.selenium.json.JsonException;
import org.rascalmpl.org.openqa.selenium.remote.ErrorCodes;
import org.rascalmpl.org.openqa.selenium.remote.Response;
import org.rascalmpl.org.openqa.selenium.remote.ResponseCodec;
import org.rascalmpl.org.openqa.selenium.remote.http.Contents;
import org.rascalmpl.org.openqa.selenium.remote.http.HttpHeader;
import org.rascalmpl.org.openqa.selenium.remote.http.HttpResponse;

public abstract class AbstractHttpResponseCodec
extends Object
implements ResponseCodec<HttpResponse> {
    private final ErrorCodes errorCodes = new ErrorCodes();
    private final Json json = new Json();

    @Override
    public HttpResponse encode(Supplier<HttpResponse> factory, Response response) {
        int status = response.getStatus().intValue() == 0 ? 200 : 500;
        byte[] data = this.json.toJson(this.getValueToEncode(response)).getBytes(StandardCharsets.UTF_8);
        HttpResponse httpResponse = (HttpResponse)factory.get();
        httpResponse.setStatus(status);
        httpResponse.setHeader(HttpHeader.CacheControl.getName(), (String)"org.rascalmpl.no-cache");
        httpResponse.setHeader(HttpHeader.Expires.getName(), (String)"org.rascalmpl.Thu, 01 Jan 1970 00:00:00 GMT");
        httpResponse.setHeader(HttpHeader.ContentLength.getName(), String.valueOf((int)data.length));
        httpResponse.setHeader(HttpHeader.ContentType.getName(), (String)"org/rascalmpl/application/json; charset=utf-8");
        httpResponse.setContent(Contents.bytes(data));
        return httpResponse;
    }

    protected abstract Object getValueToEncode(Response var1);

    @Override
    public Response decode(HttpResponse encodedResponse) {
        String content;
        block18: {
            String contentType = (String)Objects.requireNonNullElse((Object)encodedResponse.getHeader(HttpHeader.ContentType.getName()), (Object)"org.rascalmpl.");
            content = Contents.string(encodedResponse).trim();
            try {
                return this.reconstructValue((Response)((java.lang.Object)this.json.toType(content, (Type)Response.class)));
            }
            catch (JsonException e) {
                if (contentType.startsWith((String)"org/rascalmpl/application/json")) {
                    throw new IllegalArgumentException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.Cannot decode response content: \u0001"}, (String)content), (Throwable)((java.lang.Object)e));
                }
            }
            catch (ClassCastException e) {
                if (!contentType.startsWith((String)"org/rascalmpl/application/json")) break block18;
                if (content.isEmpty()) {
                    return new Response();
                }
                throw new IllegalArgumentException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.Cannot decode response content: \u0001"}, (String)content), (Throwable)((java.lang.Object)e));
            }
        }
        Response response = new Response();
        int statusCode = encodedResponse.getStatus();
        if (statusCode < 200 || statusCode > 299) {
            if (statusCode > 399 && statusCode < 500) {
                response.setStatus(Integer.valueOf((int)9));
            } else {
                response.setStatus(Integer.valueOf((int)13));
            }
        }
        if (!content.isEmpty()) {
            response.setValue((Object)content);
        }
        if (response.getValue() instanceof String) {
            response.setValue((Object)((String)response.getValue()).replace((CharSequence)"org.rascalmpl.\r\n", (CharSequence)"org.rascalmpl.\n"));
        }
        if (response.getStatus() != null && response.getState() == null) {
            response.setState(this.errorCodes.toState(response.getStatus()));
        } else if (response.getStatus() == null && response.getState() != null) {
            response.setStatus(Integer.valueOf((int)this.errorCodes.toStatus(response.getState(), (Optional<Integer>)Optional.of((Object)Integer.valueOf((int)encodedResponse.getStatus())))));
        } else if (statusCode == 200) {
            response.setStatus(Integer.valueOf((int)0));
            response.setState(this.errorCodes.toState(Integer.valueOf((int)0)));
        }
        if (response.getStatus() != null) {
            response.setState(this.errorCodes.toState(response.getStatus()));
        } else if (statusCode == 200) {
            response.setState(this.errorCodes.toState(Integer.valueOf((int)0)));
        }
        return response;
    }

    protected abstract Response reconstructValue(Response var1);
}

