/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.remote.codec.w3c;

import org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.Optional;
import org.rascalmpl.java.util.function.Function;
import org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.org.openqa.selenium.UnhandledAlertException;
import org.rascalmpl.org.openqa.selenium.WebDriverException;
import org.rascalmpl.org.openqa.selenium.json.Json;
import org.rascalmpl.org.openqa.selenium.remote.ErrorCodec;
import org.rascalmpl.org.openqa.selenium.remote.ErrorCodes;
import org.rascalmpl.org.openqa.selenium.remote.JsonToWebElementConverter;
import org.rascalmpl.org.openqa.selenium.remote.Response;
import org.rascalmpl.org.openqa.selenium.remote.codec.AbstractHttpResponseCodec;
import org.rascalmpl.org.openqa.selenium.remote.http.Contents;
import org.rascalmpl.org.openqa.selenium.remote.http.HttpHeader;
import org.rascalmpl.org.openqa.selenium.remote.http.HttpResponse;

public class W3CHttpResponseCodec
extends AbstractHttpResponseCodec {
    private static final Logger LOG = Logger.getLogger((String)W3CHttpResponseCodec.class.getName());
    private final ErrorCodec errorCodec = ErrorCodec.createDefault();
    private final ErrorCodes errorCodes = new ErrorCodes();
    private final Json json = new Json();
    private final Function<org.rascalmpl.java.lang.Object, org.rascalmpl.java.lang.Object> elementConverter = new JsonToWebElementConverter(null);

    @Override
    public Response decode(HttpResponse encodedResponse) {
        String content = Contents.string(encodedResponse).trim();
        LOG.log(Level.FINER, (String)"org.rascalmpl.Decoding response. Response code was: {0} and content: {1}", new org.rascalmpl.java.lang.Object[]{Integer.valueOf((int)encodedResponse.getStatus()), content});
        String contentType = (String)Objects.requireNonNullElse((org.rascalmpl.java.lang.Object)encodedResponse.getHeader(HttpHeader.ContentType.getName()), (org.rascalmpl.java.lang.Object)"org.rascalmpl.");
        Response response = new Response();
        if (!encodedResponse.isSuccessful()) {
            LOG.fine((String)"org.rascalmpl.Processing an error");
            if (405 == encodedResponse.getStatus()) {
                response.setState((String)"org.rascalmpl.unknown command");
                response.setStatus(Integer.valueOf((int)9));
                response.setValue((org.rascalmpl.java.lang.Object)content);
            } else if (504 == encodedResponse.getStatus() || 502 == encodedResponse.getStatus()) {
                response.setState((String)"org.rascalmpl.unknown error");
                response.setStatus(Integer.valueOf((int)13));
                response.setValue((org.rascalmpl.java.lang.Object)content);
            } else {
                Map org = (Map)this.json.toType(content, Json.MAP_TYPE);
                org.rascalmpl.java.lang.Object w3cWrappedValue = org.get((org.rascalmpl.java.lang.Object)"org.rascalmpl.value");
                Map obj = w3cWrappedValue instanceof Map && ((Map)w3cWrappedValue).containsKey((org.rascalmpl.java.lang.Object)"org.rascalmpl.error") ? (Map)w3cWrappedValue : org;
                java.lang.String message = "org.rascalmpl.An unknown error has occurred";
                if (obj.get((org.rascalmpl.java.lang.Object)"org.rascalmpl.message") instanceof String) {
                    message = (String)obj.get((org.rascalmpl.java.lang.Object)"org.rascalmpl.message");
                }
                java.lang.String error = "org.rascalmpl.unknown error";
                if (obj.get((org.rascalmpl.java.lang.Object)"org.rascalmpl.error") instanceof String) {
                    error = (String)obj.get((org.rascalmpl.java.lang.Object)"org.rascalmpl.error");
                }
                response.setState((String)error);
                response.setStatus(Integer.valueOf((int)this.errorCodes.toStatus((String)error, (Optional<Integer>)Optional.of((org.rascalmpl.java.lang.Object)Integer.valueOf((int)encodedResponse.getStatus())))));
                if ("org.rascalmpl.unexpected alert open".equals((org.rascalmpl.java.lang.Object)error) && 500 == encodedResponse.getStatus()) {
                    org.rascalmpl.java.lang.Object rawText;
                    java.lang.String text = "org.rascalmpl.";
                    org.rascalmpl.java.lang.Object data = obj.get((org.rascalmpl.java.lang.Object)"org.rascalmpl.data");
                    if (data != null && (rawText = ((Map)data).get((org.rascalmpl.java.lang.Object)"org.rascalmpl.text")) instanceof String) {
                        text = (String)rawText;
                    }
                    response.setValue((org.rascalmpl.java.lang.Object)new UnhandledAlertException((String)message, (String)text));
                } else {
                    response.setValue((org.rascalmpl.java.lang.Object)this.errorCodec.decode((Map<String, org.rascalmpl.java.lang.Object>)org));
                }
            }
            return response;
        }
        response.setState((String)"org.rascalmpl.success");
        response.setStatus(Integer.valueOf((int)0));
        if (!content.isEmpty() && contentType.startsWith((String)"org/rascalmpl/application/json")) {
            Map parsed = (Map)this.json.toType(content, Json.MAP_TYPE);
            if (parsed.containsKey((org.rascalmpl.java.lang.Object)"org.rascalmpl.value")) {
                org.rascalmpl.java.lang.Object value = parsed.get((org.rascalmpl.java.lang.Object)"org.rascalmpl.value");
                response.setValue(value);
            } else {
                response.setValue((org.rascalmpl.java.lang.Object)this.json.toType(content, Json.OBJECT_TYPE));
            }
        }
        if (response.getValue() instanceof String) {
            response.setValue((org.rascalmpl.java.lang.Object)((String)response.getValue()).replace((CharSequence)"org.rascalmpl.\r\n", (CharSequence)"org.rascalmpl.\n"));
        }
        return response;
    }

    @Override
    protected org.rascalmpl.java.lang.Object getValueToEncode(Response response) {
        Map<String, org.rascalmpl.java.lang.Object> value = response.getValue();
        if (value instanceof WebDriverException) {
            value = this.errorCodec.encode((Throwable)((Object)((WebDriverException)value)));
        }
        return Map.of((org.rascalmpl.java.lang.Object)"org.rascalmpl.value", (org.rascalmpl.java.lang.Object)value);
    }

    @Override
    protected Response reconstructValue(Response response) {
        response.setValue(this.elementConverter.apply(response.getValue()));
        return response;
    }
}

