/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.remote.tracing.opentelemetry;

import org.rascalmpl.io.opentelemetry.api.trace.Span;
import org.rascalmpl.io.opentelemetry.api.trace.SpanContext;
import org.rascalmpl.io.opentelemetry.api.trace.Tracer;
import org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.io.opentelemetry.context.Scope;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.concurrent.Callable;
import org.rascalmpl.org.openqa.selenium.internal.Require;
import org.rascalmpl.org.openqa.selenium.remote.tracing.TraceContext;
import org.rascalmpl.org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetrySpan;

public class OpenTelemetryContext
extends Object
implements TraceContext {
    private final Tracer tracer;
    private final Context context;
    private final SpanContext spanContext;

    public OpenTelemetryContext(Tracer tracer, Context context) {
        this.tracer = Require.nonNull((String)"org.rascalmpl.Tracer", tracer);
        this.context = Require.nonNull((String)"org.rascalmpl.Context", context);
        this.spanContext = Span.fromContext(context).getSpanContext();
    }

    @Override
    public String getId() {
        return this.spanContext.getSpanId();
    }

    @Override
    public OpenTelemetrySpan createSpan(String name) {
        Require.nonNull((String)"org.rascalmpl.Name", name);
        Span span = this.tracer.spanBuilder(name).setParent(this.context).startSpan();
        Context prev = Context.current();
        Scope scope = span.makeCurrent();
        if (prev.equals(Context.current())) {
            throw new IllegalStateException((String)"org.rascalmpl.Context has not been changed");
        }
        return new OpenTelemetrySpan(this.tracer, Context.current(), span, scope);
    }

    Context getContext() {
        return this.context;
    }

    @Override
    public Runnable wrap(Runnable runnable) {
        return this.context.wrap(runnable);
    }

    @Override
    public <V extends Object> Callable<V> wrap(Callable<V> callable) {
        return this.context.wrap(callable);
    }

    public boolean equals(Object o) {
        if (!(o instanceof OpenTelemetryContext)) {
            return false;
        }
        OpenTelemetryContext that = (OpenTelemetryContext)o;
        return Objects.equals((Object)this.context, (Object)that.context);
    }

    public int hashCode() {
        return Objects.hash((Object[])new Object[]{this.context});
    }

    public String toString() {
        return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.OpenTelemetryContext{tracer=\u0001, context=\u0001, span id=\u0001, trace id=\u0001}"}, (String)String.valueOf((Object)this.tracer), (String)String.valueOf((Object)this.context), (String)this.spanContext.getSpanId(), (String)this.spanContext.getTraceId());
    }
}

