/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.remote.tracing.opentelemetry;

import org.rascalmpl.io.opentelemetry.api.trace.SpanContext;
import org.rascalmpl.io.opentelemetry.api.trace.StatusCode;
import org.rascalmpl.io.opentelemetry.api.trace.Tracer;
import org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.io.opentelemetry.context.Scope;
import org.rascalmpl.java.lang.AutoCloseable;
import org.rascalmpl.java.lang.Double;
import org.rascalmpl.java.lang.Float;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.Number;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.org.openqa.selenium.internal.Require;
import org.rascalmpl.org.openqa.selenium.remote.tracing.AttributeMap;
import org.rascalmpl.org.openqa.selenium.remote.tracing.Span;
import org.rascalmpl.org.openqa.selenium.remote.tracing.Status;
import org.rascalmpl.org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetryAttributeMap;
import org.rascalmpl.org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetryContext;

class OpenTelemetrySpan
extends OpenTelemetryContext
implements AutoCloseable,
Span {
    private final org.rascalmpl.io.opentelemetry.api.trace.Span span;
    private final Scope scope;
    private static final Map<Status.Kind, StatusCode> statuses = Map.ofEntries((Map.Entry[])new Map.Entry[]{Map.entry((org.rascalmpl.java.lang.Object)Status.Kind.ABORTED, (org.rascalmpl.java.lang.Object)StatusCode.ERROR), Map.entry((org.rascalmpl.java.lang.Object)Status.Kind.CANCELLED, (org.rascalmpl.java.lang.Object)StatusCode.ERROR), Map.entry((org.rascalmpl.java.lang.Object)Status.Kind.NOT_FOUND, (org.rascalmpl.java.lang.Object)StatusCode.ERROR), Map.entry((org.rascalmpl.java.lang.Object)Status.Kind.OK, (org.rascalmpl.java.lang.Object)StatusCode.OK), Map.entry((org.rascalmpl.java.lang.Object)Status.Kind.RESOURCE_EXHAUSTED, (org.rascalmpl.java.lang.Object)StatusCode.ERROR), Map.entry((org.rascalmpl.java.lang.Object)Status.Kind.UNKNOWN, (org.rascalmpl.java.lang.Object)StatusCode.ERROR), Map.entry((org.rascalmpl.java.lang.Object)Status.Kind.INVALID_ARGUMENT, (org.rascalmpl.java.lang.Object)StatusCode.ERROR), Map.entry((org.rascalmpl.java.lang.Object)Status.Kind.DEADLINE_EXCEEDED, (org.rascalmpl.java.lang.Object)StatusCode.ERROR), Map.entry((org.rascalmpl.java.lang.Object)Status.Kind.ALREADY_EXISTS, (org.rascalmpl.java.lang.Object)StatusCode.ERROR), Map.entry((org.rascalmpl.java.lang.Object)Status.Kind.PERMISSION_DENIED, (org.rascalmpl.java.lang.Object)StatusCode.ERROR), Map.entry((org.rascalmpl.java.lang.Object)Status.Kind.OUT_OF_RANGE, (org.rascalmpl.java.lang.Object)StatusCode.ERROR), Map.entry((org.rascalmpl.java.lang.Object)Status.Kind.UNIMPLEMENTED, (org.rascalmpl.java.lang.Object)StatusCode.ERROR), Map.entry((org.rascalmpl.java.lang.Object)Status.Kind.INTERNAL, (org.rascalmpl.java.lang.Object)StatusCode.ERROR), Map.entry((org.rascalmpl.java.lang.Object)Status.Kind.UNAVAILABLE, (org.rascalmpl.java.lang.Object)StatusCode.ERROR), Map.entry((org.rascalmpl.java.lang.Object)Status.Kind.UNAUTHENTICATED, (org.rascalmpl.java.lang.Object)StatusCode.ERROR)});

    public OpenTelemetrySpan(Tracer tracer, Context context, org.rascalmpl.io.opentelemetry.api.trace.Span span, Scope scope) {
        super(tracer, context);
        this.span = Require.nonNull((String)"org.rascalmpl.Span", span);
        this.scope = Require.nonNull((String)"org.rascalmpl.Scope", scope);
    }

    @Override
    public Span setName(String name) {
        this.span.updateName(Require.nonNull((String)"org.rascalmpl.Name to update to", name));
        return this;
    }

    @Override
    public Span setAttribute(String key, boolean value) {
        this.span.setAttribute(Require.nonNull((String)"org.rascalmpl.Key", key), value);
        return this;
    }

    @Override
    public Span setAttribute(String key, Number value) {
        Require.nonNull((String)"org.rascalmpl.Key", key);
        Require.nonNull((String)"org.rascalmpl.Value", value);
        if (value instanceof Double || value instanceof Float) {
            this.span.setAttribute(key, value.doubleValue());
        } else {
            this.span.setAttribute(key, value.longValue());
        }
        return this;
    }

    @Override
    public Span setAttribute(String key, String value) {
        Require.nonNull((String)"org.rascalmpl.Key", key);
        Require.nonNull((String)"org.rascalmpl.Value", value);
        this.span.setAttribute(key, value);
        return this;
    }

    @Override
    public Span addEvent(String name) {
        Require.nonNull((String)"org.rascalmpl.Name", name);
        this.span.addEvent(name);
        return this;
    }

    @Override
    public Span addEvent(String name, AttributeMap attributeMap) {
        Require.nonNull((String)"org.rascalmpl.Name", name);
        Require.nonNull((String)"org.rascalmpl.Event Attribute Map", attributeMap);
        this.span.addEvent(name, ((OpenTelemetryAttributeMap)attributeMap).build());
        return this;
    }

    @Override
    public Span setStatus(Status status) {
        Require.nonNull((String)"org.rascalmpl.Status", status);
        StatusCode statusCode = (StatusCode)statuses.get((org.rascalmpl.java.lang.Object)status.getKind());
        if (statusCode == null) {
            throw new IllegalArgumentException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.Unrecognized status kind: \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)status.getKind())));
        }
        this.span.setStatus(statusCode, (String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.Kind: \u0001 Description:\u0001"}, (String)status.getKind().toString(), (String)status.getDescription()));
        return this;
    }

    @Override
    public void close() {
        this.scope.close();
        this.span.end();
    }

    @Override
    public String toString() {
        SpanContext context = this.span.getSpanContext();
        return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.OpenTelemetrySpan{traceId=\u0001,spanId=\u0001}"}, (String)context.getTraceId(), (String)context.getSpanId());
    }

    @Override
    public boolean equals(org.rascalmpl.java.lang.Object o) {
        if (o instanceof OpenTelemetryContext && !(o instanceof OpenTelemetrySpan)) {
            return false;
        }
        if (!(o instanceof OpenTelemetrySpan)) {
            return false;
        }
        OpenTelemetrySpan that = (OpenTelemetrySpan)o;
        SpanContext thisContext = this.span.getSpanContext();
        SpanContext thatContext = that.span.getSpanContext();
        return Objects.equals((org.rascalmpl.java.lang.Object)thisContext.getSpanId(), (org.rascalmpl.java.lang.Object)thatContext.getSpanId()) && Objects.equals((org.rascalmpl.java.lang.Object)thisContext.getTraceId(), (org.rascalmpl.java.lang.Object)thatContext.getTraceId());
    }

    @Override
    public int hashCode() {
        return Objects.hash((org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.span});
    }
}

