/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.safari;

import org.rascalmpl.com.google.auto.service.AutoService;
import org.rascalmpl.java.io.File;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.OutputStream;
import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.org.openqa.selenium.Capabilities;
import org.rascalmpl.org.openqa.selenium.WebDriverException;
import org.rascalmpl.org.openqa.selenium.net.PortProber;
import org.rascalmpl.org.openqa.selenium.remote.Browser;
import org.rascalmpl.org.openqa.selenium.remote.service.DriverService;
import org.rascalmpl.org.openqa.selenium.safari.SafariOptions;

public class SafariTechPreviewDriverService
extends DriverService {
    public static final String TP_SAFARI_DRIVER_NAME = "org.rascalmpl.safaridriver";
    public static final String TP_SAFARI_DRIVER_EXE_PROPERTY = "org.rascalmpl.webdriver.tp.safari.driver";
    public static final String TP_SAFARI_DRIVER_LOGGING = "org.rascalmpl.webdriver.tp.safari.logging";
    private static final File TP_SAFARI_DRIVER_EXECUTABLE = new File((String)"org/rascalmpl//Applications/Safari Technology Preview.app/Contents/MacOS/safaridriver");

    public SafariTechPreviewDriverService(File executable, int port, Duration timeout, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, timeout, (List<String>)Collections.unmodifiableList((List)new ArrayList(args)), (Map<String, String>)Collections.unmodifiableMap((Map)new HashMap(environment)));
    }

    @Override
    public String getDriverName() {
        return "org.rascalmpl.safaridriver";
    }

    @Override
    public String getDriverProperty() {
        return "org.rascalmpl.webdriver.tp.safari.driver";
    }

    @Override
    public File getDriverExecutable() {
        return TP_SAFARI_DRIVER_EXECUTABLE;
    }

    @Override
    public Capabilities getDefaultDriverOptions() {
        return new SafariOptions().setUseTechnologyPreview(true);
    }

    public static SafariTechPreviewDriverService createDefaultService() {
        return (SafariTechPreviewDriverService)((Object)new Builder().build());
    }

    @Override
    protected void waitUntilAvailable() {
        try {
            PortProber.waitForPortUp(this.getUrl().getPort(), (int)this.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (RuntimeException e) {
            throw new WebDriverException((Throwable)((Object)e));
        }
    }

    @AutoService(value={DriverService.Builder.class})
    public static class Builder
    extends DriverService.Builder<SafariTechPreviewDriverService, Builder> {
        private Boolean diagnose;

        @Override
        public int score(Capabilities capabilities) {
            int score = 0;
            if (Browser.SAFARI_TECH_PREVIEW.browserName().equals((org.rascalmpl.java.lang.Object)capabilities.getBrowserName())) {
                ++score;
            }
            return score;
        }

        public Builder withLogging(Boolean logging) {
            this.diagnose = logging;
            return this;
        }

        @Override
        public Builder withLogFile(File logFile) {
            throw new WebDriverException((String)"org/rascalmpl/Can not set log location for Safari; use withLogging(true) and locate log in ~/Library/Logs/com.apple.WebDriver/");
        }

        @Override
        protected void loadSystemProperties() {
            if (this.diagnose == null) {
                this.diagnose = Boolean.valueOf((boolean)Boolean.getBoolean((String)"org.rascalmpl.webdriver.tp.safari.logging"));
            }
        }

        @Override
        protected List<String> createArgs() {
            ArrayList args = new ArrayList((Collection)Arrays.asList((org.rascalmpl.java.lang.Object[])new String[]{"org.rascalmpl.--port", String.valueOf((int)this.getPort())}));
            if (Boolean.TRUE.equals((org.rascalmpl.java.lang.Object)this.diagnose)) {
                args.add((org.rascalmpl.java.lang.Object)"org.rascalmpl.--diagnose");
            }
            return args;
        }

        @Override
        protected SafariTechPreviewDriverService createDriverService(File exe, int port, Duration timeout, List<String> args, Map<String, String> environment) {
            try {
                this.withLogOutput(OutputStream.nullOutputStream());
                return new SafariTechPreviewDriverService(exe, port, timeout, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)((Object)e));
            }
        }
    }
}

