/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.support;

import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.IllegalAccessException;
import org.rascalmpl.java.lang.NoSuchMethodException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.ReflectiveOperationException;
import org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.lang.reflect.Constructor;
import org.rascalmpl.java.lang.reflect.Field;
import org.rascalmpl.org.openqa.selenium.SearchContext;
import org.rascalmpl.org.openqa.selenium.WebDriver;
import org.rascalmpl.org.openqa.selenium.support.pagefactory.DefaultElementLocatorFactory;
import org.rascalmpl.org.openqa.selenium.support.pagefactory.DefaultFieldDecorator;
import org.rascalmpl.org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.rascalmpl.org.openqa.selenium.support.pagefactory.FieldDecorator;

public class PageFactory
extends Object {
    public static <T extends Object> T initElements(SearchContext searchContext, Class<T> pageClassToProxy) {
        T page = PageFactory.instantiatePage(searchContext, pageClassToProxy);
        PageFactory.initElements(searchContext, page);
        return page;
    }

    public static void initElements(SearchContext searchContext, Object page) {
        PageFactory.initElements(new DefaultElementLocatorFactory(searchContext), page);
    }

    public static void initElements(ElementLocatorFactory factory, Object page) {
        PageFactory.initElements(new DefaultFieldDecorator(factory), page);
    }

    public static void initElements(FieldDecorator decorator, Object page) {
        for (Class proxyIn = page.getClass(); proxyIn != Object.class; proxyIn = proxyIn.getSuperclass()) {
            PageFactory.proxyFields(decorator, page, proxyIn);
        }
    }

    private static void proxyFields(FieldDecorator decorator, Object page, Class<?> proxyIn) {
        Field[] fields;
        for (Field field : fields = proxyIn.getDeclaredFields()) {
            Object value = decorator.decorate(page.getClass().getClassLoader(), field);
            if (value == null) continue;
            try {
                field.setAccessible(true);
                field.set(page, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException((Throwable)((java.lang.Object)e));
            }
        }
    }

    private static <T extends Object> T instantiatePage(SearchContext searchContext, Class<T> pageClassToProxy) {
        try {
            try {
                Constructor constructor = pageClassToProxy.getConstructor(new Class[]{WebDriver.class});
                return (T)constructor.newInstance(new Object[]{searchContext});
            }
            catch (NoSuchMethodException e) {
                return (T)pageClassToProxy.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException((Throwable)((java.lang.Object)e));
        }
    }
}

