/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.support;

import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.ClassLoader;
import org.rascalmpl.java.lang.IllegalAccessException;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.Thread;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.lang.reflect.InvocationHandler;
import org.rascalmpl.java.lang.reflect.InvocationTargetException;
import org.rascalmpl.java.lang.reflect.Method;
import org.rascalmpl.java.lang.reflect.Proxy;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.HashSet;
import org.rascalmpl.org.openqa.selenium.WebDriver;
import org.rascalmpl.org.openqa.selenium.WebDriverException;

public class ThreadGuard
extends Object {
    public static WebDriver protect(WebDriver actualWebDriver) {
        WebDriverInvocationHandler invocationHandler = new WebDriverInvocationHandler(actualWebDriver);
        return (WebDriver)Proxy.newProxyInstance((ClassLoader)actualWebDriver.getClass().getClassLoader(), ThreadGuard.getInterfaces(actualWebDriver), (InvocationHandler)invocationHandler);
    }

    private static Class<?>[] getInterfaces(Object target) {
        Class base = target.getClass();
        HashSet interfaces = new HashSet();
        if (base.isInterface()) {
            interfaces.add((Object)base);
        }
        while (base != null && !Object.class.equals((Object)base)) {
            interfaces.addAll((Collection)Arrays.asList((Object[])base.getInterfaces()));
            base = base.getSuperclass();
        }
        return (Class[])interfaces.toArray((Object[])new Class[0]);
    }

    static class WebDriverInvocationHandler
    extends Object
    implements InvocationHandler {
        private final long threadId;
        private final Object underlying;
        private final String threadName;

        public WebDriverInvocationHandler(Object underlyingWebDriver) {
            Thread thread = Thread.currentThread();
            this.threadId = thread.getId();
            this.threadName = thread.getName();
            this.underlying = underlyingWebDriver;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (Thread.currentThread().getId() != this.threadId) {
                    Thread currentThread = Thread.currentThread();
                    throw new WebDriverException(String.format((String)"org.rascalmpl.Thread safety error; this instance of WebDriver was constructed on thread %s (id %d) and is being accessed by thread %s (id %d)This is not permitted and *will* cause undefined behaviour", (Object[])new Object[]{this.threadName, Long.valueOf((long)this.threadId), currentThread.getName(), Long.valueOf((long)currentThread.getId())}));
                }
                return this.invokeUnderlying(method, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        protected Object invokeUnderlying(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
            return method.invoke(this.underlying, args);
        }
    }
}

