/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.support.pagefactory;

import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.ClassLoader;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.reflect.Field;
import org.rascalmpl.java.lang.reflect.InvocationHandler;
import org.rascalmpl.java.lang.reflect.ParameterizedType;
import org.rascalmpl.java.lang.reflect.Proxy;
import org.rascalmpl.java.lang.reflect.Type;
import org.rascalmpl.java.util.List;
import org.rascalmpl.org.openqa.selenium.WebElement;
import org.rascalmpl.org.openqa.selenium.WrapsElement;
import org.rascalmpl.org.openqa.selenium.interactions.Locatable;
import org.rascalmpl.org.openqa.selenium.support.FindAll;
import org.rascalmpl.org.openqa.selenium.support.FindBy;
import org.rascalmpl.org.openqa.selenium.support.FindBys;
import org.rascalmpl.org.openqa.selenium.support.pagefactory.ElementLocator;
import org.rascalmpl.org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.rascalmpl.org.openqa.selenium.support.pagefactory.FieldDecorator;
import org.rascalmpl.org.openqa.selenium.support.pagefactory.internal.LocatingElementHandler;
import org.rascalmpl.org.openqa.selenium.support.pagefactory.internal.LocatingElementListHandler;

public class DefaultFieldDecorator
extends Object
implements FieldDecorator {
    protected ElementLocatorFactory factory;

    public DefaultFieldDecorator(ElementLocatorFactory factory) {
        this.factory = factory;
    }

    @Override
    public Object decorate(ClassLoader loader, Field field) {
        if (!WebElement.class.isAssignableFrom(field.getType()) && !this.isDecoratableList(field)) {
            return null;
        }
        ElementLocator locator = this.factory.createLocator(field);
        if (locator == null) {
            return null;
        }
        if (WebElement.class.isAssignableFrom(field.getType())) {
            return this.proxyForLocator(loader, locator);
        }
        if (List.class.isAssignableFrom(field.getType())) {
            return this.proxyForListLocator(loader, locator);
        }
        return null;
    }

    protected boolean isDecoratableList(Field field) {
        if (!List.class.isAssignableFrom(field.getType())) {
            return false;
        }
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return false;
        }
        Type listType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
        if (!WebElement.class.equals((Object)listType)) {
            return false;
        }
        return field.getAnnotation(FindBy.class) != null || field.getAnnotation(FindBys.class) != null || field.getAnnotation(FindAll.class) != null;
    }

    protected WebElement proxyForLocator(ClassLoader loader, ElementLocator locator) {
        LocatingElementHandler handler = new LocatingElementHandler(locator);
        WebElement proxy = (WebElement)Proxy.newProxyInstance((ClassLoader)loader, (Class[])new Class[]{WebElement.class, WrapsElement.class, Locatable.class}, (InvocationHandler)handler);
        return proxy;
    }

    protected List<WebElement> proxyForListLocator(ClassLoader loader, ElementLocator locator) {
        LocatingElementListHandler handler = new LocatingElementListHandler(locator);
        List proxy = (List)Proxy.newProxyInstance((ClassLoader)loader, (Class[])new Class[]{List.class}, (InvocationHandler)handler);
        return proxy;
    }
}

