/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.support.ui;

import org.rascalmpl.com.google.common.base.Joiner;
import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.java.lang.Exception;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Optional;
import org.rascalmpl.java.util.regex.Pattern;
import org.rascalmpl.org.openqa.selenium.Alert;
import org.rascalmpl.org.openqa.selenium.By;
import org.rascalmpl.org.openqa.selenium.JavascriptExecutor;
import org.rascalmpl.org.openqa.selenium.NoAlertPresentException;
import org.rascalmpl.org.openqa.selenium.NoSuchElementException;
import org.rascalmpl.org.openqa.selenium.NoSuchFrameException;
import org.rascalmpl.org.openqa.selenium.StaleElementReferenceException;
import org.rascalmpl.org.openqa.selenium.WebDriver;
import org.rascalmpl.org.openqa.selenium.WebDriverException;
import org.rascalmpl.org.openqa.selenium.WebElement;
import org.rascalmpl.org.openqa.selenium.support.ui.ExpectedCondition;

public class ExpectedConditions
extends org.rascalmpl.java.lang.Object {
    private ExpectedConditions() {
    }

    public static ExpectedCondition<Boolean> titleIs(final String title) {
        return new ExpectedCondition<Boolean>(){
            private String currentTitle = "org.rascalmpl.";

            @Override
            public Boolean apply(WebDriver driver) {
                this.currentTitle = driver.getTitle();
                return Boolean.valueOf((boolean)title.equals((org.rascalmpl.java.lang.Object)this.currentTitle));
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.title to be \"%s\". Current title: \"%s\"", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{title, this.currentTitle});
            }
        };
    }

    public static ExpectedCondition<Boolean> titleContains(final String title) {
        return new ExpectedCondition<Boolean>(){
            private String currentTitle = "org.rascalmpl.";

            @Override
            public Boolean apply(WebDriver driver) {
                this.currentTitle = driver.getTitle();
                return Boolean.valueOf((this.currentTitle != null && this.currentTitle.contains((CharSequence)title) ? 1 : 0) != 0);
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.title to contain \"%s\". Current title: \"%s\"", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{title, this.currentTitle});
            }
        };
    }

    public static ExpectedCondition<Boolean> urlToBe(final String url) {
        return new ExpectedCondition<Boolean>(){
            private String currentUrl = "org.rascalmpl.";

            @Override
            public Boolean apply(WebDriver driver) {
                this.currentUrl = driver.getCurrentUrl();
                return Boolean.valueOf((this.currentUrl != null && this.currentUrl.equals((org.rascalmpl.java.lang.Object)url) ? 1 : 0) != 0);
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.url to be \"%s\". Current url: \"%s\"", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{url, this.currentUrl});
            }
        };
    }

    public static ExpectedCondition<Boolean> urlContains(final String fraction) {
        return new ExpectedCondition<Boolean>(){
            private String currentUrl = "org.rascalmpl.";

            @Override
            public Boolean apply(WebDriver driver) {
                this.currentUrl = driver.getCurrentUrl();
                return Boolean.valueOf((this.currentUrl != null && this.currentUrl.contains((CharSequence)fraction) ? 1 : 0) != 0);
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.url to contain \"%s\". Current url: \"%s\"", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{fraction, this.currentUrl});
            }
        };
    }

    public static ExpectedCondition<Boolean> urlMatches(final String regex) {
        return new ExpectedCondition<Boolean>(){
            private final Pattern pattern;
            private String currentUrl;
            {
                this.pattern = Pattern.compile((String)regex);
            }

            @Override
            public Boolean apply(WebDriver driver) {
                this.currentUrl = driver.getCurrentUrl();
                return Boolean.valueOf((boolean)this.pattern.matcher((CharSequence)this.currentUrl).find());
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.url to match the regex \"%s\". Current url: \"%s\"", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{regex, this.currentUrl});
            }
        };
    }

    public static ExpectedCondition<WebElement> presenceOfElementLocated(final By locator) {
        return new ExpectedCondition<WebElement>(){

            @Override
            public WebElement apply(WebDriver driver) {
                return driver.findElement(locator);
            }

            public String toString() {
                return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.presence of element located by: \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)locator));
            }
        };
    }

    public static ExpectedCondition<WebElement> visibilityOfElementLocated(final By locator) {
        return new ExpectedCondition<WebElement>(){

            @Override
            public WebElement apply(WebDriver driver) {
                try {
                    return ExpectedConditions.elementIfVisible(driver.findElement(locator));
                }
                catch (NoSuchElementException | StaleElementReferenceException e) {
                    return null;
                }
            }

            public String toString() {
                return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.visibility of element located by \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)locator));
            }
        };
    }

    public static ExpectedCondition<List<WebElement>> visibilityOfAllElementsLocatedBy(final By locator) {
        return new ExpectedCondition<List<WebElement>>(){

            @Override
            public List<WebElement> apply(WebDriver driver) {
                List<WebElement> elements = driver.findElements(locator);
                for (WebElement element : elements) {
                    if (element.isDisplayed()) continue;
                    return null;
                }
                return !elements.isEmpty() ? elements : null;
            }

            public String toString() {
                return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.visibility of all elements located by \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)locator));
            }
        };
    }

    public static ExpectedCondition<List<WebElement>> visibilityOfAllElements(WebElement ... elements) {
        return ExpectedConditions.visibilityOfAllElements((List<WebElement>)Arrays.asList((org.rascalmpl.java.lang.Object[])elements));
    }

    public static ExpectedCondition<List<WebElement>> visibilityOfAllElements(final List<WebElement> elements) {
        return new ExpectedCondition<List<WebElement>>(){

            @Override
            public List<WebElement> apply(WebDriver driver) {
                for (WebElement element : elements) {
                    if (element.isDisplayed()) continue;
                    return null;
                }
                return !elements.isEmpty() ? elements : null;
            }

            public String toString() {
                return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.visibility of all \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)elements));
            }
        };
    }

    public static ExpectedCondition<WebElement> visibilityOf(final WebElement element) {
        return new ExpectedCondition<WebElement>(){

            @Override
            public WebElement apply(WebDriver driver) {
                return ExpectedConditions.elementIfVisible(element);
            }

            public String toString() {
                return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.visibility of \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)element));
            }
        };
    }

    private static WebElement elementIfVisible(WebElement element) {
        return element.isDisplayed() ? element : null;
    }

    public static ExpectedCondition<List<WebElement>> presenceOfAllElementsLocatedBy(final By locator) {
        return new ExpectedCondition<List<WebElement>>(){

            @Override
            public List<WebElement> apply(WebDriver driver) {
                List<WebElement> elements = driver.findElements(locator);
                return !elements.isEmpty() ? elements : null;
            }

            public String toString() {
                return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.presence of any elements located by \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)locator));
            }
        };
    }

    public static ExpectedCondition<Boolean> textToBePresentInElement(final WebElement element, final String text) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                try {
                    String elementText = element.getText();
                    return Boolean.valueOf((boolean)elementText.contains((CharSequence)text));
                }
                catch (StaleElementReferenceException e) {
                    return Boolean.valueOf((boolean)false);
                }
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.text ('%s') to be present in element %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{text, element});
            }
        };
    }

    public static ExpectedCondition<Boolean> textToBePresentInElementLocated(final By locator, final String text) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                try {
                    String elementText = driver.findElement(locator).getText();
                    return Boolean.valueOf((boolean)elementText.contains((CharSequence)text));
                }
                catch (StaleElementReferenceException e) {
                    return Boolean.valueOf((boolean)false);
                }
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.text ('%s') to be present in element found by %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{text, locator});
            }
        };
    }

    public static ExpectedCondition<Boolean> textToBePresentInElementValue(final WebElement element, final String text) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                try {
                    String elementText = element.getAttribute((String)"org.rascalmpl.value");
                    if (elementText != null) {
                        return Boolean.valueOf((boolean)elementText.contains((CharSequence)text));
                    }
                    return Boolean.valueOf((boolean)false);
                }
                catch (StaleElementReferenceException e) {
                    return Boolean.valueOf((boolean)false);
                }
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.text ('%s') to be the value of element %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{text, element});
            }
        };
    }

    public static ExpectedCondition<Boolean> textToBePresentInElementValue(final By locator, final String text) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                try {
                    String elementText = driver.findElement(locator).getAttribute((String)"org.rascalmpl.value");
                    if (elementText != null) {
                        return Boolean.valueOf((boolean)elementText.contains((CharSequence)text));
                    }
                    return Boolean.valueOf((boolean)false);
                }
                catch (StaleElementReferenceException e) {
                    return Boolean.valueOf((boolean)false);
                }
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.text ('%s') to be the value of element located by %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{text, locator});
            }
        };
    }

    public static ExpectedCondition<WebDriver> frameToBeAvailableAndSwitchToIt(final String frameLocator) {
        return new ExpectedCondition<WebDriver>(){

            @Override
            public WebDriver apply(WebDriver driver) {
                try {
                    return driver.switchTo().frame(frameLocator);
                }
                catch (NoSuchFrameException e) {
                    return null;
                }
            }

            public String toString() {
                return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.frame to be available: \u0001"}, (String)frameLocator);
            }
        };
    }

    public static ExpectedCondition<WebDriver> frameToBeAvailableAndSwitchToIt(final By locator) {
        return new ExpectedCondition<WebDriver>(){

            @Override
            public WebDriver apply(WebDriver driver) {
                try {
                    return driver.switchTo().frame(driver.findElement(locator));
                }
                catch (NoSuchFrameException e) {
                    return null;
                }
            }

            public String toString() {
                return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.frame to be available: \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)locator));
            }
        };
    }

    public static ExpectedCondition<WebDriver> frameToBeAvailableAndSwitchToIt(final int frameLocator) {
        return new ExpectedCondition<WebDriver>(){

            @Override
            public WebDriver apply(WebDriver driver) {
                try {
                    return driver.switchTo().frame(frameLocator);
                }
                catch (NoSuchFrameException e) {
                    return null;
                }
            }

            public String toString() {
                return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.frame to be available: \u0001"}, (int)frameLocator);
            }
        };
    }

    public static ExpectedCondition<WebDriver> frameToBeAvailableAndSwitchToIt(final WebElement frameLocator) {
        return new ExpectedCondition<WebDriver>(){

            @Override
            public WebDriver apply(WebDriver driver) {
                try {
                    return driver.switchTo().frame(frameLocator);
                }
                catch (NoSuchFrameException e) {
                    return null;
                }
            }

            public String toString() {
                return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.frame to be available: \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)frameLocator));
            }
        };
    }

    public static ExpectedCondition<Boolean> invisibilityOfElementLocated(final By locator) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                try {
                    return Boolean.valueOf((!driver.findElement(locator).isDisplayed() ? 1 : 0) != 0);
                }
                catch (NoSuchElementException | StaleElementReferenceException e) {
                    return Boolean.valueOf((boolean)true);
                }
            }

            public String toString() {
                return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.element to no longer be visible: \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)locator));
            }
        };
    }

    public static ExpectedCondition<Boolean> invisibilityOfElementWithText(final By locator, final String text) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                try {
                    return Boolean.valueOf((!driver.findElement(locator).getText().equals((org.rascalmpl.java.lang.Object)text) ? 1 : 0) != 0);
                }
                catch (NoSuchElementException e) {
                    return Boolean.valueOf((boolean)true);
                }
                catch (StaleElementReferenceException e) {
                    return Boolean.valueOf((boolean)true);
                }
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.element containing '%s' to no longer be visible: %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{text, locator});
            }
        };
    }

    public static ExpectedCondition<WebElement> elementToBeClickable(final By locator) {
        return new ExpectedCondition<WebElement>(){

            @Override
            public WebElement apply(WebDriver driver) {
                WebElement element = (WebElement)ExpectedConditions.visibilityOfElementLocated(locator).apply(driver);
                try {
                    if (element != null && element.isEnabled()) {
                        return element;
                    }
                    return null;
                }
                catch (StaleElementReferenceException e) {
                    return null;
                }
            }

            public String toString() {
                return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.element to be clickable: \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)locator));
            }
        };
    }

    public static ExpectedCondition<WebElement> elementToBeClickable(final WebElement element) {
        return new ExpectedCondition<WebElement>(){

            @Override
            public WebElement apply(WebDriver driver) {
                WebElement visibleElement = (WebElement)ExpectedConditions.visibilityOf(element).apply(driver);
                try {
                    if (visibleElement != null && visibleElement.isEnabled()) {
                        return visibleElement;
                    }
                    return null;
                }
                catch (StaleElementReferenceException e) {
                    return null;
                }
            }

            public String toString() {
                return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.element to be clickable: \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)element));
            }
        };
    }

    public static ExpectedCondition<Boolean> stalenessOf(final WebElement element) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver ignored) {
                try {
                    element.isEnabled();
                    return Boolean.valueOf((boolean)false);
                }
                catch (StaleElementReferenceException expected) {
                    return Boolean.valueOf((boolean)true);
                }
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.element (%s) to become stale", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{element});
            }
        };
    }

    public static <T extends org.rascalmpl.java.lang.Object> ExpectedCondition<T> refreshed(final ExpectedCondition<T> condition) {
        return new ExpectedCondition<T>(){

            @Override
            public T apply(WebDriver driver) {
                try {
                    return condition.apply(driver);
                }
                catch (StaleElementReferenceException e) {
                    return null;
                }
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.condition (%s) to be refreshed", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{condition});
            }
        };
    }

    public static ExpectedCondition<Boolean> elementToBeSelected(WebElement element) {
        return ExpectedConditions.elementSelectionStateToBe(element, true);
    }

    public static ExpectedCondition<Boolean> elementSelectionStateToBe(final WebElement element, final boolean selected) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                return Boolean.valueOf((element.isSelected() == selected ? 1 : 0) != 0);
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.element (%s) to %sbe selected", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{element, selected ? "org.rascalmpl." : "org.rascalmpl.not "});
            }
        };
    }

    public static ExpectedCondition<Boolean> elementToBeSelected(By locator) {
        return ExpectedConditions.elementSelectionStateToBe(locator, true);
    }

    public static ExpectedCondition<Boolean> elementSelectionStateToBe(final By locator, final boolean selected) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                try {
                    WebElement element = driver.findElement(locator);
                    return Boolean.valueOf((element.isSelected() == selected ? 1 : 0) != 0);
                }
                catch (StaleElementReferenceException e) {
                    return Boolean.valueOf((boolean)false);
                }
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.element found by %s to %sbe selected", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{locator, selected ? "org.rascalmpl." : "org.rascalmpl.not "});
            }
        };
    }

    public static ExpectedCondition<Alert> alertIsPresent() {
        return new ExpectedCondition<Alert>(){

            @Override
            public Alert apply(WebDriver driver) {
                try {
                    return driver.switchTo().alert();
                }
                catch (NoAlertPresentException e) {
                    return null;
                }
            }

            public String toString() {
                return "org.rascalmpl.alert to be present";
            }
        };
    }

    public static ExpectedCondition<Boolean> numberOfWindowsToBe(final int expectedNumberOfWindows) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                try {
                    return Boolean.valueOf((driver.getWindowHandles().size() == expectedNumberOfWindows ? 1 : 0) != 0);
                }
                catch (WebDriverException e) {
                    return Boolean.valueOf((boolean)false);
                }
            }

            public String toString() {
                return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.number of open windows to be \u0001"}, (int)expectedNumberOfWindows);
            }
        };
    }

    public static ExpectedCondition<Boolean> not(final ExpectedCondition<?> condition) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                org.rascalmpl.java.lang.Object result = condition.apply(driver);
                return Boolean.valueOf((result == null || result.equals((org.rascalmpl.java.lang.Object)Boolean.FALSE) ? 1 : 0) != 0);
            }

            public String toString() {
                return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.condition to not be valid: \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)condition));
            }
        };
    }

    public static ExpectedCondition<Boolean> attributeToBe(final By locator, final String attribute, final String value) {
        return new ExpectedCondition<Boolean>(){
            private String currentValue = null;

            @Override
            public Boolean apply(WebDriver driver) {
                WebElement element = driver.findElement(locator);
                this.currentValue = element.getAttribute(attribute);
                if (this.currentValue == null || this.currentValue.isEmpty()) {
                    this.currentValue = element.getCssValue(attribute);
                }
                return Boolean.valueOf((boolean)value.equals((org.rascalmpl.java.lang.Object)this.currentValue));
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.element found by %s to have value \"%s\". Current value: \"%s\"", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{locator, value, this.currentValue});
            }
        };
    }

    public static ExpectedCondition<Boolean> textToBe(final By locator, final String value) {
        return new ExpectedCondition<Boolean>(){
            private String currentValue = null;

            @Override
            public Boolean apply(WebDriver driver) {
                try {
                    this.currentValue = driver.findElement(locator).getText();
                    return Boolean.valueOf((boolean)this.currentValue.equals((org.rascalmpl.java.lang.Object)value));
                }
                catch (Exception e) {
                    return Boolean.valueOf((boolean)false);
                }
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.element found by %s to have text \"%s\". Current text: \"%s\"", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{locator, value, this.currentValue});
            }
        };
    }

    public static ExpectedCondition<Boolean> textMatches(final By locator, final Pattern pattern) {
        return new ExpectedCondition<Boolean>(){
            private String currentValue = null;

            @Override
            public Boolean apply(WebDriver driver) {
                try {
                    this.currentValue = driver.findElement(locator).getText();
                    return Boolean.valueOf((boolean)pattern.matcher((CharSequence)this.currentValue).find());
                }
                catch (Exception e) {
                    return Boolean.valueOf((boolean)false);
                }
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.text found by %s to match pattern \"%s\". Current text: \"%s\"", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{locator, pattern.pattern(), this.currentValue});
            }
        };
    }

    public static ExpectedCondition<List<WebElement>> numberOfElementsToBeMoreThan(final By locator, final Integer number) {
        return new ExpectedCondition<List<WebElement>>(){
            private Integer currentNumber = Integer.valueOf((int)0);

            @Override
            public List<WebElement> apply(WebDriver webDriver) {
                List<WebElement> elements = webDriver.findElements(locator);
                this.currentNumber = Integer.valueOf((int)elements.size());
                return this.currentNumber.intValue() > number.intValue() ? elements : null;
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.number of elements found by %s to be more than \"%s\". Current number: \"%s\"", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{locator, number, this.currentNumber});
            }
        };
    }

    public static ExpectedCondition<List<WebElement>> numberOfElementsToBeLessThan(final By locator, final Integer number) {
        return new ExpectedCondition<List<WebElement>>(){
            private Integer currentNumber = Integer.valueOf((int)0);

            @Override
            public List<WebElement> apply(WebDriver webDriver) {
                List<WebElement> elements = webDriver.findElements(locator);
                this.currentNumber = Integer.valueOf((int)elements.size());
                return this.currentNumber.intValue() < number.intValue() ? elements : null;
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.number of elements found by %s to be less than \"%s\". Current number: \"%s\"", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{locator, number, this.currentNumber});
            }
        };
    }

    public static ExpectedCondition<List<WebElement>> numberOfElementsToBe(final By locator, final Integer number) {
        return new ExpectedCondition<List<WebElement>>(){
            private Integer currentNumber = Integer.valueOf((int)0);

            @Override
            public List<WebElement> apply(WebDriver webDriver) {
                List<WebElement> elements = webDriver.findElements(locator);
                this.currentNumber = Integer.valueOf((int)elements.size());
                return this.currentNumber.equals((org.rascalmpl.java.lang.Object)number) ? elements : null;
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.number of elements found by %s to be \"%s\". Current number: \"%s\"", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{locator, number, this.currentNumber});
            }
        };
    }

    public static ExpectedCondition<Boolean> domPropertyToBe(final WebElement element, final String property, final String value) {
        return new ExpectedCondition<Boolean>(){
            private String currentValue = null;

            @Override
            public Boolean apply(WebDriver driver) {
                this.currentValue = element.getDomProperty(property);
                return Boolean.valueOf((boolean)value.equals((org.rascalmpl.java.lang.Object)this.currentValue));
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.DOM property '%s' to be '%s'. Current value: '%s'", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{property, value, this.currentValue});
            }
        };
    }

    public static ExpectedCondition<Boolean> domAttributeToBe(final WebElement element, final String attribute, final String value) {
        return new ExpectedCondition<Boolean>(){
            private String currentValue = null;

            @Override
            public Boolean apply(WebDriver driver) {
                this.currentValue = element.getDomAttribute(attribute);
                return Boolean.valueOf((boolean)value.equals((org.rascalmpl.java.lang.Object)this.currentValue));
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.DOM attribute '%s' to be '%s'. Current value: '%s'", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{attribute, value, this.currentValue});
            }
        };
    }

    public static ExpectedCondition<Boolean> attributeToBe(final WebElement element, final String attribute, final String value) {
        return new ExpectedCondition<Boolean>(){
            private String currentValue = null;

            @Override
            public Boolean apply(WebDriver driver) {
                this.currentValue = element.getAttribute(attribute);
                if (this.currentValue == null || this.currentValue.isEmpty()) {
                    this.currentValue = element.getCssValue(attribute);
                }
                return Boolean.valueOf((boolean)value.equals((org.rascalmpl.java.lang.Object)this.currentValue));
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.Attribute or property '%s' to be '%s'. Current value: '%s'", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{attribute, value, this.currentValue});
            }
        };
    }

    public static ExpectedCondition<Boolean> attributeContains(final WebElement element, final String attribute, final String value) {
        return new ExpectedCondition<Boolean>(){

            /*
             * Exception decompiling
             */
            @Override
            public Boolean apply(WebDriver driver) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Lorg/rascalmpl/java/lang/Object;
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
                 *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.value to contain \"%s\".", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{value});
            }

            private static /* synthetic */ Boolean lambda$apply$0(String value2, String seen) {
                return Boolean.valueOf((boolean)seen.contains((CharSequence)value2));
            }
        };
    }

    public static ExpectedCondition<Boolean> attributeContains(final By locator, final String attribute, final String value) {
        return new ExpectedCondition<Boolean>(){

            /*
             * Exception decompiling
             */
            @Override
            public Boolean apply(WebDriver driver) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Lorg/rascalmpl/java/lang/Object;
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
                 *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.value found by %s to contain \"%s\".", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{locator, value});
            }

            private static /* synthetic */ Boolean lambda$apply$0(String value2, String seen) {
                return Boolean.valueOf((boolean)seen.contains((CharSequence)value2));
            }
        };
    }

    /*
     * Exception decompiling
     */
    public static ExpectedCondition<Boolean> attributeToBeNotEmpty(WebElement element, String attribute) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Lorg/rascalmpl/java/lang/Object;
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Optional<String> getAttributeOrCssValue(WebElement element, String name) {
        String value = element.getAttribute(name);
        if (value == null || value.isEmpty()) {
            value = element.getCssValue(name);
        }
        if (value == null || value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((org.rascalmpl.java.lang.Object)value);
    }

    public static ExpectedCondition<List<WebElement>> visibilityOfNestedElementsLocatedBy(final By parent, final By childLocator) {
        return new ExpectedCondition<List<WebElement>>(){

            @Override
            public List<WebElement> apply(WebDriver driver) {
                WebElement current = driver.findElement(parent);
                List<WebElement> allChildren = current.findElements(childLocator);
                if (!allChildren.isEmpty() && ((WebElement)allChildren.get(0)).isDisplayed()) {
                    return allChildren;
                }
                return null;
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.visibility of elements located by %s -> %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{parent, childLocator});
            }
        };
    }

    public static ExpectedCondition<List<WebElement>> visibilityOfNestedElementsLocatedBy(final WebElement element, final By childLocator) {
        return new ExpectedCondition<List<WebElement>>(){

            @Override
            public List<WebElement> apply(WebDriver webDriver) {
                List<WebElement> allChildren = element.findElements(childLocator);
                if (!allChildren.isEmpty() && ((WebElement)allChildren.get(0)).isDisplayed()) {
                    return allChildren;
                }
                return null;
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.visibility of element located by %s -> %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{element, childLocator});
            }
        };
    }

    public static ExpectedCondition<WebElement> presenceOfNestedElementLocatedBy(final By locator, final By childLocator) {
        return new ExpectedCondition<WebElement>(){

            @Override
            public WebElement apply(WebDriver webDriver) {
                return webDriver.findElement(locator).findElement(childLocator);
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.visibility of element located by %s -> %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{locator, childLocator});
            }
        };
    }

    public static ExpectedCondition<WebElement> presenceOfNestedElementLocatedBy(final WebElement element, final By childLocator) {
        return new ExpectedCondition<WebElement>(){

            @Override
            public WebElement apply(WebDriver webDriver) {
                return element.findElement(childLocator);
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.visibility of element located by %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{childLocator});
            }
        };
    }

    public static ExpectedCondition<List<WebElement>> presenceOfNestedElementsLocatedBy(final By parent, final By childLocator) {
        return new ExpectedCondition<List<WebElement>>(){

            @Override
            public List<WebElement> apply(WebDriver driver) {
                List<WebElement> allChildren = driver.findElement(parent).findElements(childLocator);
                return allChildren.isEmpty() ? null : allChildren;
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.visibility of element located by %s -> %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{parent, childLocator});
            }
        };
    }

    public static ExpectedCondition<Boolean> invisibilityOfAllElements(WebElement ... elements) {
        return ExpectedConditions.invisibilityOfAllElements((List<WebElement>)Arrays.asList((org.rascalmpl.java.lang.Object[])elements));
    }

    public static ExpectedCondition<Boolean> invisibilityOfAllElements(final List<WebElement> elements) {
        return new ExpectedCondition<Boolean>(){

            /*
             * Exception decompiling
             */
            @Override
            public Boolean apply(WebDriver webDriver) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Z
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
                 *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public String toString() {
                return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.invisibility of all elements \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)elements));
            }

            private static /* synthetic */ boolean lambda$apply$0(WebElement x$0) {
                return ExpectedConditions.isInvisible(x$0);
            }
        };
    }

    public static ExpectedCondition<Boolean> invisibilityOf(final WebElement element) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver webDriver) {
                return Boolean.valueOf((boolean)ExpectedConditions.isInvisible(element));
            }

            public String toString() {
                return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.java.lang.Object[]{"org.rascalmpl.invisibility of \u0001"}, (String)String.valueOf((org.rascalmpl.java.lang.Object)element));
            }
        };
    }

    private static boolean isInvisible(WebElement element) {
        try {
            return !element.isDisplayed();
        }
        catch (NoSuchElementException | StaleElementReferenceException ignored) {
            return true;
        }
    }

    public static ExpectedCondition<Boolean> or(final ExpectedCondition<?> ... conditions) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                RuntimeException lastException = null;
                for (ExpectedCondition condition : conditions) {
                    try {
                        org.rascalmpl.java.lang.Object result = condition.apply(driver);
                        if (result == null) continue;
                        if (result instanceof Boolean) {
                            if (!Boolean.TRUE.equals(result)) continue;
                            return Boolean.valueOf((boolean)true);
                        }
                        return Boolean.valueOf((boolean)true);
                    }
                    catch (RuntimeException e) {
                        lastException = e;
                    }
                }
                if (lastException != null) {
                    throw lastException;
                }
                return Boolean.valueOf((boolean)false);
            }

            public String toString() {
                StringBuilder message = new StringBuilder((String)"org.rascalmpl.at least one condition to be valid: ");
                Joiner.on((String)"org.rascalmpl. || ").appendTo(message, (org.rascalmpl.java.lang.Object[])conditions);
                return message.toString();
            }
        };
    }

    public static ExpectedCondition<Boolean> and(final ExpectedCondition<?> ... conditions) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                for (ExpectedCondition condition : conditions) {
                    org.rascalmpl.java.lang.Object result = condition.apply(driver);
                    if (result instanceof Boolean && Boolean.FALSE.equals(result)) {
                        return Boolean.valueOf((boolean)false);
                    }
                    if (result != null) continue;
                    return Boolean.valueOf((boolean)false);
                }
                return Boolean.valueOf((boolean)true);
            }

            public String toString() {
                StringBuilder message = new StringBuilder((String)"org.rascalmpl.all conditions to be valid: ");
                Joiner.on((String)"org.rascalmpl. && ").appendTo(message, (org.rascalmpl.java.lang.Object[])conditions);
                return message.toString();
            }
        };
    }

    public static ExpectedCondition<Boolean> javaScriptThrowsNoExceptions(final String javaScript) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                try {
                    ((JavascriptExecutor)((Object)driver)).executeScript(javaScript, new org.rascalmpl.java.lang.Object[0]);
                    return Boolean.valueOf((boolean)true);
                }
                catch (WebDriverException e) {
                    return Boolean.valueOf((boolean)false);
                }
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.js %s to be executable", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{javaScript});
            }
        };
    }

    public static ExpectedCondition<org.rascalmpl.java.lang.Object> jsReturnsValue(final String javaScript) {
        return new ExpectedCondition<org.rascalmpl.java.lang.Object>(){

            @Override
            public org.rascalmpl.java.lang.Object apply(WebDriver driver) {
                try {
                    org.rascalmpl.java.lang.Object value = ((JavascriptExecutor)((Object)driver)).executeScript(javaScript, new org.rascalmpl.java.lang.Object[0]);
                    if (value instanceof List) {
                        return ((List)value).isEmpty() ? null : value;
                    }
                    if (value instanceof String) {
                        return ((String)value).isEmpty() ? null : value;
                    }
                    return value;
                }
                catch (WebDriverException e) {
                    return null;
                }
            }

            public String toString() {
                return String.format((String)"org.rascalmpl.js %s to be executable", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{javaScript});
            }
        };
    }

    private static /* synthetic */ Boolean lambda$attributeToBeNotEmpty$0(WebElement element, String attribute, WebDriver driver) {
        return Boolean.valueOf((boolean)ExpectedConditions.getAttributeOrCssValue(element, attribute).isPresent());
    }
}

