/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.support.ui;

import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.time.Clock;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.org.openqa.selenium.NotFoundException;
import org.rascalmpl.org.openqa.selenium.TimeoutException;
import org.rascalmpl.org.openqa.selenium.WebDriver;
import org.rascalmpl.org.openqa.selenium.WrapsDriver;
import org.rascalmpl.org.openqa.selenium.remote.RemoteWebDriver;
import org.rascalmpl.org.openqa.selenium.support.ui.FluentWait;
import org.rascalmpl.org.openqa.selenium.support.ui.Sleeper;

public class WebDriverWait
extends FluentWait<WebDriver> {
    private final WebDriver driver;

    public WebDriverWait(WebDriver driver, Duration timeout) {
        this(driver, timeout, Duration.ofMillis((long)500L), Clock.systemDefaultZone(), Sleeper.SYSTEM_SLEEPER);
    }

    public WebDriverWait(WebDriver driver, Duration timeout, Duration sleep) {
        this(driver, timeout, sleep, Clock.systemDefaultZone(), Sleeper.SYSTEM_SLEEPER);
    }

    public WebDriverWait(WebDriver driver, Duration timeout, Duration sleep, Clock clock, Sleeper sleeper) {
        super(driver, clock, sleeper);
        this.withTimeout(timeout);
        this.pollingEvery(sleep);
        this.ignoring((Class<? extends Throwable>)NotFoundException.class);
        this.driver = driver;
    }

    @Override
    protected RuntimeException timeoutException(String message, Throwable lastException) {
        WebDriver exceptionDriver = this.driver;
        TimeoutException ex = new TimeoutException(message, lastException);
        ex.addInfo((String)"org.rascalmpl.Driver info", exceptionDriver.getClass().getName());
        while (exceptionDriver instanceof WrapsDriver) {
            exceptionDriver = ((WrapsDriver)((Object)exceptionDriver)).getWrappedDriver();
        }
        if (exceptionDriver instanceof RemoteWebDriver) {
            RemoteWebDriver remote = (RemoteWebDriver)exceptionDriver;
            if (remote.getSessionId() != null) {
                ex.addInfo((String)"org.rascalmpl.Session ID", remote.getSessionId().toString());
            }
            if (remote.getCapabilities() != null) {
                ex.addInfo((String)"org.rascalmpl.Capabilities", remote.getCapabilities().toString());
            }
        }
        throw ex;
    }
}

