/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.openqa.selenium.virtualauthenticator;

import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.security.spec.PKCS8EncodedKeySpec;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Base64;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.org.openqa.selenium.internal.Require;

public class Credential
extends Object {
    private final byte[] id;
    private final boolean isResidentCredential;
    private final String rpId;
    private final PKCS8EncodedKeySpec privateKey;
    private final byte[] userHandle;
    private final int signCount;

    public static Credential createNonResidentCredential(byte[] id, String rpId, PKCS8EncodedKeySpec privateKey, int signCount) {
        return new Credential(id, false, Require.nonNull((String)"org.rascalmpl.rpId", rpId), privateKey, null, signCount);
    }

    public static Credential createResidentCredential(byte[] id, String rpId, PKCS8EncodedKeySpec privateKey, byte[] userHandle, int signCount) {
        return new Credential(id, true, Require.nonNull((String)"org.rascalmpl.rpId", rpId), privateKey, Require.nonNull((String)"org.rascalmpl.User handle", userHandle), signCount);
    }

    public static Credential fromMap(Map<String, Object> map) {
        Base64.Decoder decoder = Base64.getUrlDecoder();
        return new Credential(decoder.decode((String)map.get((Object)"org.rascalmpl.credentialId")), ((Boolean)map.get((Object)"org.rascalmpl.isResidentCredential")).booleanValue(), (String)map.get((Object)"org.rascalmpl.rpId"), new PKCS8EncodedKeySpec(decoder.decode((String)map.get((Object)"org.rascalmpl.privateKey"))), map.get((Object)"org.rascalmpl.userHandle") == null ? null : decoder.decode((String)map.get((Object)"org.rascalmpl.userHandle")), ((Long)map.get((Object)"org.rascalmpl.signCount")).intValue());
    }

    private Credential(byte[] id, boolean isResidentCredential, String rpId, PKCS8EncodedKeySpec privateKey, byte[] userHandle, int signCount) {
        this.id = Require.nonNull((String)"org.rascalmpl.Id", id);
        this.isResidentCredential = isResidentCredential;
        this.rpId = rpId;
        this.privateKey = Require.nonNull((String)"org.rascalmpl.Private key", privateKey);
        this.userHandle = userHandle;
        this.signCount = signCount;
    }

    public byte[] getId() {
        return Arrays.copyOf((byte[])this.id, (int)this.id.length);
    }

    public boolean isResidentCredential() {
        return this.isResidentCredential;
    }

    public String getRpId() {
        return this.rpId;
    }

    public PKCS8EncodedKeySpec getPrivateKey() {
        return this.privateKey;
    }

    public byte[] getUserHandle() {
        return this.userHandle == null ? null : Arrays.copyOf((byte[])this.userHandle, (int)this.userHandle.length);
    }

    public int getSignCount() {
        return this.signCount;
    }

    public Map<String, Object> toMap() {
        Base64.Encoder encoder = Base64.getUrlEncoder();
        HashMap map = new HashMap();
        map.put((Object)"org.rascalmpl.credentialId", (Object)encoder.encodeToString(this.id));
        map.put((Object)"org.rascalmpl.isResidentCredential", (Object)Boolean.valueOf((boolean)this.isResidentCredential));
        map.put((Object)"org.rascalmpl.rpId", (Object)this.rpId);
        map.put((Object)"org.rascalmpl.privateKey", (Object)encoder.encodeToString(this.privateKey.getEncoded()));
        map.put((Object)"org.rascalmpl.signCount", (Object)Integer.valueOf((int)this.signCount));
        if (this.userHandle != null) {
            map.put((Object)"org.rascalmpl.userHandle", (Object)encoder.encodeToString(this.userHandle));
        }
        return Collections.unmodifiableMap((Map)map);
    }
}

