/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.base;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Function;
import org.rascalmpl.org.rascalmpl.com.google.common.base.FunctionalEquivalence;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Objects;
import org.rascalmpl.org.rascalmpl.com.google.common.base.PairwiseEquivalence;
import org.rascalmpl.org.rascalmpl.com.google.common.base.ParametricNullness;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Predicate;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.ForOverride;
import org.rascalmpl.org.rascalmpl.java.io.Serializable;
import org.rascalmpl.org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.java.util.function.BiPredicate;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.NonNull;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class Equivalence<T extends org.rascalmpl.org.rascalmpl.java.lang.Object>
extends org.rascalmpl.org.rascalmpl.java.lang.Object
implements BiPredicate<T, T> {
    protected Equivalence() {
    }

    public final boolean equivalent(@CheckForNull T a, @CheckForNull T b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return this.doEquivalent(a, b);
    }

    @Deprecated
    public final boolean test(@CheckForNull T t2, @CheckForNull T u) {
        return this.equivalent(t2, u);
    }

    @ForOverride
    protected abstract boolean doEquivalent(T var1, T var2);

    public final int hash(@CheckForNull T t2) {
        if (t2 == null) {
            return 0;
        }
        return this.doHash(t2);
    }

    @ForOverride
    protected abstract int doHash(T var1);

    public final <F extends org.rascalmpl.org.rascalmpl.java.lang.Object> Equivalence<F> onResultOf(Function<? super F, ? extends @Nullable T> function) {
        return new FunctionalEquivalence<F, T>(function, this);
    }

    public final <S extends T> Wrapper<S> wrap(@ParametricNullness S reference) {
        return new Wrapper(this, (org.rascalmpl.org.rascalmpl.java.lang.Object)reference, null);
    }

    @GwtCompatible(serializable=true)
    public final <S extends T> Equivalence<Iterable<S>> pairwise() {
        return new PairwiseEquivalence(this);
    }

    public final Predicate<@Nullable T> equivalentTo(@CheckForNull T target) {
        return new EquivalentToPredicate<T>(this, target);
    }

    public static Equivalence<org.rascalmpl.org.rascalmpl.java.lang.Object> equals() {
        return Equals.INSTANCE;
    }

    public static Equivalence<org.rascalmpl.org.rascalmpl.java.lang.Object> identity() {
        return Identity.INSTANCE;
    }

    static final class Identity
    extends Equivalence<org.rascalmpl.org.rascalmpl.java.lang.Object>
    implements Serializable {
        static final Identity INSTANCE = new Identity();
        private static final long serialVersionUID = 1L;

        Identity() {
        }

        @Override
        protected boolean doEquivalent(org.rascalmpl.org.rascalmpl.java.lang.Object a, org.rascalmpl.org.rascalmpl.java.lang.Object b) {
            return false;
        }

        @Override
        protected int doHash(org.rascalmpl.org.rascalmpl.java.lang.Object o) {
            return System.identityHashCode((org.rascalmpl.org.rascalmpl.java.lang.Object)o);
        }

        private org.rascalmpl.org.rascalmpl.java.lang.Object readResolve() {
            return INSTANCE;
        }
    }

    static final class Equals
    extends Equivalence<org.rascalmpl.org.rascalmpl.java.lang.Object>
    implements Serializable {
        static final Equals INSTANCE = new Equals();
        private static final long serialVersionUID = 1L;

        Equals() {
        }

        @Override
        protected boolean doEquivalent(org.rascalmpl.org.rascalmpl.java.lang.Object a, org.rascalmpl.org.rascalmpl.java.lang.Object b) {
            return a.equals(b);
        }

        @Override
        protected int doHash(org.rascalmpl.org.rascalmpl.java.lang.Object o) {
            return o.hashCode();
        }

        private org.rascalmpl.org.rascalmpl.java.lang.Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class EquivalentToPredicate<T extends org.rascalmpl.org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.org.rascalmpl.java.lang.Object
    implements Predicate<T>,
    Serializable {
        private final Equivalence<T> equivalence;
        @CheckForNull
        private final T target;
        private static final long serialVersionUID = 0L;

        EquivalentToPredicate(Equivalence<T> equivalence, @CheckForNull T target) {
            this.equivalence = Preconditions.checkNotNull(equivalence);
            this.target = target;
        }

        @Override
        public boolean apply(@CheckForNull T input) {
            return this.equivalence.equivalent(input, this.target);
        }

        @Override
        public boolean equals(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof EquivalentToPredicate) {
                EquivalentToPredicate that = (EquivalentToPredicate)obj;
                return this.equivalence.equals(that.equivalence) && Objects.equal(this.target, that.target);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(new org.rascalmpl.org.rascalmpl.java.lang.Object[]{this.equivalence, this.target});
        }

        public String toString() {
            return new StringBuilder().append(this.equivalence).append((String)"org.rascalmpl.org.rascalmpl..equivalentTo(").append(this.target).append((String)"org.rascalmpl.org.rascalmpl.)").toString();
        }
    }

    public static final class Wrapper<T extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.org.rascalmpl.java.lang.Object
    implements Serializable {
        private final Equivalence<? super @NonNull T> equivalence;
        @ParametricNullness
        private final T reference;
        private static final long serialVersionUID = 0L;

        private Wrapper(Equivalence<? super @NonNull T> equivalence, @ParametricNullness T reference) {
            this.equivalence = Preconditions.checkNotNull(equivalence);
            this.reference = reference;
        }

        @ParametricNullness
        public T get() {
            return this.reference;
        }

        public boolean equals(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Wrapper) {
                Wrapper that = (Wrapper)obj;
                if (this.equivalence.equals(that.equivalence)) {
                    Equivalence<T> equivalence = this.equivalence;
                    return equivalence.equivalent(this.reference, that.reference);
                }
            }
            return false;
        }

        public int hashCode() {
            return this.equivalence.hash(this.reference);
        }

        public String toString() {
            return new StringBuilder().append(this.equivalence).append((String)"org.rascalmpl.org.rascalmpl..wrap(").append(this.reference).append((String)"org.rascalmpl.org.rascalmpl.)").toString();
        }

        /* synthetic */ Wrapper(Equivalence x0, org.rascalmpl.org.rascalmpl.java.lang.Object x1, 1 x2) {
            this(x0, x1);
        }
    }
}

