/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.base;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.org.rascalmpl.com.google.common.base.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.base.FinalizableReference;
import org.rascalmpl.org.rascalmpl.java.io.Closeable;
import org.rascalmpl.org.rascalmpl.java.io.FileNotFoundException;
import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.ClassLoader;
import org.rascalmpl.org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.org.rascalmpl.java.lang.Exception;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalAccessException;
import org.rascalmpl.org.rascalmpl.java.lang.NoSuchMethodException;
import org.rascalmpl.org.rascalmpl.java.lang.SecurityException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.lang.ref.PhantomReference;
import org.rascalmpl.org.rascalmpl.java.lang.ref.Reference;
import org.rascalmpl.org.rascalmpl.java.lang.ref.ReferenceQueue;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.Method;
import org.rascalmpl.org.rascalmpl.java.net.URL;
import org.rascalmpl.org.rascalmpl.java.net.URLClassLoader;
import org.rascalmpl.org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public class FinalizableReferenceQueue
extends org.rascalmpl.org.rascalmpl.java.lang.Object
implements Closeable {
    private static final Logger logger = Logger.getLogger((String)FinalizableReferenceQueue.class.getName());
    private static final String FINALIZER_CLASS_NAME = "org.rascalmpl.org.rascalmpl.com.google.common.base.internal.Finalizer";
    private static final Method startFinalizer;
    final ReferenceQueue<org.rascalmpl.org.rascalmpl.java.lang.Object> queue = new ReferenceQueue();
    final PhantomReference<org.rascalmpl.org.rascalmpl.java.lang.Object> frqRef = new PhantomReference((org.rascalmpl.org.rascalmpl.java.lang.Object)this, this.queue);
    final boolean threadStarted;

    public FinalizableReferenceQueue() {
        boolean threadStarted = false;
        try {
            startFinalizer.invoke(null, new org.rascalmpl.org.rascalmpl.java.lang.Object[]{FinalizableReference.class, this.queue, this.frqRef});
            threadStarted = true;
        }
        catch (IllegalAccessException impossible) {
            throw new AssertionError((org.rascalmpl.org.rascalmpl.java.lang.Object)impossible);
        }
        catch (Throwable t2) {
            logger.log(Level.INFO, (String)"org.rascalmpl.org.rascalmpl.Failed to start reference finalizer thread. Reference cleanup will only occur when new references are created.", t2);
        }
        this.threadStarted = threadStarted;
    }

    public void close() {
        this.frqRef.enqueue();
        this.cleanUp();
    }

    void cleanUp() {
        Reference reference;
        if (this.threadStarted) {
            return;
        }
        while ((reference = this.queue.poll()) != null) {
            reference.clear();
            try {
                ((FinalizableReference)reference).finalizeReferent();
            }
            catch (Throwable t2) {
                logger.log(Level.SEVERE, (String)"org.rascalmpl.org.rascalmpl.Error cleaning up after reference.", t2);
            }
        }
    }

    private static Class<?> loadFinalizer(FinalizerLoader ... loaders) {
        for (FinalizerLoader loader : loaders) {
            Class<?> finalizer = loader.loadFinalizer();
            if (finalizer == null) continue;
            return finalizer;
        }
        throw new AssertionError();
    }

    static Method getStartFinalizer(Class<?> finalizer) {
        try {
            return finalizer.getMethod((String)"org.rascalmpl.org.rascalmpl.startFinalizer", new Class[]{Class.class, ReferenceQueue.class, PhantomReference.class});
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((org.rascalmpl.org.rascalmpl.java.lang.Object)e);
        }
    }

    static {
        Class<?> finalizer = FinalizableReferenceQueue.loadFinalizer(new SystemLoader(), new DecoupledLoader(), new DirectLoader());
        startFinalizer = FinalizableReferenceQueue.getStartFinalizer(finalizer);
    }

    static class DirectLoader
    extends org.rascalmpl.org.rascalmpl.java.lang.Object
    implements FinalizerLoader {
        DirectLoader() {
        }

        @Override
        public Class<?> loadFinalizer() {
            try {
                return Class.forName((String)"org.rascalmpl.org.rascalmpl.com.google.common.base.internal.Finalizer");
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((org.rascalmpl.org.rascalmpl.java.lang.Object)e);
            }
        }
    }

    static class DecoupledLoader
    extends org.rascalmpl.org.rascalmpl.java.lang.Object
    implements FinalizerLoader {
        private static final String LOADING_ERROR = "org.rascalmpl.org.rascalmpl.Could not load Finalizer in its own class loader. Loading Finalizer in the current class loader instead. As a result, you will not be able to garbage collect this class loader. To support reclaiming this class loader, either resolve the underlying issue, or move Guava to your system class path.";

        DecoupledLoader() {
        }

        @Override
        @CheckForNull
        public Class<?> loadFinalizer() {
            try {
                URLClassLoader finalizerLoader = this.newLoader(this.getBaseUrl());
                return finalizerLoader.loadClass((String)"org.rascalmpl.org.rascalmpl.com.google.common.base.internal.Finalizer");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.Could not load Finalizer in its own class loader. Loading Finalizer in the current class loader instead. As a result, you will not be able to garbage collect this class loader. To support reclaiming this class loader, either resolve the underlying issue, or move Guava to your system class path.", (Throwable)((Object)e));
                return null;
            }
        }

        URL getBaseUrl() throws IOException {
            String finalizerPath = new StringBuilder().append("org.rascalmpl.org.rascalmpl.com.google.common.base.internal.Finalizer".replace('.', '/')).append((String)"org.rascalmpl.org.rascalmpl..class").toString();
            URL finalizerUrl = this.getClass().getClassLoader().getResource(finalizerPath);
            if (finalizerUrl == null) {
                throw new FileNotFoundException(finalizerPath);
            }
            String urlString = finalizerUrl.toString();
            if (!urlString.endsWith(finalizerPath)) {
                throw new IOException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Unsupported path style: ").append(urlString).toString());
            }
            urlString = urlString.substring(0, urlString.length() - finalizerPath.length());
            return new URL(finalizerUrl, urlString);
        }

        URLClassLoader newLoader(URL base) {
            return new URLClassLoader(new URL[]{base}, null);
        }
    }

    static class SystemLoader
    extends org.rascalmpl.org.rascalmpl.java.lang.Object
    implements FinalizerLoader {
        @VisibleForTesting
        static boolean disabled;

        SystemLoader() {
        }

        @Override
        @CheckForNull
        public Class<?> loadFinalizer() {
            ClassLoader systemLoader;
            if (disabled) {
                return null;
            }
            try {
                systemLoader = ClassLoader.getSystemClassLoader();
            }
            catch (SecurityException e) {
                logger.info((String)"org.rascalmpl.org.rascalmpl.Not allowed to access system class loader.");
                return null;
            }
            if (systemLoader != null) {
                try {
                    return systemLoader.loadClass((String)"org.rascalmpl.org.rascalmpl.com.google.common.base.internal.Finalizer");
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            return null;
        }
    }

    static interface FinalizerLoader {
        @CheckForNull
        public Class<?> loadFinalizer();
    }
}

