/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.base;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Optional;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.NullPointerException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.Array;
import org.rascalmpl.org.rascalmpl.java.util.Arrays;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.OptionalDouble;
import org.rascalmpl.org.rascalmpl.java.util.OptionalInt;
import org.rascalmpl.org.rascalmpl.java.util.OptionalLong;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class MoreObjects
extends org.rascalmpl.org.rascalmpl.java.lang.Object {
    public static <T extends org.rascalmpl.org.rascalmpl.java.lang.Object> T firstNonNull(@CheckForNull T first, @CheckForNull T second) {
        if (first != null) {
            return first;
        }
        if (second != null) {
            return second;
        }
        throw new NullPointerException((String)"org.rascalmpl.org.rascalmpl.Both parameters are null");
    }

    public static ToStringHelper toStringHelper(org.rascalmpl.org.rascalmpl.java.lang.Object self) {
        return new ToStringHelper(self.getClass().getSimpleName());
    }

    public static ToStringHelper toStringHelper(Class<?> clazz) {
        return new ToStringHelper(clazz.getSimpleName());
    }

    public static ToStringHelper toStringHelper(String className) {
        return new ToStringHelper(className);
    }

    private MoreObjects() {
    }

    public static final class ToStringHelper
    extends org.rascalmpl.org.rascalmpl.java.lang.Object {
        private final String className;
        private final ValueHolder holderHead;
        private ValueHolder holderTail;
        private boolean omitNullValues;
        private boolean omitEmptyValues;

        private ToStringHelper(String className) {
            this.holderTail = this.holderHead = new ValueHolder();
            this.omitNullValues = false;
            this.omitEmptyValues = false;
            this.className = Preconditions.checkNotNull(className);
        }

        @CanIgnoreReturnValue
        public ToStringHelper omitNullValues() {
            this.omitNullValues = true;
            return this;
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, @CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object value) {
            return this.addHolder(name, value);
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, boolean value) {
            return this.addUnconditionalHolder(name, (org.rascalmpl.org.rascalmpl.java.lang.Object)String.valueOf((boolean)value));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, char value) {
            return this.addUnconditionalHolder(name, (org.rascalmpl.org.rascalmpl.java.lang.Object)String.valueOf((char)value));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, double value) {
            return this.addUnconditionalHolder(name, (org.rascalmpl.org.rascalmpl.java.lang.Object)String.valueOf((double)value));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, float value) {
            return this.addUnconditionalHolder(name, (org.rascalmpl.org.rascalmpl.java.lang.Object)String.valueOf((float)value));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, int value) {
            return this.addUnconditionalHolder(name, (org.rascalmpl.org.rascalmpl.java.lang.Object)String.valueOf((int)value));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, long value) {
            return this.addUnconditionalHolder(name, (org.rascalmpl.org.rascalmpl.java.lang.Object)String.valueOf((long)value));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object value) {
            return this.addHolder(value);
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(boolean value) {
            return this.addUnconditionalHolder((org.rascalmpl.org.rascalmpl.java.lang.Object)String.valueOf((boolean)value));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(char value) {
            return this.addUnconditionalHolder((org.rascalmpl.org.rascalmpl.java.lang.Object)String.valueOf((char)value));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(double value) {
            return this.addUnconditionalHolder((org.rascalmpl.org.rascalmpl.java.lang.Object)String.valueOf((double)value));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(float value) {
            return this.addUnconditionalHolder((org.rascalmpl.org.rascalmpl.java.lang.Object)String.valueOf((float)value));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(int value) {
            return this.addUnconditionalHolder((org.rascalmpl.org.rascalmpl.java.lang.Object)String.valueOf((int)value));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(long value) {
            return this.addUnconditionalHolder((org.rascalmpl.org.rascalmpl.java.lang.Object)String.valueOf((long)value));
        }

        private static boolean isEmpty(org.rascalmpl.org.rascalmpl.java.lang.Object value) {
            if (value instanceof CharSequence) {
                return ((CharSequence)value).length() == 0;
            }
            if (value instanceof Collection) {
                return ((Collection)value).isEmpty();
            }
            if (value instanceof Map) {
                return ((Map)value).isEmpty();
            }
            if (value instanceof org.rascalmpl.org.rascalmpl.java.util.Optional) {
                return !((org.rascalmpl.org.rascalmpl.java.util.Optional)value).isPresent();
            }
            if (value instanceof OptionalInt) {
                return !((OptionalInt)value).isPresent();
            }
            if (value instanceof OptionalLong) {
                return !((OptionalLong)value).isPresent();
            }
            if (value instanceof OptionalDouble) {
                return !((OptionalDouble)value).isPresent();
            }
            if (value instanceof Optional) {
                return !((Optional)value).isPresent();
            }
            if (value.getClass().isArray()) {
                return Array.getLength((org.rascalmpl.org.rascalmpl.java.lang.Object)value) == 0;
            }
            return false;
        }

        public String toString() {
            boolean omitNullValuesSnapshot = this.omitNullValues;
            boolean omitEmptyValuesSnapshot = this.omitEmptyValues;
            java.lang.String nextSeparator = "org.rascalmpl.org.rascalmpl.";
            StringBuilder builder = new StringBuilder(32).append(this.className).append('{');
            ValueHolder valueHolder = this.holderHead.next;
            while (valueHolder != null) {
                org.rascalmpl.org.rascalmpl.java.lang.Object value = valueHolder.value;
                if (valueHolder instanceof UnconditionalValueHolder || (value == null ? !omitNullValuesSnapshot : !omitEmptyValuesSnapshot || !ToStringHelper.isEmpty(value))) {
                    builder.append((String)nextSeparator);
                    nextSeparator = "org.rascalmpl.org.rascalmpl., ";
                    if (valueHolder.name != null) {
                        builder.append(valueHolder.name).append('=');
                    }
                    if (value != null && value.getClass().isArray()) {
                        org.rascalmpl.org.rascalmpl.java.lang.Object[] objectArray = new org.rascalmpl.org.rascalmpl.java.lang.Object[]{value};
                        String arrayString = Arrays.deepToString((org.rascalmpl.org.rascalmpl.java.lang.Object[])objectArray);
                        builder.append((CharSequence)arrayString, 1, arrayString.length() - 1);
                    } else {
                        builder.append(value);
                    }
                }
                valueHolder = valueHolder.next;
            }
            return builder.append('}').toString();
        }

        private ValueHolder addHolder() {
            ValueHolder valueHolder;
            this.holderTail = this.holderTail.next = (valueHolder = new ValueHolder());
            return valueHolder;
        }

        @CanIgnoreReturnValue
        private ToStringHelper addHolder(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object value) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = value;
            return this;
        }

        @CanIgnoreReturnValue
        private ToStringHelper addHolder(String name, @CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object value) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = value;
            valueHolder.name = Preconditions.checkNotNull(name);
            return this;
        }

        private UnconditionalValueHolder addUnconditionalHolder() {
            UnconditionalValueHolder valueHolder = new UnconditionalValueHolder();
            this.holderTail = this.holderTail.next = valueHolder;
            return valueHolder;
        }

        @CanIgnoreReturnValue
        private ToStringHelper addUnconditionalHolder(org.rascalmpl.org.rascalmpl.java.lang.Object value) {
            UnconditionalValueHolder valueHolder = this.addUnconditionalHolder();
            valueHolder.value = value;
            return this;
        }

        @CanIgnoreReturnValue
        private ToStringHelper addUnconditionalHolder(String name, org.rascalmpl.org.rascalmpl.java.lang.Object value) {
            UnconditionalValueHolder valueHolder = this.addUnconditionalHolder();
            valueHolder.value = value;
            valueHolder.name = Preconditions.checkNotNull(name);
            return this;
        }

        private static final class UnconditionalValueHolder
        extends ValueHolder {
            private UnconditionalValueHolder() {
            }
        }

        static class ValueHolder
        extends org.rascalmpl.org.rascalmpl.java.lang.Object {
            @CheckForNull
            String name;
            @CheckForNull
            org.rascalmpl.org.rascalmpl.java.lang.Object value;
            @CheckForNull
            ValueHolder next;

            ValueHolder() {
            }
        }
    }
}

