/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.base;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.CharMatcher;
import org.rascalmpl.org.rascalmpl.com.google.common.base.CommonPattern;
import org.rascalmpl.org.rascalmpl.com.google.common.base.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Enums;
import org.rascalmpl.org.rascalmpl.com.google.common.base.JdkPattern;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Optional;
import org.rascalmpl.org.rascalmpl.com.google.common.base.PatternCompiler;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.Double;
import org.rascalmpl.org.rascalmpl.java.lang.Enum;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.lang.ref.WeakReference;
import org.rascalmpl.org.rascalmpl.java.util.Locale;
import org.rascalmpl.org.rascalmpl.java.util.ServiceConfigurationError;
import org.rascalmpl.org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.org.rascalmpl.java.util.regex.Pattern;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class Platform
extends org.rascalmpl.org.rascalmpl.java.lang.Object {
    private static final Logger logger = Logger.getLogger((String)Platform.class.getName());
    private static final PatternCompiler patternCompiler = Platform.loadPatternCompiler();

    private Platform() {
    }

    static CharMatcher precomputeCharMatcher(CharMatcher matcher) {
        return matcher.precomputedInternal();
    }

    static <T extends Enum<T>> Optional<T> getEnumIfPresent(Class<T> enumClass, String value) {
        WeakReference ref = (WeakReference)Enums.getEnumConstants(enumClass).get((org.rascalmpl.org.rascalmpl.java.lang.Object)value);
        return ref == null ? Optional.absent() : Optional.fromNullable((Enum)enumClass.cast(ref.get()));
    }

    static String formatCompact4Digits(double value) {
        return String.format((Locale)Locale.ROOT, (String)"org.rascalmpl.org.rascalmpl.%.4g", (org.rascalmpl.org.rascalmpl.java.lang.Object[])new org.rascalmpl.org.rascalmpl.java.lang.Object[]{Double.valueOf((double)value)});
    }

    static boolean stringIsNullOrEmpty(@CheckForNull String string) {
        return string == null || string.isEmpty();
    }

    static String nullToEmpty(@CheckForNull String string) {
        return string == null ? "org.rascalmpl.org.rascalmpl." : string;
    }

    @CheckForNull
    static String emptyToNull(@CheckForNull String string) {
        return Platform.stringIsNullOrEmpty(string) ? null : string;
    }

    static CommonPattern compilePattern(String pattern) {
        Preconditions.checkNotNull(pattern);
        return patternCompiler.compile(pattern);
    }

    static boolean patternCompilerIsPcreLike() {
        return patternCompiler.isPcreLike();
    }

    private static PatternCompiler loadPatternCompiler() {
        return new JdkPatternCompiler();
    }

    private static void logPatternCompilerError(ServiceConfigurationError e) {
        logger.log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.Error loading regex compiler, falling back to next option", (Throwable)e);
    }

    private static final class JdkPatternCompiler
    extends org.rascalmpl.org.rascalmpl.java.lang.Object
    implements PatternCompiler {
        private JdkPatternCompiler() {
        }

        @Override
        public CommonPattern compile(String pattern) {
            return new JdkPattern(Pattern.compile((String)pattern));
        }

        @Override
        public boolean isPcreLike() {
            return true;
        }
    }
}

