/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.base.internal;

import org.rascalmpl.org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.InterruptedException;
import org.rascalmpl.org.rascalmpl.java.lang.Long;
import org.rascalmpl.org.rascalmpl.java.lang.NoSuchMethodException;
import org.rascalmpl.org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.Thread;
import org.rascalmpl.org.rascalmpl.java.lang.ThreadGroup;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.lang.ref.PhantomReference;
import org.rascalmpl.org.rascalmpl.java.lang.ref.Reference;
import org.rascalmpl.org.rascalmpl.java.lang.ref.ReferenceQueue;
import org.rascalmpl.org.rascalmpl.java.lang.ref.WeakReference;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.Constructor;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.Field;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.Method;
import org.rascalmpl.org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;

public class Finalizer
extends org.rascalmpl.org.rascalmpl.java.lang.Object
implements Runnable {
    private static final Logger logger = Logger.getLogger((String)Finalizer.class.getName());
    private static final String FINALIZABLE_REFERENCE = "org.rascalmpl.org.rascalmpl.com.google.common.base.FinalizableReference";
    private final WeakReference<Class<?>> finalizableReferenceClassReference;
    private final PhantomReference<org.rascalmpl.org.rascalmpl.java.lang.Object> frqReference;
    private final ReferenceQueue<org.rascalmpl.org.rascalmpl.java.lang.Object> queue;
    @CheckForNull
    private static final Constructor<Thread> bigThreadConstructor = Finalizer.getBigThreadConstructor();
    @CheckForNull
    private static final Field inheritableThreadLocals = bigThreadConstructor == null ? Finalizer.getInheritableThreadLocalsField() : null;

    public static void startFinalizer(Class<?> finalizableReferenceClass, ReferenceQueue<org.rascalmpl.org.rascalmpl.java.lang.Object> queue, PhantomReference<org.rascalmpl.org.rascalmpl.java.lang.Object> frqReference) {
        if (!finalizableReferenceClass.getName().equals((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.com.google.common.base.FinalizableReference")) {
            throw new IllegalArgumentException((String)"org.rascalmpl.org.rascalmpl.Expected com.google.common.base.FinalizableReference.");
        }
        Finalizer finalizer = new Finalizer(finalizableReferenceClass, queue, frqReference);
        String threadName = Finalizer.class.getName();
        Thread thread = null;
        if (bigThreadConstructor != null) {
            try {
                boolean inheritThreadLocals = false;
                long defaultStackSize = 0L;
                thread = (Thread)bigThreadConstructor.newInstance(new org.rascalmpl.org.rascalmpl.java.lang.Object[]{null, finalizer, threadName, Long.valueOf((long)defaultStackSize), Boolean.valueOf((boolean)inheritThreadLocals)});
            }
            catch (Throwable t2) {
                logger.log(Level.INFO, (String)"org.rascalmpl.org.rascalmpl.Failed to create a thread without inherited thread-local values", t2);
            }
        }
        if (thread == null) {
            thread = new Thread((ThreadGroup)null, (Runnable)finalizer, threadName);
        }
        thread.setDaemon(true);
        try {
            if (inheritableThreadLocals != null) {
                inheritableThreadLocals.set((org.rascalmpl.org.rascalmpl.java.lang.Object)thread, null);
            }
        }
        catch (Throwable t3) {
            logger.log(Level.INFO, (String)"org.rascalmpl.org.rascalmpl.Failed to clear thread local values inherited by reference finalizer thread.", t3);
        }
        thread.start();
    }

    private Finalizer(Class<?> finalizableReferenceClass, ReferenceQueue<org.rascalmpl.org.rascalmpl.java.lang.Object> queue, PhantomReference<org.rascalmpl.org.rascalmpl.java.lang.Object> frqReference) {
        this.queue = queue;
        this.finalizableReferenceClassReference = new WeakReference(finalizableReferenceClass);
        this.frqReference = frqReference;
    }

    public void run() {
        while (true) {
            try {
                while (this.cleanUp(this.queue.remove())) {
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private boolean cleanUp(Reference<?> firstReference) {
        Reference furtherReference;
        Method finalizeReferentMethod = this.getFinalizeReferentMethod();
        if (finalizeReferentMethod == null) {
            return false;
        }
        if (!this.finalizeReference(firstReference, finalizeReferentMethod)) {
            return false;
        }
        do {
            if ((furtherReference = this.queue.poll()) != null) continue;
            return true;
        } while (this.finalizeReference(furtherReference, finalizeReferentMethod));
        return false;
    }

    private boolean finalizeReference(Reference<?> reference, Method finalizeReferentMethod) {
        reference.clear();
        if (reference == this.frqReference) {
            return false;
        }
        try {
            finalizeReferentMethod.invoke(reference, new org.rascalmpl.org.rascalmpl.java.lang.Object[0]);
        }
        catch (Throwable t2) {
            logger.log(Level.SEVERE, (String)"org.rascalmpl.org.rascalmpl.Error cleaning up after reference.", t2);
        }
        return true;
    }

    @CheckForNull
    private Method getFinalizeReferentMethod() {
        Class finalizableReferenceClass = (Class)this.finalizableReferenceClassReference.get();
        if (finalizableReferenceClass == null) {
            return null;
        }
        try {
            return finalizableReferenceClass.getMethod((String)"org.rascalmpl.org.rascalmpl.finalizeReferent", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((org.rascalmpl.org.rascalmpl.java.lang.Object)e);
        }
    }

    @CheckForNull
    private static Field getInheritableThreadLocalsField() {
        try {
            Field inheritableThreadLocals = Thread.class.getDeclaredField((String)"org.rascalmpl.org.rascalmpl.inheritableThreadLocals");
            inheritableThreadLocals.setAccessible(true);
            return inheritableThreadLocals;
        }
        catch (Throwable t2) {
            logger.log(Level.INFO, (String)"org.rascalmpl.org.rascalmpl.Couldn't access Thread.inheritableThreadLocals. Reference finalizer threads will inherit thread local values.");
            return null;
        }
    }

    @CheckForNull
    private static Constructor<Thread> getBigThreadConstructor() {
        try {
            return Thread.class.getConstructor(new Class[]{ThreadGroup.class, Runnable.class, String.class, Long.TYPE, Boolean.TYPE});
        }
        catch (Throwable t2) {
            return null;
        }
    }
}

