/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.collect;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.BiMap;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ForwardingMap;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ForwardingMapEntry;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ForwardingSet;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.NullnessCasts;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ParametricNullness;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.concurrent.LazyInit;
import org.rascalmpl.org.rascalmpl.com.google.j2objc.annotations.RetainedWith;
import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.io.ObjectInputStream;
import org.rascalmpl.org.rascalmpl.java.io.ObjectOutputStream;
import org.rascalmpl.org.rascalmpl.java.io.Serializable;
import org.rascalmpl.org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.Iterator;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.Objects;
import org.rascalmpl.org.rascalmpl.java.util.Set;
import org.rascalmpl.org.rascalmpl.java.util.function.BiFunction;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
abstract class AbstractBiMap<K extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object>
extends ForwardingMap<K, V>
implements BiMap<K, V>,
Serializable {
    private transient Map<K, V> delegate;
    @RetainedWith
    transient AbstractBiMap<V, K> inverse;
    @LazyInit
    @CheckForNull
    private transient Set<K> keySet;
    @LazyInit
    @CheckForNull
    private transient Set<V> valueSet;
    @LazyInit
    @CheckForNull
    private transient Set<Map.Entry<K, V>> entrySet;
    @GwtIncompatible
    @J2ktIncompatible
    private static final long serialVersionUID = 0L;

    AbstractBiMap(Map<K, V> forward, Map<V, K> backward) {
        this.setDelegates(forward, backward);
    }

    private AbstractBiMap(Map<K, V> backward, AbstractBiMap<V, K> forward) {
        this.delegate = backward;
        this.inverse = forward;
    }

    @Override
    protected Map<K, V> delegate() {
        return this.delegate;
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    K checkKey(@ParametricNullness K key) {
        return key;
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    V checkValue(@ParametricNullness V value) {
        return value;
    }

    void setDelegates(Map<K, V> forward, Map<V, K> backward) {
        Preconditions.checkState(this.delegate == null);
        Preconditions.checkState(this.inverse == null);
        Preconditions.checkArgument(forward.isEmpty());
        Preconditions.checkArgument(backward.isEmpty());
        Preconditions.checkArgument(forward != backward);
        this.delegate = forward;
        this.inverse = this.makeInverse(backward);
    }

    AbstractBiMap<V, K> makeInverse(Map<V, K> backward) {
        return new Inverse<V, K>(backward, this);
    }

    void setInverse(AbstractBiMap<V, K> inverse) {
        this.inverse = inverse;
    }

    @Override
    public boolean containsValue(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object value) {
        return this.inverse.containsKey(value);
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V put(@ParametricNullness K key, @ParametricNullness V value) {
        return this.putInBothMaps(key, value, false);
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V forcePut(@ParametricNullness K key, @ParametricNullness V value) {
        return this.putInBothMaps(key, value, true);
    }

    @CheckForNull
    private V putInBothMaps(@ParametricNullness K key, @ParametricNullness V value, boolean force) {
        this.checkKey(key);
        this.checkValue(value);
        boolean containedKey = this.containsKey((org.rascalmpl.org.rascalmpl.java.lang.Object)key);
        if (containedKey && org.rascalmpl.org.rascalmpl.com.google.common.base.Objects.equal(value, this.get((org.rascalmpl.org.rascalmpl.java.lang.Object)key))) {
            return value;
        }
        if (force) {
            this.inverse().remove((org.rascalmpl.org.rascalmpl.java.lang.Object)value);
        } else {
            Preconditions.checkArgument(!this.containsValue((org.rascalmpl.org.rascalmpl.java.lang.Object)value), (String)"org.rascalmpl.org.rascalmpl.value already present: %s", value);
        }
        org.rascalmpl.org.rascalmpl.java.lang.Object oldValue = this.delegate.put(key, value);
        this.updateInverseMap(key, containedKey, oldValue, value);
        return (V)oldValue;
    }

    private void updateInverseMap(@ParametricNullness K key, boolean containedKey, @CheckForNull V oldValue, @ParametricNullness V newValue) {
        if (containedKey) {
            this.removeFromInverseMap(NullnessCasts.uncheckedCastNullableTToT(oldValue));
        }
        this.inverse.delegate.put(newValue, key);
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V remove(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object key) {
        return this.containsKey(key) ? (V)this.removeFromBothMaps(key) : null;
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    private V removeFromBothMaps(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object key) {
        org.rascalmpl.org.rascalmpl.java.lang.Object oldValue = NullnessCasts.uncheckedCastNullableTToT(this.delegate.remove(key));
        this.removeFromInverseMap(oldValue);
        return (V)oldValue;
    }

    private void removeFromInverseMap(@ParametricNullness V oldValue) {
        this.inverse.delegate.remove(oldValue);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.delegate.replaceAll(function);
        this.inverse.delegate.clear();
        Map.Entry broken = null;
        Iterator itr = this.delegate.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            org.rascalmpl.org.rascalmpl.java.lang.Object k = entry.getKey();
            org.rascalmpl.org.rascalmpl.java.lang.Object v = entry.getValue();
            org.rascalmpl.org.rascalmpl.java.lang.Object conflict = this.inverse.delegate.putIfAbsent(v, k);
            if (conflict == null) continue;
            broken = entry;
            itr.remove();
        }
        if (broken != null) {
            throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.value already present: ").append(broken.getValue()).toString());
        }
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.inverse.delegate.clear();
    }

    @Override
    public BiMap<V, K> inverse() {
        return this.inverse;
    }

    @Override
    public Set<K> keySet() {
        KeySet result = this.keySet;
        return result == null ? (this.keySet = new KeySet()) : result;
    }

    @Override
    public Set<V> values() {
        ValueSet result = this.valueSet;
        return result == null ? (this.valueSet = new ValueSet()) : result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet result = this.entrySet;
        return result == null ? (this.entrySet = new EntrySet()) : result;
    }

    Iterator<Map.Entry<K, V>> entrySetIterator() {
        final Iterator iterator = this.delegate.entrySet().iterator();
        return new Iterator<Map.Entry<K, V>>(){
            @CheckForNull
            Map.Entry<K, V> entry;

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Map.Entry<K, V> next() {
                this.entry = (Map.Entry)iterator.next();
                return new BiMapEntry(this.entry);
            }

            public void remove() {
                if (this.entry == null) {
                    throw new IllegalStateException((String)"org.rascalmpl.org.rascalmpl.no calls to next() since the last call to remove()");
                }
                org.rascalmpl.org.rascalmpl.java.lang.Object value = this.entry.getValue();
                iterator.remove();
                AbstractBiMap.this.removeFromInverseMap(value);
                this.entry = null;
            }
        };
    }

    static class Inverse<K extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object>
    extends AbstractBiMap<K, V> {
        @GwtIncompatible
        @J2ktIncompatible
        private static final long serialVersionUID = 0L;

        Inverse(Map<K, V> backward, AbstractBiMap<V, K> forward) {
            super(backward, forward);
        }

        @Override
        @ParametricNullness
        K checkKey(@ParametricNullness K key) {
            return this.inverse.checkValue(key);
        }

        @Override
        @ParametricNullness
        V checkValue(@ParametricNullness V value) {
            return this.inverse.checkKey(value);
        }

        @GwtIncompatible
        @J2ktIncompatible
        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            stream.writeObject(this.inverse());
        }

        @GwtIncompatible
        @J2ktIncompatible
        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.setInverse((AbstractBiMap)Objects.requireNonNull((org.rascalmpl.org.rascalmpl.java.lang.Object)stream.readObject()));
        }

        @GwtIncompatible
        @J2ktIncompatible
        org.rascalmpl.org.rascalmpl.java.lang.Object readResolve() {
            return this.inverse().inverse();
        }
    }

    private class EntrySet
    extends ForwardingSet<Map.Entry<K, V>> {
        final Set<Map.Entry<K, V>> esDelegate;

        private EntrySet() {
            this.esDelegate = AbstractBiMap.this.delegate.entrySet();
        }

        @Override
        protected Set<Map.Entry<K, V>> delegate() {
            return this.esDelegate;
        }

        @Override
        public void clear() {
            AbstractBiMap.this.clear();
        }

        @Override
        public boolean remove(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object object) {
            if (!this.esDelegate.contains(object) || !(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            AbstractBiMap.this.inverse.delegate.remove(entry.getValue());
            this.esDelegate.remove((org.rascalmpl.org.rascalmpl.java.lang.Object)entry);
            return true;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return AbstractBiMap.this.entrySetIterator();
        }

        @Override
        public @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object[] toArray() {
            return this.standardToArray();
        }

        @Override
        public <T extends org.rascalmpl.org.rascalmpl.java.lang.Object> T[] toArray(T[] array) {
            return this.standardToArray((org.rascalmpl.org.rascalmpl.java.lang.Object[])array);
        }

        @Override
        public boolean contains(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object o) {
            return Maps.containsEntryImpl(this.delegate(), o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.standardContainsAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.standardRemoveAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.standardRetainAll(c);
        }
    }

    class BiMapEntry
    extends ForwardingMapEntry<K, V> {
        private final Map.Entry<K, V> delegate;

        BiMapEntry(Map.Entry<K, V> delegate) {
            this.delegate = delegate;
        }

        @Override
        protected Map.Entry<K, V> delegate() {
            return this.delegate;
        }

        @Override
        public V setValue(V value) {
            AbstractBiMap.this.checkValue(value);
            Preconditions.checkState(AbstractBiMap.this.entrySet().contains((org.rascalmpl.org.rascalmpl.java.lang.Object)this), (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.entry no longer in map");
            if (org.rascalmpl.org.rascalmpl.com.google.common.base.Objects.equal(value, this.getValue())) {
                return value;
            }
            Preconditions.checkArgument(!AbstractBiMap.this.containsValue((org.rascalmpl.org.rascalmpl.java.lang.Object)value), (String)"org.rascalmpl.org.rascalmpl.value already present: %s", value);
            org.rascalmpl.org.rascalmpl.java.lang.Object oldValue = this.delegate.setValue(value);
            Preconditions.checkState(org.rascalmpl.org.rascalmpl.com.google.common.base.Objects.equal(value, AbstractBiMap.this.get((org.rascalmpl.org.rascalmpl.java.lang.Object)this.getKey())), (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.entry no longer in map");
            AbstractBiMap.this.updateInverseMap(this.getKey(), true, oldValue, value);
            return oldValue;
        }
    }

    private class ValueSet
    extends ForwardingSet<V> {
        final Set<V> valuesDelegate;

        private ValueSet() {
            this.valuesDelegate = AbstractBiMap.this.inverse.keySet();
        }

        @Override
        protected Set<V> delegate() {
            return this.valuesDelegate;
        }

        @Override
        public Iterator<V> iterator() {
            return Maps.valueIterator(AbstractBiMap.this.entrySet().iterator());
        }

        @Override
        public @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object[] toArray() {
            return this.standardToArray();
        }

        @Override
        public <T extends org.rascalmpl.org.rascalmpl.java.lang.Object> T[] toArray(T[] array) {
            return this.standardToArray((org.rascalmpl.org.rascalmpl.java.lang.Object[])array);
        }

        @Override
        public String toString() {
            return this.standardToString();
        }
    }

    private class KeySet
    extends ForwardingSet<K> {
        private KeySet() {
        }

        @Override
        protected Set<K> delegate() {
            return AbstractBiMap.this.delegate.keySet();
        }

        @Override
        public void clear() {
            AbstractBiMap.this.clear();
        }

        @Override
        public boolean remove(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object key) {
            if (!this.contains(key)) {
                return false;
            }
            AbstractBiMap.this.removeFromBothMaps(key);
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> keysToRemove) {
            return this.standardRemoveAll(keysToRemove);
        }

        @Override
        public boolean retainAll(Collection<?> keysToRetain) {
            return this.standardRetainAll(keysToRetain);
        }

        @Override
        public Iterator<K> iterator() {
            return Maps.keyIterator(AbstractBiMap.this.entrySet().iterator());
        }
    }
}

