/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.collect;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.AbstractMultiset;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.CollectPreconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Count;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Multiset;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Multisets;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ParametricNullness;
import org.rascalmpl.org.rascalmpl.com.google.common.primitives.Ints;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.java.io.InvalidObjectException;
import org.rascalmpl.org.rascalmpl.java.io.ObjectStreamException;
import org.rascalmpl.org.rascalmpl.java.io.Serializable;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.util.ConcurrentModificationException;
import org.rascalmpl.org.rascalmpl.java.util.Iterator;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.Objects;
import org.rascalmpl.org.rascalmpl.java.util.Set;
import org.rascalmpl.org.rascalmpl.java.util.function.ObjIntConsumer;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
abstract class AbstractMapBasedMultiset<E extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object>
extends AbstractMultiset<E>
implements Serializable {
    private transient Map<E, Count> backingMap;
    private transient long size;
    @GwtIncompatible
    @J2ktIncompatible
    private static final long serialVersionUID = -2250766705698539974L;

    protected AbstractMapBasedMultiset(Map<E, Count> backingMap) {
        Preconditions.checkArgument(backingMap.isEmpty());
        this.backingMap = backingMap;
    }

    void setBackingMap(Map<E, Count> backingMap) {
        this.backingMap = backingMap;
    }

    @Override
    public Set<Multiset.Entry<E>> entrySet() {
        return super.entrySet();
    }

    @Override
    Iterator<E> elementIterator() {
        final Iterator backingEntries = this.backingMap.entrySet().iterator();
        return new Iterator<E>(){
            @CheckForNull
            Map.Entry<E, Count> toRemove;

            public boolean hasNext() {
                return backingEntries.hasNext();
            }

            @ParametricNullness
            public E next() {
                Map.Entry mapEntry;
                this.toRemove = mapEntry = (Map.Entry)backingEntries.next();
                return mapEntry.getKey();
            }

            public void remove() {
                Preconditions.checkState(this.toRemove != null, (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.no calls to next() since the last call to remove()");
                AbstractMapBasedMultiset.this.size -= ((Count)this.toRemove.getValue()).getAndSet(0);
                backingEntries.remove();
                this.toRemove = null;
            }
        };
    }

    @Override
    Iterator<Multiset.Entry<E>> entryIterator() {
        final Iterator backingEntries = this.backingMap.entrySet().iterator();
        return new Iterator<Multiset.Entry<E>>(){
            @CheckForNull
            Map.Entry<E, Count> toRemove;

            public boolean hasNext() {
                return backingEntries.hasNext();
            }

            public Multiset.Entry<E> next() {
                Map.Entry mapEntry;
                this.toRemove = mapEntry = (Map.Entry)backingEntries.next();
                return new Multisets.AbstractEntry<E>(){

                    @Override
                    @ParametricNullness
                    public E getElement() {
                        return mapEntry.getKey();
                    }

                    @Override
                    public int getCount() {
                        Count frequency;
                        Count count = (Count)mapEntry.getValue();
                        if ((count == null || count.get() == 0) && (frequency = (Count)AbstractMapBasedMultiset.this.backingMap.get(this.getElement())) != null) {
                            return frequency.get();
                        }
                        return count == null ? 0 : count.get();
                    }
                };
            }

            public void remove() {
                Preconditions.checkState(this.toRemove != null, (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.no calls to next() since the last call to remove()");
                AbstractMapBasedMultiset.this.size -= ((Count)this.toRemove.getValue()).getAndSet(0);
                backingEntries.remove();
                this.toRemove = null;
            }
        };
    }

    /*
     * Exception decompiling
     */
    @Override
    public void forEachEntry(ObjIntConsumer<? super E> action) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/org/rascalmpl/java/lang/Object;Lorg/rascalmpl/org/rascalmpl/java/lang/Object;)V
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void clear() {
        for (Count frequency : this.backingMap.values()) {
            frequency.set(0);
        }
        this.backingMap.clear();
        this.size = 0L;
    }

    @Override
    int distinctElements() {
        return this.backingMap.size();
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.size);
    }

    @Override
    public Iterator<E> iterator() {
        return new MapBasedMultisetIterator();
    }

    @Override
    public int count(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object element) {
        Count frequency = Maps.safeGet(this.backingMap, element);
        return frequency == null ? 0 : frequency.get();
    }

    @Override
    @CanIgnoreReturnValue
    public int add(@ParametricNullness E element, int occurrences) {
        int oldCount;
        if (occurrences == 0) {
            return this.count((org.rascalmpl.org.rascalmpl.java.lang.Object)element);
        }
        Preconditions.checkArgument(occurrences > 0, (String)"org.rascalmpl.org.rascalmpl.occurrences cannot be negative: %s", occurrences);
        Count frequency = (Count)this.backingMap.get(element);
        if (frequency == null) {
            oldCount = 0;
            this.backingMap.put(element, (org.rascalmpl.org.rascalmpl.java.lang.Object)new Count(occurrences));
        } else {
            oldCount = frequency.get();
            long newCount = (long)oldCount + (long)occurrences;
            Preconditions.checkArgument(newCount <= Integer.MAX_VALUE, (String)"org.rascalmpl.org.rascalmpl.too many occurrences: %s", newCount);
            frequency.add(occurrences);
        }
        this.size += (long)occurrences;
        return oldCount;
    }

    @Override
    @CanIgnoreReturnValue
    public int remove(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object element, int occurrences) {
        int numberRemoved;
        if (occurrences == 0) {
            return this.count(element);
        }
        Preconditions.checkArgument(occurrences > 0, (String)"org.rascalmpl.org.rascalmpl.occurrences cannot be negative: %s", occurrences);
        Count frequency = (Count)this.backingMap.get(element);
        if (frequency == null) {
            return 0;
        }
        int oldCount = frequency.get();
        if (oldCount > occurrences) {
            numberRemoved = occurrences;
        } else {
            numberRemoved = oldCount;
            this.backingMap.remove(element);
        }
        frequency.add(-numberRemoved);
        this.size -= (long)numberRemoved;
        return oldCount;
    }

    @Override
    @CanIgnoreReturnValue
    public int setCount(@ParametricNullness E element, int count) {
        int oldCount;
        CollectPreconditions.checkNonnegative(count, (String)"org.rascalmpl.org.rascalmpl.count");
        if (count == 0) {
            Count existingCounter = (Count)this.backingMap.remove(element);
            oldCount = AbstractMapBasedMultiset.getAndSet(existingCounter, count);
        } else {
            Count existingCounter = (Count)this.backingMap.get(element);
            oldCount = AbstractMapBasedMultiset.getAndSet(existingCounter, count);
            if (existingCounter == null) {
                this.backingMap.put(element, (org.rascalmpl.org.rascalmpl.java.lang.Object)new Count(count));
            }
        }
        this.size += (long)(count - oldCount);
        return oldCount;
    }

    private static int getAndSet(@CheckForNull Count i, int count) {
        if (i == null) {
            return 0;
        }
        return i.getAndSet(count);
    }

    @GwtIncompatible
    @J2ktIncompatible
    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException((String)"org.rascalmpl.org.rascalmpl.Stream data required");
    }

    private static /* synthetic */ void lambda$forEachEntry$0(ObjIntConsumer action, org.rascalmpl.org.rascalmpl.java.lang.Object element, Count count) {
        action.accept(element, count.get());
    }

    private class MapBasedMultisetIterator
    extends org.rascalmpl.org.rascalmpl.java.lang.Object
    implements Iterator<E> {
        final Iterator<Map.Entry<E, Count>> entryIterator;
        @CheckForNull
        Map.Entry<E, Count> currentEntry;
        int occurrencesLeft;
        boolean canRemove;

        MapBasedMultisetIterator() {
            this.entryIterator = AbstractMapBasedMultiset.this.backingMap.entrySet().iterator();
        }

        public boolean hasNext() {
            return this.occurrencesLeft > 0 || this.entryIterator.hasNext();
        }

        @ParametricNullness
        public E next() {
            if (this.occurrencesLeft == 0) {
                this.currentEntry = (Map.Entry)this.entryIterator.next();
                this.occurrencesLeft = ((Count)this.currentEntry.getValue()).get();
            }
            --this.occurrencesLeft;
            this.canRemove = true;
            return ((Map.Entry)Objects.requireNonNull(this.currentEntry)).getKey();
        }

        public void remove() {
            CollectPreconditions.checkRemove(this.canRemove);
            int frequency = ((Count)((Map.Entry)Objects.requireNonNull(this.currentEntry)).getValue()).get();
            if (frequency <= 0) {
                throw new ConcurrentModificationException();
            }
            if (((Count)this.currentEntry.getValue()).addAndGet(-1) == 0) {
                this.entryIterator.remove();
            }
            AbstractMapBasedMultiset.this.size--;
            this.canRemove = false;
        }
    }
}

