/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.collect;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Iterators;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Multimap;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Multimaps;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Multiset;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ParametricNullness;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.SetMultimap;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Sets;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.concurrent.LazyInit;
import org.rascalmpl.org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.util.AbstractCollection;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.Iterator;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.Set;
import org.rascalmpl.org.rascalmpl.java.util.Spliterator;
import org.rascalmpl.org.rascalmpl.java.util.Spliterators;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class AbstractMultimap<K extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object>
extends org.rascalmpl.org.rascalmpl.java.lang.Object
implements Multimap<K, V> {
    @LazyInit
    @CheckForNull
    private transient Collection<Map.Entry<K, V>> entries;
    @LazyInit
    @CheckForNull
    private transient Set<K> keySet;
    @LazyInit
    @CheckForNull
    private transient Multiset<K> keys;
    @LazyInit
    @CheckForNull
    private transient Collection<V> values;
    @LazyInit
    @CheckForNull
    private transient Map<K, Collection<V>> asMap;

    AbstractMultimap() {
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsValue(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object value) {
        for (Collection collection : this.asMap().values()) {
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEntry(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object key, @CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object value) {
        Collection collection = (Collection)this.asMap().get(key);
        return collection != null && collection.contains(value);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean remove(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object key, @CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object value) {
        Collection collection = (Collection)this.asMap().get(key);
        return collection != null && collection.remove(value);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean put(@ParametricNullness K key, @ParametricNullness V value) {
        return this.get((org.rascalmpl.org.rascalmpl.java.lang.Object)key).add(value);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean putAll(@ParametricNullness K key, Iterable<? extends V> values) {
        Preconditions.checkNotNull(values);
        if (values instanceof Collection) {
            Collection valueCollection = (Collection)values;
            return !valueCollection.isEmpty() && this.get((org.rascalmpl.org.rascalmpl.java.lang.Object)key).addAll(valueCollection);
        }
        Iterator valueItr = values.iterator();
        return valueItr.hasNext() && Iterators.addAll(this.get((org.rascalmpl.org.rascalmpl.java.lang.Object)key), valueItr);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        boolean changed = false;
        for (Map.Entry entry : multimap.entries()) {
            changed |= this.put(entry.getKey(), entry.getValue());
        }
        return changed;
    }

    @Override
    @CanIgnoreReturnValue
    public Collection<V> replaceValues(@ParametricNullness K key, Iterable<? extends V> values) {
        Preconditions.checkNotNull(values);
        Collection result = this.removeAll((org.rascalmpl.org.rascalmpl.java.lang.Object)key);
        this.putAll(key, values);
        return result;
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        Collection<Map.Entry<K, V>> result = this.entries;
        return result == null ? (this.entries = this.createEntries()) : result;
    }

    abstract Collection<Map.Entry<K, V>> createEntries();

    abstract Iterator<Map.Entry<K, V>> entryIterator();

    Spliterator<Map.Entry<K, V>> entrySpliterator() {
        return Spliterators.spliterator(this.entryIterator(), (long)this.size(), (int)(this instanceof SetMultimap ? 1 : 0));
    }

    @Override
    public Set<K> keySet() {
        Set<K> result = this.keySet;
        return result == null ? (this.keySet = this.createKeySet()) : result;
    }

    abstract Set<K> createKeySet();

    @Override
    public Multiset<K> keys() {
        Multiset<K> result = this.keys;
        return result == null ? (this.keys = this.createKeys()) : result;
    }

    abstract Multiset<K> createKeys();

    @Override
    public Collection<V> values() {
        Collection<V> result = this.values;
        return result == null ? (this.values = this.createValues()) : result;
    }

    abstract Collection<V> createValues();

    Iterator<V> valueIterator() {
        return Maps.valueIterator(this.entries().iterator());
    }

    Spliterator<V> valueSpliterator() {
        return Spliterators.spliterator(this.valueIterator(), (long)this.size(), (int)0);
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        Map<K, Collection<V>> result = this.asMap;
        return result == null ? (this.asMap = this.createAsMap()) : result;
    }

    abstract Map<K, Collection<V>> createAsMap();

    @Override
    public boolean equals(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object object) {
        return Multimaps.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return this.asMap().hashCode();
    }

    public String toString() {
        return this.asMap().toString();
    }

    class Values
    extends AbstractCollection<V> {
        Values() {
        }

        public Iterator<V> iterator() {
            return AbstractMultimap.this.valueIterator();
        }

        public Spliterator<V> spliterator() {
            return AbstractMultimap.this.valueSpliterator();
        }

        public int size() {
            return AbstractMultimap.this.size();
        }

        public boolean contains(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object o) {
            return AbstractMultimap.this.containsValue(o);
        }

        public void clear() {
            AbstractMultimap.this.clear();
        }
    }

    class EntrySet
    extends Entries
    implements Set<Map.Entry<K, V>> {
        EntrySet() {
        }

        public int hashCode() {
            return Sets.hashCodeImpl(this);
        }

        public boolean equals(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object obj) {
            return Sets.equalsImpl(this, obj);
        }
    }

    class Entries
    extends Multimaps.Entries<K, V> {
        Entries() {
        }

        @Override
        Multimap<K, V> multimap() {
            return AbstractMultimap.this;
        }

        public Iterator<Map.Entry<K, V>> iterator() {
            return AbstractMultimap.this.entryIterator();
        }

        public Spliterator<Map.Entry<K, V>> spliterator() {
            return AbstractMultimap.this.entrySpliterator();
        }
    }
}

