/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.collect;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.AbstractMapBasedMultimap;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.AbstractSetMultimap;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ParametricNullness;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Sets;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.SortedSetMultimap;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.Collections;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.NavigableSet;
import org.rascalmpl.org.rascalmpl.java.util.SortedSet;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class AbstractSortedSetMultimap<K extends @Nullable Object, V extends @Nullable Object>
extends AbstractSetMultimap<K, V>
implements SortedSetMultimap<K, V> {
    private static final long serialVersionUID = 430848587173315748L;

    protected AbstractSortedSetMultimap(Map<K, Collection<V>> map) {
        super(map);
    }

    @Override
    abstract SortedSet<V> createCollection();

    @Override
    SortedSet<V> createUnmodifiableEmptyCollection() {
        return this.unmodifiableCollectionSubclass((Collection<E>)((Collection)this.createCollection()));
    }

    @Override
    <E extends Object> SortedSet<E> unmodifiableCollectionSubclass(Collection<E> collection) {
        if (collection instanceof NavigableSet) {
            return Sets.unmodifiableNavigableSet((NavigableSet)collection);
        }
        return Collections.unmodifiableSortedSet((SortedSet)((SortedSet)collection));
    }

    @Override
    Collection<V> wrapCollection(@ParametricNullness K key, Collection<V> collection) {
        if (collection instanceof NavigableSet) {
            return new AbstractMapBasedMultimap.WrappedNavigableSet((AbstractMapBasedMultimap)this, key, (NavigableSet)collection, null);
        }
        return new AbstractMapBasedMultimap.WrappedSortedSet((AbstractMapBasedMultimap)this, key, (SortedSet)collection, null);
    }

    @Override
    public SortedSet<V> get(@ParametricNullness K key) {
        return (SortedSet)super.get(key);
    }

    @Override
    @CanIgnoreReturnValue
    public SortedSet<V> removeAll(@CheckForNull Object key) {
        return (SortedSet)super.removeAll(key);
    }

    @Override
    @CanIgnoreReturnValue
    public SortedSet<V> replaceValues(@ParametricNullness K key, Iterable<? extends V> values) {
        return (SortedSet)super.replaceValues(key, values);
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        return super.asMap();
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }
}

