/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.collect;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Objects;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.AbstractMapEntry;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.CollectPreconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.CompactHashing;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Hashing;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.NullnessCasts;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ObjectArrays;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ParametricNullness;
import org.rascalmpl.org.rascalmpl.com.google.common.primitives.Ints;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.concurrent.LazyInit;
import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.io.InvalidObjectException;
import org.rascalmpl.org.rascalmpl.java.io.ObjectInputStream;
import org.rascalmpl.org.rascalmpl.java.io.ObjectOutputStream;
import org.rascalmpl.org.rascalmpl.java.io.Serializable;
import org.rascalmpl.org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.org.rascalmpl.java.lang.Integer;
import org.rascalmpl.org.rascalmpl.java.lang.Math;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.util.AbstractMap;
import org.rascalmpl.org.rascalmpl.java.util.Arrays;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.ConcurrentModificationException;
import org.rascalmpl.org.rascalmpl.java.util.Iterator;
import org.rascalmpl.org.rascalmpl.java.util.LinkedHashMap;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.NoSuchElementException;
import org.rascalmpl.org.rascalmpl.java.util.Set;
import org.rascalmpl.org.rascalmpl.java.util.Spliterator;
import org.rascalmpl.org.rascalmpl.java.util.Spliterators;
import org.rascalmpl.org.rascalmpl.java.util.function.BiConsumer;
import org.rascalmpl.org.rascalmpl.java.util.function.BiFunction;
import org.rascalmpl.org.rascalmpl.java.util.function.Consumer;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
class CompactHashMap<K extends @Nullable Object, V extends @Nullable Object>
extends AbstractMap<K, V>
implements Serializable {
    private static final Object NOT_FOUND = new Object();
    @VisibleForTesting
    static final double HASH_FLOODING_FPP = 0.001;
    private static final int MAX_HASH_BUCKET_LENGTH = 9;
    @CheckForNull
    private transient Object table;
    @CheckForNull
    @VisibleForTesting
    transient int[] entries;
    @CheckForNull
    @VisibleForTesting
    transient @Nullable Object[] keys;
    @CheckForNull
    @VisibleForTesting
    transient @Nullable Object[] values;
    private transient int metadata;
    private transient int size;
    @LazyInit
    @CheckForNull
    private transient Set<K> keySetView;
    @LazyInit
    @CheckForNull
    private transient Set<Map.Entry<K, V>> entrySetView;
    @LazyInit
    @CheckForNull
    private transient Collection<V> valuesView;

    public static <K extends Object, V extends Object> CompactHashMap<K, V> create() {
        return new CompactHashMap<K, V>();
    }

    public static <K extends Object, V extends Object> CompactHashMap<K, V> createWithExpectedSize(int expectedSize) {
        return new CompactHashMap<K, V>(expectedSize);
    }

    CompactHashMap() {
        this.init(3);
    }

    CompactHashMap(int expectedSize) {
        this.init(expectedSize);
    }

    void init(int expectedSize) {
        Preconditions.checkArgument(expectedSize >= 0, (Object)"org.rascalmpl.org.rascalmpl.Expected size must be >= 0");
        this.metadata = Ints.constrainToRange(expectedSize, 1, 0x3FFFFFFF);
    }

    boolean needsAllocArrays() {
        return this.table == null;
    }

    @CanIgnoreReturnValue
    int allocArrays() {
        Preconditions.checkState(this.needsAllocArrays(), (Object)"org.rascalmpl.org.rascalmpl.Arrays already allocated");
        int expectedSize = this.metadata;
        int buckets = CompactHashing.tableSize(expectedSize);
        this.table = CompactHashing.createTable(buckets);
        this.setHashTableMask(buckets - 1);
        this.entries = new int[expectedSize];
        this.keys = new Object[expectedSize];
        this.values = new Object[expectedSize];
        return expectedSize;
    }

    @CheckForNull
    @VisibleForTesting
    Map<K, V> delegateOrNull() {
        if (this.table instanceof Map) {
            return (Map)this.table;
        }
        return null;
    }

    Map<K, V> createHashFloodingResistantDelegate(int tableSize) {
        return new LinkedHashMap(tableSize, 1.0f);
    }

    @CanIgnoreReturnValue
    Map<K, V> convertToHashFloodingResistantImplementation() {
        Map<K, V> newDelegate = this.createHashFloodingResistantDelegate(this.hashTableMask() + 1);
        int i = this.firstEntryIndex();
        while (i >= 0) {
            newDelegate.put(this.key(i), this.value(i));
            i = this.getSuccessor(i);
        }
        this.table = newDelegate;
        this.entries = null;
        this.keys = null;
        this.values = null;
        this.incrementModCount();
        return newDelegate;
    }

    private void setHashTableMask(int mask) {
        int hashTableBits = 32 - Integer.numberOfLeadingZeros((int)mask);
        this.metadata = CompactHashing.maskCombine(this.metadata, hashTableBits, 31);
    }

    private int hashTableMask() {
        return (1 << (this.metadata & 0x1F)) - 1;
    }

    void incrementModCount() {
        this.metadata += 32;
    }

    void accessEntry(int index) {
    }

    @CheckForNull
    @CanIgnoreReturnValue
    public V put(@ParametricNullness K key, @ParametricNullness V value) {
        Map<K, V> delegate;
        if (this.needsAllocArrays()) {
            this.allocArrays();
        }
        if ((delegate = this.delegateOrNull()) != null) {
            return (V)delegate.put(key, value);
        }
        int[] entries = this.requireEntries();
        @Nullable Object[] keys = this.requireKeys();
        @Nullable Object[] values = this.requireValues();
        int newEntryIndex = this.size;
        int newSize = newEntryIndex + 1;
        int hash = Hashing.smearedHash(key);
        int mask = this.hashTableMask();
        int tableIndex = hash & mask;
        int next = CompactHashing.tableGet(this.requireTable(), tableIndex);
        if (next == 0) {
            if (newSize > mask) {
                mask = this.resizeTable(mask, CompactHashing.newCapacity(mask), hash, newEntryIndex);
            } else {
                CompactHashing.tableSet(this.requireTable(), tableIndex, newEntryIndex + 1);
            }
        } else {
            int entry;
            int hashPrefix = CompactHashing.getHashPrefix(hash, mask);
            int bucketLength = 0;
            do {
                int entryIndex;
                if (CompactHashing.getHashPrefix(entry = entries[entryIndex = next - 1], mask) == hashPrefix && Objects.equal(key, keys[entryIndex])) {
                    Object oldValue = values[entryIndex];
                    values[entryIndex] = value;
                    this.accessEntry(entryIndex);
                    return (V)oldValue;
                }
                next = CompactHashing.getNext(entry, mask);
                ++bucketLength;
            } while (next != 0);
            if (bucketLength >= 9) {
                return (V)this.convertToHashFloodingResistantImplementation().put(key, value);
            }
            if (newSize > mask) {
                mask = this.resizeTable(mask, CompactHashing.newCapacity(mask), hash, newEntryIndex);
            } else {
                entries[entryIndex] = CompactHashing.maskCombine(entry, newEntryIndex + 1, mask);
            }
        }
        this.resizeMeMaybe(newSize);
        this.insertEntry(newEntryIndex, key, value, hash, mask);
        this.size = newSize;
        this.incrementModCount();
        return null;
    }

    void insertEntry(int entryIndex, @ParametricNullness K key, @ParametricNullness V value, int hash, int mask) {
        this.setEntry(entryIndex, CompactHashing.maskCombine(hash, 0, mask));
        this.setKey(entryIndex, key);
        this.setValue(entryIndex, value);
    }

    private void resizeMeMaybe(int newSize) {
        int newCapacity;
        int entriesSize = this.requireEntries().length;
        if (newSize > entriesSize && (newCapacity = Math.min((int)0x3FFFFFFF, (int)(entriesSize + Math.max((int)1, (int)(entriesSize >>> 1)) | 1))) != entriesSize) {
            this.resizeEntries(newCapacity);
        }
    }

    void resizeEntries(int newCapacity) {
        this.entries = Arrays.copyOf((int[])this.requireEntries(), (int)newCapacity);
        this.keys = Arrays.copyOf((Object[])this.requireKeys(), (int)newCapacity);
        this.values = Arrays.copyOf((Object[])this.requireValues(), (int)newCapacity);
    }

    @CanIgnoreReturnValue
    private int resizeTable(int oldMask, int newCapacity, int targetHash, int targetEntryIndex) {
        Object newTable = CompactHashing.createTable(newCapacity);
        int newMask = newCapacity - 1;
        if (targetEntryIndex != 0) {
            CompactHashing.tableSet(newTable, targetHash & newMask, targetEntryIndex + 1);
        }
        Object oldTable = this.requireTable();
        int[] entries = this.requireEntries();
        for (int oldTableIndex = 0; oldTableIndex <= oldMask; ++oldTableIndex) {
            int oldNext = CompactHashing.tableGet(oldTable, oldTableIndex);
            while (oldNext != 0) {
                int entryIndex = oldNext - 1;
                int oldEntry = entries[entryIndex];
                int hash = CompactHashing.getHashPrefix(oldEntry, oldMask) | oldTableIndex;
                int newTableIndex = hash & newMask;
                int newNext = CompactHashing.tableGet(newTable, newTableIndex);
                CompactHashing.tableSet(newTable, newTableIndex, oldNext);
                entries[entryIndex] = CompactHashing.maskCombine(hash, newNext, newMask);
                oldNext = CompactHashing.getNext(oldEntry, oldMask);
            }
        }
        this.table = newTable;
        this.setHashTableMask(newMask);
        return newMask;
    }

    private int indexOf(@CheckForNull Object key) {
        int entry;
        if (this.needsAllocArrays()) {
            return -1;
        }
        int hash = Hashing.smearedHash(key);
        int mask = this.hashTableMask();
        int next = CompactHashing.tableGet(this.requireTable(), hash & mask);
        if (next == 0) {
            return -1;
        }
        int hashPrefix = CompactHashing.getHashPrefix(hash, mask);
        do {
            int entryIndex;
            if (CompactHashing.getHashPrefix(entry = this.entry(entryIndex = next - 1), mask) != hashPrefix || !Objects.equal(key, this.key(entryIndex))) continue;
            return entryIndex;
        } while ((next = CompactHashing.getNext(entry, mask)) != 0);
        return -1;
    }

    public boolean containsKey(@CheckForNull Object key) {
        Map<K, V> delegate = this.delegateOrNull();
        return delegate != null ? delegate.containsKey(key) : this.indexOf(key) != -1;
    }

    @CheckForNull
    public V get(@CheckForNull Object key) {
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            return (V)delegate.get(key);
        }
        int index = this.indexOf(key);
        if (index == -1) {
            return null;
        }
        this.accessEntry(index);
        return this.value(index);
    }

    @CheckForNull
    @CanIgnoreReturnValue
    public V remove(@CheckForNull Object key) {
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            return (V)delegate.remove(key);
        }
        Object oldValue = this.removeHelper(key);
        return (V)(oldValue == NOT_FOUND ? null : oldValue);
    }

    private @Nullable Object removeHelper(@CheckForNull Object key) {
        if (this.needsAllocArrays()) {
            return NOT_FOUND;
        }
        int mask = this.hashTableMask();
        int index = CompactHashing.remove(key, null, mask, this.requireTable(), this.requireEntries(), this.requireKeys(), null);
        if (index == -1) {
            return NOT_FOUND;
        }
        V oldValue = this.value(index);
        this.moveLastEntry(index, mask);
        --this.size;
        this.incrementModCount();
        return oldValue;
    }

    void moveLastEntry(int dstIndex, int mask) {
        Object table = this.requireTable();
        int[] entries = this.requireEntries();
        @Nullable Object[] keys = this.requireKeys();
        @Nullable Object[] values = this.requireValues();
        int srcIndex = this.size() - 1;
        if (dstIndex < srcIndex) {
            int srcNext;
            Object key;
            keys[dstIndex] = key = keys[srcIndex];
            values[dstIndex] = values[srcIndex];
            keys[srcIndex] = null;
            values[srcIndex] = null;
            entries[dstIndex] = entries[srcIndex];
            entries[srcIndex] = 0;
            int tableIndex = Hashing.smearedHash(key) & mask;
            int next = CompactHashing.tableGet(table, tableIndex);
            if (next == (srcNext = srcIndex + 1)) {
                CompactHashing.tableSet(table, tableIndex, dstIndex + 1);
            } else {
                int entryIndex;
                int entry;
                while ((next = CompactHashing.getNext(entry = entries[entryIndex = next - 1], mask)) != srcNext) {
                }
                entries[entryIndex] = CompactHashing.maskCombine(entry, dstIndex + 1, mask);
            }
        } else {
            keys[dstIndex] = null;
            values[dstIndex] = null;
            entries[dstIndex] = 0;
        }
    }

    int firstEntryIndex() {
        return this.isEmpty() ? -1 : 0;
    }

    int getSuccessor(int entryIndex) {
        return entryIndex + 1 < this.size ? entryIndex + 1 : -1;
    }

    int adjustAfterRemove(int indexBeforeRemove, int indexRemoved) {
        return indexBeforeRemove - 1;
    }

    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        Preconditions.checkNotNull(function);
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            delegate.replaceAll(function);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setValue(i, function.apply(this.key(i), this.value(i)));
            }
        }
    }

    public Set<K> keySet() {
        return this.keySetView == null ? (this.keySetView = this.createKeySet()) : this.keySetView;
    }

    Set<K> createKeySet() {
        return new KeySetView();
    }

    Iterator<K> keySetIterator() {
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            return delegate.keySet().iterator();
        }
        return new Itr<K>(){

            @Override
            @ParametricNullness
            K getOutput(int entry) {
                return CompactHashMap.this.key(entry);
            }
        };
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            delegate.forEach(action);
        } else {
            int i = this.firstEntryIndex();
            while (i >= 0) {
                action.accept(this.key(i), this.value(i));
                i = this.getSuccessor(i);
            }
        }
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySetView == null ? (this.entrySetView = this.createEntrySet()) : this.entrySetView;
    }

    Set<Map.Entry<K, V>> createEntrySet() {
        return new EntrySetView();
    }

    Iterator<Map.Entry<K, V>> entrySetIterator() {
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            return delegate.entrySet().iterator();
        }
        return new Itr<Map.Entry<K, V>>(){

            @Override
            Map.Entry<K, V> getOutput(int entry) {
                return new MapEntry(entry);
            }
        };
    }

    public int size() {
        Map<K, V> delegate = this.delegateOrNull();
        return delegate != null ? delegate.size() : this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsValue(@CheckForNull Object value) {
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            return delegate.containsValue(value);
        }
        for (int i = 0; i < this.size; ++i) {
            if (!Objects.equal(value, this.value(i))) continue;
            return true;
        }
        return false;
    }

    public Collection<V> values() {
        return this.valuesView == null ? (this.valuesView = this.createValues()) : this.valuesView;
    }

    Collection<V> createValues() {
        return new ValuesView();
    }

    Iterator<V> valuesIterator() {
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            return delegate.values().iterator();
        }
        return new Itr<V>(){

            @Override
            @ParametricNullness
            V getOutput(int entry) {
                return CompactHashMap.this.value(entry);
            }
        };
    }

    public void trimToSize() {
        int mask;
        int minimumTableSize;
        if (this.needsAllocArrays()) {
            return;
        }
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            Map<K, V> newDelegate = this.createHashFloodingResistantDelegate(this.size());
            newDelegate.putAll(delegate);
            this.table = newDelegate;
            return;
        }
        int size = this.size;
        if (size < this.requireEntries().length) {
            this.resizeEntries(size);
        }
        if ((minimumTableSize = CompactHashing.tableSize(size)) < (mask = this.hashTableMask())) {
            this.resizeTable(mask, minimumTableSize, 0, 0);
        }
    }

    public void clear() {
        if (this.needsAllocArrays()) {
            return;
        }
        this.incrementModCount();
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            this.metadata = Ints.constrainToRange(this.size(), 3, 0x3FFFFFFF);
            delegate.clear();
            this.table = null;
            this.size = 0;
        } else {
            Arrays.fill((Object[])this.requireKeys(), (int)0, (int)this.size, null);
            Arrays.fill((Object[])this.requireValues(), (int)0, (int)this.size, null);
            CompactHashing.tableClear(this.requireTable());
            Arrays.fill((int[])this.requireEntries(), (int)0, (int)this.size, (int)0);
            this.size = 0;
        }
    }

    @J2ktIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.size());
        Iterator<Map.Entry<K, V>> entryIterator = this.entrySetIterator();
        while (entryIterator.hasNext()) {
            Map.Entry e = (Map.Entry)entryIterator.next();
            stream.writeObject(e.getKey());
            stream.writeObject(e.getValue());
        }
    }

    @J2ktIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int elementCount = stream.readInt();
        if (elementCount < 0) {
            throw new InvalidObjectException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Invalid size: ").append(elementCount).toString());
        }
        this.init(elementCount);
        for (int i = 0; i < elementCount; ++i) {
            Object key = stream.readObject();
            Object value = stream.readObject();
            this.put(key, value);
        }
    }

    private Object requireTable() {
        return org.rascalmpl.org.rascalmpl.java.util.Objects.requireNonNull((Object)this.table);
    }

    private int[] requireEntries() {
        return (int[])org.rascalmpl.org.rascalmpl.java.util.Objects.requireNonNull((Object)this.entries);
    }

    private @Nullable Object[] requireKeys() {
        return (Object[])org.rascalmpl.org.rascalmpl.java.util.Objects.requireNonNull((Object)this.keys);
    }

    private @Nullable Object[] requireValues() {
        return (Object[])org.rascalmpl.org.rascalmpl.java.util.Objects.requireNonNull((Object)this.values);
    }

    private K key(int i) {
        return (K)this.requireKeys()[i];
    }

    private V value(int i) {
        return (V)this.requireValues()[i];
    }

    private int entry(int i) {
        return this.requireEntries()[i];
    }

    private void setKey(int i, K key) {
        this.requireKeys()[i] = key;
    }

    private void setValue(int i, V value) {
        this.requireValues()[i] = value;
    }

    private void setEntry(int i, int value) {
        this.requireEntries()[i] = value;
    }

    class ValuesView
    extends Maps.Values<K, V> {
        ValuesView() {
            super(CompactHashMap.this);
        }

        @Override
        public Iterator<V> iterator() {
            return CompactHashMap.this.valuesIterator();
        }

        @Override
        public void forEach(Consumer<? super V> action) {
            Preconditions.checkNotNull(action);
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                delegate.values().forEach(action);
            } else {
                int i = CompactHashMap.this.firstEntryIndex();
                while (i >= 0) {
                    action.accept(CompactHashMap.this.value(i));
                    i = CompactHashMap.this.getSuccessor(i);
                }
            }
        }

        public Spliterator<V> spliterator() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return Spliterators.spliterator((Object[])new Object[0], (int)16);
            }
            Map delegate = CompactHashMap.this.delegateOrNull();
            return delegate != null ? delegate.values().spliterator() : Spliterators.spliterator((Object[])CompactHashMap.this.requireValues(), (int)0, (int)CompactHashMap.this.size, (int)16);
        }

        public @Nullable Object[] toArray() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return new Object[0];
            }
            Map delegate = CompactHashMap.this.delegateOrNull();
            return delegate != null ? delegate.values().toArray() : ObjectArrays.copyAsObjectArray(CompactHashMap.this.requireValues(), 0, CompactHashMap.this.size);
        }

        public <T extends Object> T[] toArray(T[] a) {
            if (CompactHashMap.this.needsAllocArrays()) {
                if (a.length > 0) {
                    @Nullable T[] unsoundlyCovariantArray = a;
                    unsoundlyCovariantArray[0] = null;
                }
                return a;
            }
            Map delegate = CompactHashMap.this.delegateOrNull();
            return delegate != null ? delegate.values().toArray(a) : ObjectArrays.toArrayImpl((Object[])CompactHashMap.this.requireValues(), (int)0, (int)CompactHashMap.this.size, a);
        }
    }

    final class MapEntry
    extends AbstractMapEntry<K, V> {
        @ParametricNullness
        private final K key;
        private int lastKnownIndex;

        MapEntry(int index) {
            this.key = CompactHashMap.this.key(index);
            this.lastKnownIndex = index;
        }

        @Override
        @ParametricNullness
        public K getKey() {
            return this.key;
        }

        private void updateLastKnownIndex() {
            if (this.lastKnownIndex == -1 || this.lastKnownIndex >= CompactHashMap.this.size() || !Objects.equal(this.key, CompactHashMap.this.key(this.lastKnownIndex))) {
                this.lastKnownIndex = CompactHashMap.this.indexOf(this.key);
            }
        }

        @Override
        @ParametricNullness
        public V getValue() {
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                return NullnessCasts.uncheckedCastNullableTToT(delegate.get(this.key));
            }
            this.updateLastKnownIndex();
            return this.lastKnownIndex == -1 ? NullnessCasts.unsafeNull() : CompactHashMap.this.value(this.lastKnownIndex);
        }

        @Override
        @ParametricNullness
        public V setValue(@ParametricNullness V value) {
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                return NullnessCasts.uncheckedCastNullableTToT(delegate.put(this.key, value));
            }
            this.updateLastKnownIndex();
            if (this.lastKnownIndex == -1) {
                CompactHashMap.this.put(this.key, value);
                return NullnessCasts.unsafeNull();
            }
            Object old = CompactHashMap.this.value(this.lastKnownIndex);
            CompactHashMap.this.setValue(this.lastKnownIndex, value);
            return old;
        }
    }

    class EntrySetView
    extends Maps.EntrySet<K, V> {
        EntrySetView() {
        }

        @Override
        Map<K, V> map() {
            return CompactHashMap.this;
        }

        public Iterator<Map.Entry<K, V>> iterator() {
            return CompactHashMap.this.entrySetIterator();
        }

        /*
         * Exception decompiling
         */
        public Spliterator<Map.Entry<K, V>> spliterator() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodType, got (I)Lorg/rascalmpl/org/rascalmpl/java/lang/Object;
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean contains(@CheckForNull Object o) {
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                return delegate.entrySet().contains(o);
            }
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                int index = CompactHashMap.this.indexOf(entry.getKey());
                return index != -1 && Objects.equal(CompactHashMap.this.value(index), entry.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(@CheckForNull Object o) {
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                return delegate.entrySet().remove(o);
            }
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                if (CompactHashMap.this.needsAllocArrays()) {
                    return false;
                }
                int mask = CompactHashMap.this.hashTableMask();
                int index = CompactHashing.remove(entry.getKey(), entry.getValue(), mask, CompactHashMap.this.requireTable(), CompactHashMap.this.requireEntries(), CompactHashMap.this.requireKeys(), CompactHashMap.this.requireValues());
                if (index == -1) {
                    return false;
                }
                CompactHashMap.this.moveLastEntry(index, mask);
                CompactHashMap.this.size--;
                CompactHashMap.this.incrementModCount();
                return true;
            }
            return false;
        }

        private /* synthetic */ Map.Entry lambda$spliterator$0(int x$0) {
            return new MapEntry(x$0);
        }
    }

    class KeySetView
    extends Maps.KeySet<K, V> {
        KeySetView() {
            super(CompactHashMap.this);
        }

        public @Nullable Object[] toArray() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return new Object[0];
            }
            Map delegate = CompactHashMap.this.delegateOrNull();
            return delegate != null ? delegate.keySet().toArray() : ObjectArrays.copyAsObjectArray(CompactHashMap.this.requireKeys(), 0, CompactHashMap.this.size);
        }

        public <T extends Object> T[] toArray(T[] a) {
            if (CompactHashMap.this.needsAllocArrays()) {
                if (a.length > 0) {
                    @Nullable T[] unsoundlyCovariantArray = a;
                    unsoundlyCovariantArray[0] = null;
                }
                return a;
            }
            Map delegate = CompactHashMap.this.delegateOrNull();
            return delegate != null ? delegate.keySet().toArray(a) : ObjectArrays.toArrayImpl((Object[])CompactHashMap.this.requireKeys(), (int)0, (int)CompactHashMap.this.size, a);
        }

        @Override
        public boolean remove(@CheckForNull Object o) {
            Map delegate = CompactHashMap.this.delegateOrNull();
            return delegate != null ? delegate.keySet().remove(o) : CompactHashMap.this.removeHelper(o) != NOT_FOUND;
        }

        @Override
        public Iterator<K> iterator() {
            return CompactHashMap.this.keySetIterator();
        }

        public Spliterator<K> spliterator() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return Spliterators.spliterator((Object[])new Object[0], (int)17);
            }
            Map delegate = CompactHashMap.this.delegateOrNull();
            return delegate != null ? delegate.keySet().spliterator() : Spliterators.spliterator((Object[])CompactHashMap.this.requireKeys(), (int)0, (int)CompactHashMap.this.size, (int)17);
        }

        @Override
        public void forEach(Consumer<? super K> action) {
            Preconditions.checkNotNull(action);
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                delegate.keySet().forEach(action);
            } else {
                int i = CompactHashMap.this.firstEntryIndex();
                while (i >= 0) {
                    action.accept(CompactHashMap.this.key(i));
                    i = CompactHashMap.this.getSuccessor(i);
                }
            }
        }
    }

    private abstract class Itr<T extends @Nullable Object>
    extends Object
    implements Iterator<T> {
        int expectedMetadata;
        int currentIndex;
        int indexToRemove;

        private Itr() {
            this.expectedMetadata = CompactHashMap.this.metadata;
            this.currentIndex = CompactHashMap.this.firstEntryIndex();
            this.indexToRemove = -1;
        }

        public boolean hasNext() {
            return this.currentIndex >= 0;
        }

        @ParametricNullness
        abstract T getOutput(int var1);

        @ParametricNullness
        public T next() {
            this.checkForConcurrentModification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.indexToRemove = this.currentIndex;
            T result = this.getOutput(this.currentIndex);
            this.currentIndex = CompactHashMap.this.getSuccessor(this.currentIndex);
            return result;
        }

        public void remove() {
            this.checkForConcurrentModification();
            CollectPreconditions.checkRemove(this.indexToRemove >= 0);
            this.incrementExpectedModCount();
            CompactHashMap.this.remove(CompactHashMap.this.key(this.indexToRemove));
            this.currentIndex = CompactHashMap.this.adjustAfterRemove(this.currentIndex, this.indexToRemove);
            this.indexToRemove = -1;
        }

        void incrementExpectedModCount() {
            this.expectedMetadata += 32;
        }

        private void checkForConcurrentModification() {
            if (CompactHashMap.this.metadata != this.expectedMetadata) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

