/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.collect;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.AbstractIterator;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.AbstractMultiset;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.CollectPreconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Collections2;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ForwardingIterator;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ForwardingSet;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Iterables;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Iterators;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Lists;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Multiset;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Multisets;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Serialization;
import org.rascalmpl.org.rascalmpl.com.google.common.math.IntMath;
import org.rascalmpl.org.rascalmpl.com.google.common.primitives.Ints;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.io.ObjectInputStream;
import org.rascalmpl.org.rascalmpl.java.io.ObjectOutputStream;
import org.rascalmpl.org.rascalmpl.java.io.Serializable;
import org.rascalmpl.org.rascalmpl.java.lang.ArithmeticException;
import org.rascalmpl.org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.org.rascalmpl.java.lang.Math;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.Iterator;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.Objects;
import org.rascalmpl.org.rascalmpl.java.util.Set;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ConcurrentHashMap;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ConcurrentMap;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.atomic.AtomicInteger;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class ConcurrentHashMultiset<E extends Object>
extends AbstractMultiset<E>
implements Serializable {
    private final transient ConcurrentMap<E, AtomicInteger> countMap;
    private static final long serialVersionUID = 1L;

    public static <E extends Object> ConcurrentHashMultiset<E> create() {
        return new ConcurrentHashMultiset<E>(new ConcurrentHashMap());
    }

    public static <E extends Object> ConcurrentHashMultiset<E> create(Iterable<? extends E> elements) {
        ConcurrentHashMultiset<E> multiset = ConcurrentHashMultiset.create();
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    public static <E extends Object> ConcurrentHashMultiset<E> create(ConcurrentMap<E, AtomicInteger> countMap) {
        return new ConcurrentHashMultiset<E>(countMap);
    }

    @VisibleForTesting
    ConcurrentHashMultiset(ConcurrentMap<E, AtomicInteger> countMap) {
        Preconditions.checkArgument(countMap.isEmpty(), (String)"org.rascalmpl.org.rascalmpl.the backing map (%s) must be empty", countMap);
        this.countMap = countMap;
    }

    @Override
    public int count(@CheckForNull Object element) {
        AtomicInteger existingCounter = Maps.safeGet(this.countMap, element);
        return existingCounter == null ? 0 : existingCounter.get();
    }

    @Override
    public int size() {
        long sum = 0L;
        for (AtomicInteger value : this.countMap.values()) {
            sum += (long)value.get();
        }
        return Ints.saturatedCast(sum);
    }

    public Object[] toArray() {
        return this.snapshot().toArray();
    }

    public <T extends Object> T[] toArray(T[] array) {
        return this.snapshot().toArray(array);
    }

    private List<E> snapshot() {
        ArrayList list = Lists.newArrayListWithExpectedSize(this.size());
        for (Multiset.Entry entry : this.entrySet()) {
            java.lang.Object element = entry.getElement();
            for (int i = entry.getCount(); i > 0; --i) {
                list.add(element);
            }
        }
        return list;
    }

    @Override
    @CanIgnoreReturnValue
    public int add(E element, int occurrences) {
        AtomicInteger existingCounter;
        AtomicInteger newCounter;
        Preconditions.checkNotNull(element);
        if (occurrences == 0) {
            return this.count((Object)element);
        }
        CollectPreconditions.checkPositive(occurrences, (String)"org.rascalmpl.org.rascalmpl.occurrences");
        do {
            int oldValue;
            if ((existingCounter = Maps.safeGet(this.countMap, element)) == null && (existingCounter = (AtomicInteger)this.countMap.putIfAbsent(element, (Object)new AtomicInteger(occurrences))) == null) {
                return 0;
            }
            while ((oldValue = existingCounter.get()) != 0) {
                try {
                    int newValue = IntMath.checkedAdd(oldValue, occurrences);
                    if (!existingCounter.compareAndSet(oldValue, newValue)) continue;
                    return oldValue;
                }
                catch (ArithmeticException overflow) {
                    throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Overflow adding ").append(occurrences).append((String)"org.rascalmpl.org.rascalmpl. occurrences to a count of ").append(oldValue).toString());
                }
            }
        } while (this.countMap.putIfAbsent(element, (Object)(newCounter = new AtomicInteger(occurrences))) != null && !this.countMap.replace(element, (Object)existingCounter, (Object)newCounter));
        return 0;
    }

    @Override
    @CanIgnoreReturnValue
    public int remove(@CheckForNull Object element, int occurrences) {
        int oldValue;
        if (occurrences == 0) {
            return this.count(element);
        }
        CollectPreconditions.checkPositive(occurrences, (String)"org.rascalmpl.org.rascalmpl.occurrences");
        AtomicInteger existingCounter = Maps.safeGet(this.countMap, element);
        if (existingCounter == null) {
            return 0;
        }
        while ((oldValue = existingCounter.get()) != 0) {
            int newValue = Math.max((int)0, (int)(oldValue - occurrences));
            if (!existingCounter.compareAndSet(oldValue, newValue)) continue;
            if (newValue == 0) {
                this.countMap.remove(element, (Object)existingCounter);
            }
            return oldValue;
        }
        return 0;
    }

    @CanIgnoreReturnValue
    public boolean removeExactly(@CheckForNull Object element, int occurrences) {
        int newValue;
        int oldValue;
        if (occurrences == 0) {
            return true;
        }
        CollectPreconditions.checkPositive(occurrences, (String)"org.rascalmpl.org.rascalmpl.occurrences");
        AtomicInteger existingCounter = Maps.safeGet(this.countMap, element);
        if (existingCounter == null) {
            return false;
        }
        do {
            if ((oldValue = existingCounter.get()) >= occurrences) continue;
            return false;
        } while (!existingCounter.compareAndSet(oldValue, newValue = oldValue - occurrences));
        if (newValue == 0) {
            this.countMap.remove(element, (Object)existingCounter);
        }
        return true;
    }

    @Override
    @CanIgnoreReturnValue
    public int setCount(E element, int count) {
        int oldValue;
        AtomicInteger existingCounter;
        Preconditions.checkNotNull(element);
        CollectPreconditions.checkNonnegative(count, (String)"org.rascalmpl.org.rascalmpl.count");
        block0: while (true) {
            if ((existingCounter = Maps.safeGet(this.countMap, element)) == null) {
                if (count == 0) {
                    return 0;
                }
                existingCounter = (AtomicInteger)this.countMap.putIfAbsent(element, (Object)new AtomicInteger(count));
                if (existingCounter == null) {
                    return 0;
                }
            }
            do {
                if ((oldValue = existingCounter.get()) != 0) continue;
                if (count == 0) {
                    return 0;
                }
                AtomicInteger newCounter = new AtomicInteger(count);
                if (this.countMap.putIfAbsent(element, (Object)newCounter) != null && !this.countMap.replace(element, (Object)existingCounter, (Object)newCounter)) continue block0;
                return 0;
            } while (!existingCounter.compareAndSet(oldValue, count));
            break;
        }
        if (count == 0) {
            this.countMap.remove(element, (Object)existingCounter);
        }
        return oldValue;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean setCount(E element, int expectedOldCount, int newCount) {
        Preconditions.checkNotNull(element);
        CollectPreconditions.checkNonnegative(expectedOldCount, (String)"org.rascalmpl.org.rascalmpl.oldCount");
        CollectPreconditions.checkNonnegative(newCount, (String)"org.rascalmpl.org.rascalmpl.newCount");
        AtomicInteger existingCounter = Maps.safeGet(this.countMap, element);
        if (existingCounter == null) {
            if (expectedOldCount != 0) {
                return false;
            }
            if (newCount == 0) {
                return true;
            }
            return this.countMap.putIfAbsent(element, (Object)new AtomicInteger(newCount)) == null;
        }
        int oldValue = existingCounter.get();
        if (oldValue == expectedOldCount) {
            if (oldValue == 0) {
                if (newCount == 0) {
                    this.countMap.remove(element, (Object)existingCounter);
                    return true;
                }
                AtomicInteger newCounter = new AtomicInteger(newCount);
                return this.countMap.putIfAbsent(element, (Object)newCounter) == null || this.countMap.replace(element, (Object)existingCounter, (Object)newCounter);
            }
            if (existingCounter.compareAndSet(oldValue, newCount)) {
                if (newCount == 0) {
                    this.countMap.remove(element, (Object)existingCounter);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    Set<E> createElementSet() {
        final Set delegate = this.countMap.keySet();
        return new ForwardingSet<E>(){

            @Override
            protected Set<E> delegate() {
                return delegate;
            }

            @Override
            public boolean contains(@CheckForNull Object object) {
                return object != null && Collections2.safeContains(delegate, object);
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                return this.standardContainsAll(collection);
            }

            @Override
            public boolean remove(@CheckForNull Object object) {
                return object != null && Collections2.safeRemove(delegate, object);
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                return this.standardRemoveAll(c);
            }
        };
    }

    @Override
    Iterator<E> elementIterator() {
        throw new AssertionError((Object)"org.rascalmpl.org.rascalmpl.should never be called");
    }

    @Override
    @Deprecated
    public Set<Multiset.Entry<E>> createEntrySet() {
        return new EntrySet();
    }

    @Override
    int distinctElements() {
        return this.countMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.countMap.isEmpty();
    }

    @Override
    Iterator<Multiset.Entry<E>> entryIterator() {
        final AbstractIterator readOnlyIterator = new AbstractIterator<Multiset.Entry<E>>(){
            private final Iterator<Map.Entry<E, AtomicInteger>> mapEntries;
            {
                this.mapEntries = ConcurrentHashMultiset.this.countMap.entrySet().iterator();
            }

            @Override
            @CheckForNull
            protected Multiset.Entry<E> computeNext() {
                Map.Entry mapEntry;
                int count;
                do {
                    if (this.mapEntries.hasNext()) continue;
                    return (Multiset.Entry)((java.lang.Object)this.endOfData());
                } while ((count = ((AtomicInteger)(mapEntry = (Map.Entry)this.mapEntries.next()).getValue()).get()) == 0);
                return Multisets.immutableEntry(mapEntry.getKey(), count);
            }
        };
        return new ForwardingIterator<Multiset.Entry<E>>(){
            @CheckForNull
            private Multiset.Entry<E> last;

            @Override
            protected Iterator<Multiset.Entry<E>> delegate() {
                return readOnlyIterator;
            }

            @Override
            public Multiset.Entry<E> next() {
                this.last = (Multiset.Entry)((java.lang.Object)super.next());
                return this.last;
            }

            @Override
            public void remove() {
                Preconditions.checkState(this.last != null, (Object)"org.rascalmpl.org.rascalmpl.no calls to next() since the last call to remove()");
                ConcurrentHashMultiset.this.setCount(this.last.getElement(), 0);
                this.last = null;
            }
        };
    }

    @Override
    public Iterator<E> iterator() {
        return Multisets.iteratorImpl(this);
    }

    @Override
    public void clear() {
        this.countMap.clear();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.countMap);
    }

    @J2ktIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        ConcurrentMap deserializedCountMap = (ConcurrentMap)Objects.requireNonNull((Object)stream.readObject());
        FieldSettersHolder.COUNT_MAP_FIELD_SETTER.set(this, (Object)deserializedCountMap);
    }

    private class EntrySet
    extends AbstractMultiset.EntrySet {
        private EntrySet() {
        }

        @Override
        ConcurrentHashMultiset<E> multiset() {
            return ConcurrentHashMultiset.this;
        }

        public Object[] toArray() {
            return this.snapshot().toArray();
        }

        public <T extends Object> T[] toArray(T[] array) {
            return this.snapshot().toArray(array);
        }

        private List<Multiset.Entry<E>> snapshot() {
            ArrayList list = Lists.newArrayListWithExpectedSize(this.size());
            Iterators.addAll(list, this.iterator());
            return list;
        }
    }

    private static class FieldSettersHolder
    extends Object {
        static final Serialization.FieldSetter<? super ConcurrentHashMultiset<?>> COUNT_MAP_FIELD_SETTER = Serialization.getFieldSetter(ConcurrentHashMultiset.class, (String)"org.rascalmpl.org.rascalmpl.countMap");

        private FieldSettersHolder() {
        }
    }
}

