/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.collect;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableMap;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Ordering;
import org.rascalmpl.org.rascalmpl.java.io.Serializable;
import org.rascalmpl.org.rascalmpl.java.lang.Integer;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class ExplicitOrdering<T extends Object>
extends Ordering<T>
implements Serializable {
    final ImmutableMap<T, Integer> rankMap;
    private static final long serialVersionUID = 0L;

    ExplicitOrdering(List<T> valuesInOrder) {
        this(Maps.indexMap(valuesInOrder));
    }

    ExplicitOrdering(ImmutableMap<T, Integer> rankMap) {
        this.rankMap = rankMap;
    }

    @Override
    public int compare(T left, T right) {
        return this.rank(left) - this.rank(right);
    }

    private int rank(T value) {
        Integer rank = this.rankMap.get((Object)value);
        if (rank == null) {
            throw new Ordering.IncomparableValueException((Object)value);
        }
        return rank.intValue();
    }

    public boolean equals(@CheckForNull Object object) {
        if (object instanceof ExplicitOrdering) {
            ExplicitOrdering that = (ExplicitOrdering)object;
            return this.rankMap.equals(that.rankMap);
        }
        return false;
    }

    public int hashCode() {
        return this.rankMap.hashCode();
    }

    public String toString() {
        return new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Ordering.explicit(").append((Object)this.rankMap.keySet()).append((String)"org.rascalmpl.org.rascalmpl.)").toString();
    }
}

