/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.collect;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Objects;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ForwardingObject;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Iterators;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ParametricNullness;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Sets;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.Iterator;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.Set;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingMap<K extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object>
extends ForwardingObject
implements Map<K, V> {
    protected ForwardingMap() {
    }

    protected abstract Map<K, V> delegate();

    public int size() {
        return this.delegate().size();
    }

    public boolean isEmpty() {
        return this.delegate().isEmpty();
    }

    @CheckForNull
    @CanIgnoreReturnValue
    public V remove(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object key) {
        return (V)this.delegate().remove(key);
    }

    public void clear() {
        this.delegate().clear();
    }

    public boolean containsKey(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object key) {
        return this.delegate().containsKey(key);
    }

    public boolean containsValue(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object value) {
        return this.delegate().containsValue(value);
    }

    @CheckForNull
    public V get(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object key) {
        return (V)this.delegate().get(key);
    }

    @CheckForNull
    @CanIgnoreReturnValue
    public V put(@ParametricNullness K key, @ParametricNullness V value) {
        return (V)this.delegate().put(key, value);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.delegate().putAll(map);
    }

    public Set<K> keySet() {
        return this.delegate().keySet();
    }

    public Collection<V> values() {
        return this.delegate().values();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate().entrySet();
    }

    public boolean equals(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object object) {
        return object == this || this.delegate().equals(object);
    }

    public int hashCode() {
        return this.delegate().hashCode();
    }

    protected void standardPutAll(Map<? extends K, ? extends V> map) {
        Maps.putAllImpl(this, map);
    }

    @CheckForNull
    protected V standardRemove(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object key) {
        Iterator entryIterator = this.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = (Map.Entry)entryIterator.next();
            if (!Objects.equal(entry.getKey(), key)) continue;
            org.rascalmpl.org.rascalmpl.java.lang.Object value = entry.getValue();
            entryIterator.remove();
            return (V)value;
        }
        return null;
    }

    protected void standardClear() {
        Iterators.clear(this.entrySet().iterator());
    }

    protected boolean standardContainsKey(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object key) {
        return Maps.containsKeyImpl(this, key);
    }

    protected boolean standardContainsValue(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object value) {
        return Maps.containsValueImpl(this, value);
    }

    protected boolean standardIsEmpty() {
        return !this.entrySet().iterator().hasNext();
    }

    protected boolean standardEquals(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object object) {
        return Maps.equalsImpl(this, object);
    }

    protected int standardHashCode() {
        return Sets.hashCodeImpl(this.entrySet());
    }

    protected String standardToString() {
        return Maps.toStringImpl(this);
    }

    protected abstract class StandardEntrySet
    extends Maps.EntrySet<K, V> {
        protected StandardEntrySet() {
        }

        @Override
        Map<K, V> map() {
            return ForwardingMap.this;
        }
    }

    protected class StandardValues
    extends Maps.Values<K, V> {
        public StandardValues() {
            super(ForwardingMap.this);
        }
    }

    protected class StandardKeySet
    extends Maps.KeySet<K, V> {
        public StandardKeySet() {
            super(ForwardingMap.this);
        }
    }
}

