/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.collect;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Supplier;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.CollectPreconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.StandardTable;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Table;
import org.rascalmpl.org.rascalmpl.java.io.Serializable;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.util.LinkedHashMap;
import org.rascalmpl.org.rascalmpl.java.util.Map;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
public class HashBasedTable<R extends Object, C extends Object, V extends Object>
extends StandardTable<R, C, V> {
    private static final long serialVersionUID = 0L;

    public static <R extends Object, C extends Object, V extends Object> HashBasedTable<R, C, V> create() {
        return new HashBasedTable(new LinkedHashMap(), new Factory(0));
    }

    public static <R extends Object, C extends Object, V extends Object> HashBasedTable<R, C, V> create(int expectedRows, int expectedCellsPerRow) {
        CollectPreconditions.checkNonnegative(expectedCellsPerRow, (String)"org.rascalmpl.org.rascalmpl.expectedCellsPerRow");
        LinkedHashMap backingMap = Maps.newLinkedHashMapWithExpectedSize(expectedRows);
        return new HashBasedTable(backingMap, new Factory(expectedCellsPerRow));
    }

    public static <R extends Object, C extends Object, V extends Object> HashBasedTable<R, C, V> create(Table<? extends R, ? extends C, ? extends V> table) {
        HashBasedTable<R, C, V> result = HashBasedTable.create();
        result.putAll((Table)table);
        return result;
    }

    HashBasedTable(Map<R, Map<C, V>> backingMap, Factory<C, V> factory) {
        super(backingMap, factory);
    }

    private static class Factory<C extends Object, V extends Object>
    extends Object
    implements Supplier<Map<C, V>>,
    Serializable {
        final int expectedSize;
        private static final long serialVersionUID = 0L;

        Factory(int expectedSize) {
            this.expectedSize = expectedSize;
        }

        @Override
        public Map<C, V> get() {
            return Maps.newLinkedHashMapWithExpectedSize(this.expectedSize);
        }
    }
}

