/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.collect;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.AbstractMapBasedMultiset;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Iterables;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Multisets;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Serialization;
import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.io.ObjectInputStream;
import org.rascalmpl.org.rascalmpl.java.io.ObjectOutputStream;
import org.rascalmpl.org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.util.HashMap;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public final class HashMultiset<E extends @Nullable Object>
extends AbstractMapBasedMultiset<E> {
    @GwtIncompatible
    @J2ktIncompatible
    private static final long serialVersionUID = 0L;

    public static <E extends Object> HashMultiset<E> create() {
        return new HashMultiset<E>();
    }

    public static <E extends Object> HashMultiset<E> create(int distinctElements) {
        return new HashMultiset<E>(distinctElements);
    }

    public static <E extends Object> HashMultiset<E> create(Iterable<? extends E> elements) {
        HashMultiset<E> multiset = HashMultiset.create(Multisets.inferDistinctElements(elements));
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    private HashMultiset() {
        super(new HashMap());
    }

    private HashMultiset(int distinctElements) {
        super(Maps.newHashMapWithExpectedSize(distinctElements));
    }

    @GwtIncompatible
    @J2ktIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Serialization.writeMultiset(this, stream);
    }

    @GwtIncompatible
    @J2ktIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int distinctElements = Serialization.readCount(stream);
        this.setBackingMap(Maps.newHashMap());
        Serialization.populateMultiset(this, stream, distinctElements);
    }
}

