/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.collect;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.AbstractMapEntry;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.CollectCollectors;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.CollectPreconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableBiMap;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableCollection;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableEnumMap;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableMapEntry;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableMapEntrySet;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableMapKeySet;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableMapValues;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableSet;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableSetMultimap;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Iterables;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.JdkBackedImmutableMap;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Ordering;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.RegularImmutableMap;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Sets;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.UnmodifiableIterator;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.DoNotCall;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.DoNotMock;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.concurrent.LazyInit;
import org.rascalmpl.org.rascalmpl.com.google.j2objc.annotations.RetainedWith;
import org.rascalmpl.org.rascalmpl.java.io.InvalidObjectException;
import org.rascalmpl.org.rascalmpl.java.io.ObjectInputStream;
import org.rascalmpl.org.rascalmpl.java.io.Serializable;
import org.rascalmpl.org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.org.rascalmpl.java.lang.Enum;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.SafeVarargs;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.org.rascalmpl.java.util.Arrays;
import org.rascalmpl.org.rascalmpl.java.util.BitSet;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.Comparator;
import org.rascalmpl.org.rascalmpl.java.util.EnumMap;
import org.rascalmpl.org.rascalmpl.java.util.HashSet;
import org.rascalmpl.org.rascalmpl.java.util.Iterator;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.Objects;
import org.rascalmpl.org.rascalmpl.java.util.SortedMap;
import org.rascalmpl.org.rascalmpl.java.util.Spliterator;
import org.rascalmpl.org.rascalmpl.java.util.Spliterators;
import org.rascalmpl.org.rascalmpl.java.util.function.BiFunction;
import org.rascalmpl.org.rascalmpl.java.util.function.BinaryOperator;
import org.rascalmpl.org.rascalmpl.java.util.function.Function;
import org.rascalmpl.org.rascalmpl.java.util.stream.Collector;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@DoNotMock(value="org.rascalmpl.org.rascalmpl.Use ImmutableMap.of or another implementation")
@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableMap<K extends Object, V extends Object>
extends Object
implements Map<K, V>,
Serializable {
    static final Map.Entry<?, ?>[] EMPTY_ENTRY_ARRAY = new Map.Entry[0];
    @LazyInit
    @CheckForNull
    @RetainedWith
    private transient ImmutableSet<Map.Entry<K, V>> entrySet;
    @LazyInit
    @CheckForNull
    @RetainedWith
    private transient ImmutableSet<K> keySet;
    @LazyInit
    @CheckForNull
    @RetainedWith
    private transient ImmutableCollection<V> values;
    @LazyInit
    @CheckForNull
    private transient ImmutableSetMultimap<K, V> multimapView;
    private static final long serialVersionUID = -889275714L;

    public static <T extends Object, K extends Object, V extends Object> Collector<T, ?, ImmutableMap<K, V>> toImmutableMap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        return CollectCollectors.toImmutableMap(keyFunction, valueFunction);
    }

    public static <T extends Object, K extends Object, V extends Object> Collector<T, ?, ImmutableMap<K, V>> toImmutableMap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction, BinaryOperator<V> mergeFunction) {
        return CollectCollectors.toImmutableMap(keyFunction, valueFunction, mergeFunction);
    }

    public static <K extends Object, V extends Object> ImmutableMap<K, V> of() {
        return RegularImmutableMap.EMPTY;
    }

    public static <K extends Object, V extends Object> ImmutableMap<K, V> of(K k1, V v1) {
        return ImmutableBiMap.of(k1, v1);
    }

    public static <K extends Object, V extends Object> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2) {
        return RegularImmutableMap.fromEntries(ImmutableMap.entryOf(k1, v1), ImmutableMap.entryOf(k2, v2));
    }

    public static <K extends Object, V extends Object> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return RegularImmutableMap.fromEntries(ImmutableMap.entryOf(k1, v1), ImmutableMap.entryOf(k2, v2), ImmutableMap.entryOf(k3, v3));
    }

    public static <K extends Object, V extends Object> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return RegularImmutableMap.fromEntries(ImmutableMap.entryOf(k1, v1), ImmutableMap.entryOf(k2, v2), ImmutableMap.entryOf(k3, v3), ImmutableMap.entryOf(k4, v4));
    }

    public static <K extends Object, V extends Object> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return RegularImmutableMap.fromEntries(ImmutableMap.entryOf(k1, v1), ImmutableMap.entryOf(k2, v2), ImmutableMap.entryOf(k3, v3), ImmutableMap.entryOf(k4, v4), ImmutableMap.entryOf(k5, v5));
    }

    public static <K extends Object, V extends Object> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        return RegularImmutableMap.fromEntries(ImmutableMap.entryOf(k1, v1), ImmutableMap.entryOf(k2, v2), ImmutableMap.entryOf(k3, v3), ImmutableMap.entryOf(k4, v4), ImmutableMap.entryOf(k5, v5), ImmutableMap.entryOf(k6, v6));
    }

    public static <K extends Object, V extends Object> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        return RegularImmutableMap.fromEntries(ImmutableMap.entryOf(k1, v1), ImmutableMap.entryOf(k2, v2), ImmutableMap.entryOf(k3, v3), ImmutableMap.entryOf(k4, v4), ImmutableMap.entryOf(k5, v5), ImmutableMap.entryOf(k6, v6), ImmutableMap.entryOf(k7, v7));
    }

    public static <K extends Object, V extends Object> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        return RegularImmutableMap.fromEntries(ImmutableMap.entryOf(k1, v1), ImmutableMap.entryOf(k2, v2), ImmutableMap.entryOf(k3, v3), ImmutableMap.entryOf(k4, v4), ImmutableMap.entryOf(k5, v5), ImmutableMap.entryOf(k6, v6), ImmutableMap.entryOf(k7, v7), ImmutableMap.entryOf(k8, v8));
    }

    public static <K extends Object, V extends Object> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        return RegularImmutableMap.fromEntries(ImmutableMap.entryOf(k1, v1), ImmutableMap.entryOf(k2, v2), ImmutableMap.entryOf(k3, v3), ImmutableMap.entryOf(k4, v4), ImmutableMap.entryOf(k5, v5), ImmutableMap.entryOf(k6, v6), ImmutableMap.entryOf(k7, v7), ImmutableMap.entryOf(k8, v8), ImmutableMap.entryOf(k9, v9));
    }

    public static <K extends Object, V extends Object> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10) {
        return RegularImmutableMap.fromEntries(ImmutableMap.entryOf(k1, v1), ImmutableMap.entryOf(k2, v2), ImmutableMap.entryOf(k3, v3), ImmutableMap.entryOf(k4, v4), ImmutableMap.entryOf(k5, v5), ImmutableMap.entryOf(k6, v6), ImmutableMap.entryOf(k7, v7), ImmutableMap.entryOf(k8, v8), ImmutableMap.entryOf(k9, v9), ImmutableMap.entryOf(k10, v10));
    }

    @SafeVarargs
    public static <K extends Object, V extends Object> ImmutableMap<K, V> ofEntries(Map.Entry<? extends K, ? extends V> ... entries) {
        Map.Entry<? extends K, ? extends V>[] entries2 = entries;
        return RegularImmutableMap.fromEntries(entries2);
    }

    static <K extends Object, V extends Object> Map.Entry<K, V> entryOf(K key, V value) {
        return new ImmutableMapEntry<K, V>(key, value);
    }

    public static <K extends Object, V extends Object> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K extends Object, V extends Object> Builder<K, V> builderWithExpectedSize(int expectedSize) {
        CollectPreconditions.checkNonnegative(expectedSize, (String)"org.rascalmpl.org.rascalmpl.expectedSize");
        return new Builder(expectedSize);
    }

    static void checkNoConflict(boolean safe, String conflictDescription, Object entry1, Object entry2) {
        if (!safe) {
            throw ImmutableMap.conflictException(conflictDescription, entry1, entry2);
        }
    }

    static IllegalArgumentException conflictException(String conflictDescription, Object entry1, Object entry2) {
        return new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Multiple entries with same ").append(conflictDescription).append((String)"org.rascalmpl.org.rascalmpl.: ").append(entry1).append((String)"org.rascalmpl.org.rascalmpl. and ").append(entry2).toString());
    }

    public static <K extends Object, V extends Object> ImmutableMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        if (map instanceof ImmutableMap && !(map instanceof SortedMap)) {
            ImmutableMap kvMap = (ImmutableMap)map;
            if (!kvMap.isPartialView()) {
                return kvMap;
            }
        } else if (map instanceof EnumMap) {
            ImmutableMap<K, V> kvMap = ImmutableMap.copyOfEnumMap((EnumMap)map);
            return kvMap;
        }
        return ImmutableMap.copyOf(map.entrySet());
    }

    public static <K extends Object, V extends Object> ImmutableMap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
        Map.Entry[] entryArray = (Map.Entry[])Iterables.toArray(entries, EMPTY_ENTRY_ARRAY);
        switch (entryArray.length) {
            case 0: {
                return ImmutableMap.of();
            }
            case 1: {
                Map.Entry onlyEntry = (Map.Entry)Objects.requireNonNull((Object)entryArray[0]);
                return ImmutableMap.of(onlyEntry.getKey(), onlyEntry.getValue());
            }
        }
        return RegularImmutableMap.fromEntries(entryArray);
    }

    private static <K extends Enum<K>, V extends Object> ImmutableMap<K, ? extends V> copyOfEnumMap(EnumMap<?, ? extends V> original) {
        EnumMap copy = new EnumMap(original);
        for (Map.Entry entry : copy.entrySet()) {
            CollectPreconditions.checkEntryNotNull(entry.getKey(), entry.getValue());
        }
        return ImmutableEnumMap.asImmutable(copy);
    }

    ImmutableMap() {
    }

    @Deprecated
    @CheckForNull
    @CanIgnoreReturnValue
    @DoNotCall(value="org.rascalmpl.org.rascalmpl.Always throws UnsupportedOperationException")
    public final V put(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @CheckForNull
    @CanIgnoreReturnValue
    @DoNotCall(value="org.rascalmpl.org.rascalmpl.Always throws UnsupportedOperationException")
    public final V putIfAbsent(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="org.rascalmpl.org.rascalmpl.Always throws UnsupportedOperationException")
    public final boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @CheckForNull
    @DoNotCall(value="org.rascalmpl.org.rascalmpl.Always throws UnsupportedOperationException")
    public final V replace(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="org.rascalmpl.org.rascalmpl.Always throws UnsupportedOperationException")
    public final V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @CheckForNull
    @DoNotCall(value="org.rascalmpl.org.rascalmpl.Always throws UnsupportedOperationException")
    public final V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends @Nullable V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @CheckForNull
    @DoNotCall(value="org.rascalmpl.org.rascalmpl.Always throws UnsupportedOperationException")
    public final V compute(K key, BiFunction<? super K, ? super @Nullable V, ? extends @Nullable V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @CheckForNull
    @DoNotCall(value="org.rascalmpl.org.rascalmpl.Always throws UnsupportedOperationException")
    public final V merge(K key, V value, BiFunction<? super V, ? super V, ? extends @Nullable V> function) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="org.rascalmpl.org.rascalmpl.Always throws UnsupportedOperationException")
    public final void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="org.rascalmpl.org.rascalmpl.Always throws UnsupportedOperationException")
    public final void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @CheckForNull
    @DoNotCall(value="org.rascalmpl.org.rascalmpl.Always throws UnsupportedOperationException")
    public final V remove(@CheckForNull Object o) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="org.rascalmpl.org.rascalmpl.Always throws UnsupportedOperationException")
    public final boolean remove(@CheckForNull Object key, @CheckForNull Object value) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="org.rascalmpl.org.rascalmpl.Always throws UnsupportedOperationException")
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(@CheckForNull Object key) {
        return this.get(key) != null;
    }

    public boolean containsValue(@CheckForNull Object value) {
        return this.values().contains(value);
    }

    @CheckForNull
    public abstract V get(@CheckForNull Object var1);

    @CheckForNull
    public final V getOrDefault(@CheckForNull Object key, @CheckForNull V defaultValue) {
        V result = this.get(key);
        if (result != null) {
            return result;
        }
        return defaultValue;
    }

    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        ImmutableSet<Map.Entry<K, V>> result = this.entrySet;
        return result == null ? (this.entrySet = this.createEntrySet()) : result;
    }

    abstract ImmutableSet<Map.Entry<K, V>> createEntrySet();

    public ImmutableSet<K> keySet() {
        ImmutableSet<K> result = this.keySet;
        return result == null ? (this.keySet = this.createKeySet()) : result;
    }

    abstract ImmutableSet<K> createKeySet();

    UnmodifiableIterator<K> keyIterator() {
        Iterator entryIterator = this.entrySet().iterator();
        return new UnmodifiableIterator<K>((UnmodifiableIterator)entryIterator){
            final /* synthetic */ UnmodifiableIterator val$entryIterator;
            {
                this.val$entryIterator = unmodifiableIterator;
            }

            public boolean hasNext() {
                return this.val$entryIterator.hasNext();
            }

            public K next() {
                return ((Map.Entry)this.val$entryIterator.next()).getKey();
            }
        };
    }

    /*
     * Exception decompiling
     */
    Spliterator<K> keySpliterator() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/org/rascalmpl/java/lang/Object;)Lorg/rascalmpl/org/rascalmpl/java/lang/Object;
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ImmutableCollection<V> values() {
        ImmutableCollection<V> result = this.values;
        return result == null ? (this.values = this.createValues()) : result;
    }

    abstract ImmutableCollection<V> createValues();

    public ImmutableSetMultimap<K, V> asMultimap() {
        if (this.isEmpty()) {
            return ImmutableSetMultimap.of();
        }
        ImmutableSetMultimap<K, V> result = this.multimapView;
        return result == null ? (this.multimapView = new ImmutableSetMultimap(new MapViewOfValuesAsSingletonSets(), this.size(), null)) : result;
    }

    public boolean equals(@CheckForNull Object object) {
        return Maps.equalsImpl(this, object);
    }

    abstract boolean isPartialView();

    public int hashCode() {
        return Sets.hashCodeImpl(this.entrySet());
    }

    boolean isHashCodeFast() {
        return false;
    }

    public String toString() {
        return Maps.toStringImpl(this);
    }

    @J2ktIncompatible
    Object writeReplace() {
        return new SerializedForm(this);
    }

    @J2ktIncompatible
    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException((String)"org.rascalmpl.org.rascalmpl.Use SerializedForm");
    }

    @J2ktIncompatible
    static class SerializedForm<K extends Object, V extends Object>
    extends Object
    implements Serializable {
        private static final boolean USE_LEGACY_SERIALIZATION = true;
        private final Object keys;
        private final Object values;
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableMap<K, V> map) {
            Object[] keys = new Object[map.size()];
            Object[] values = new Object[map.size()];
            int i = 0;
            for (Map.Entry entry : map.entrySet()) {
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
            this.keys = keys;
            this.values = values;
        }

        final Object readResolve() {
            if (!(this.keys instanceof ImmutableSet)) {
                return this.legacyReadResolve();
            }
            ImmutableSet keySet = (ImmutableSet)this.keys;
            ImmutableCollection values = (ImmutableCollection)this.values;
            Builder<Object, Object> builder = this.makeBuilder(keySet.size());
            Iterator keyIter = keySet.iterator();
            Iterator valueIter = values.iterator();
            while (keyIter.hasNext()) {
                builder.put(keyIter.next(), valueIter.next());
            }
            return builder.buildOrThrow();
        }

        final Object legacyReadResolve() {
            Object[] keys = (Object[])this.keys;
            Object[] values = (Object[])this.values;
            Builder<Object, Object> builder = this.makeBuilder(keys.length);
            for (int i = 0; i < keys.length; ++i) {
                builder.put(keys[i], values[i]);
            }
            return builder.buildOrThrow();
        }

        Builder<K, V> makeBuilder(int size) {
            return new Builder(size);
        }
    }

    private final class MapViewOfValuesAsSingletonSets
    extends IteratorBasedImmutableMap<K, ImmutableSet<V>> {
        private MapViewOfValuesAsSingletonSets() {
        }

        public int size() {
            return ImmutableMap.this.size();
        }

        @Override
        ImmutableSet<K> createKeySet() {
            return ImmutableMap.this.keySet();
        }

        @Override
        public boolean containsKey(@CheckForNull Object key) {
            return ImmutableMap.this.containsKey(key);
        }

        @Override
        @CheckForNull
        public ImmutableSet<V> get(@CheckForNull Object key) {
            java.lang.Object outerValue = ImmutableMap.this.get(key);
            return outerValue == null ? null : ImmutableSet.of(outerValue);
        }

        @Override
        boolean isPartialView() {
            return ImmutableMap.this.isPartialView();
        }

        @Override
        public int hashCode() {
            return ImmutableMap.this.hashCode();
        }

        @Override
        boolean isHashCodeFast() {
            return ImmutableMap.this.isHashCodeFast();
        }

        @Override
        UnmodifiableIterator<Map.Entry<K, ImmutableSet<V>>> entryIterator() {
            final Iterator backingIterator = ImmutableMap.this.entrySet().iterator();
            return new UnmodifiableIterator<Map.Entry<K, ImmutableSet<V>>>(){

                public boolean hasNext() {
                    return backingIterator.hasNext();
                }

                public Map.Entry<K, ImmutableSet<V>> next() {
                    final Map.Entry backingEntry = (Map.Entry)backingIterator.next();
                    return new AbstractMapEntry<K, ImmutableSet<V>>(){

                        @Override
                        public K getKey() {
                            return backingEntry.getKey();
                        }

                        @Override
                        public ImmutableSet<V> getValue() {
                            return ImmutableSet.of(backingEntry.getValue());
                        }
                    };
                }
            };
        }

        @Override
        @J2ktIncompatible
        @GwtIncompatible
        Object writeReplace() {
            return super.writeReplace();
        }
    }

    static abstract class IteratorBasedImmutableMap<K extends Object, V extends Object>
    extends ImmutableMap<K, V> {
        IteratorBasedImmutableMap() {
        }

        abstract UnmodifiableIterator<Map.Entry<K, V>> entryIterator();

        Spliterator<Map.Entry<K, V>> entrySpliterator() {
            return Spliterators.spliterator(this.entryIterator(), (long)this.size(), (int)1297);
        }

        @Override
        ImmutableSet<K> createKeySet() {
            return new ImmutableMapKeySet(this);
        }

        @Override
        ImmutableSet<Map.Entry<K, V>> createEntrySet() {
            class EntrySetImpl
            extends ImmutableMapEntrySet<K, V> {
                EntrySetImpl() {
                }

                @Override
                ImmutableMap<K, V> map() {
                    return IteratorBasedImmutableMap.this;
                }

                @Override
                public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
                    return IteratorBasedImmutableMap.this.entryIterator();
                }

                @Override
                @J2ktIncompatible
                @GwtIncompatible
                Object writeReplace() {
                    return super.writeReplace();
                }
            }
            return new EntrySetImpl();
        }

        @Override
        ImmutableCollection<V> createValues() {
            return new ImmutableMapValues(this);
        }

        @Override
        @J2ktIncompatible
        @GwtIncompatible
        Object writeReplace() {
            return super.writeReplace();
        }
    }

    @DoNotMock
    public static class Builder<K extends Object, V extends Object>
    extends Object {
        @CheckForNull
        Comparator<? super V> valueComparator;
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable Map.Entry<K, V>[] entries;
        int size;
        boolean entriesUsed;

        public Builder() {
            this(4);
        }

        Builder(int initialCapacity) {
            this.entries = new Map.Entry[initialCapacity];
            this.size = 0;
            this.entriesUsed = false;
        }

        private void ensureCapacity(int minCapacity) {
            if (minCapacity > this.entries.length) {
                this.entries = (Map.Entry[])Arrays.copyOf(this.entries, (int)ImmutableCollection.Builder.expandedCapacity(this.entries.length, minCapacity));
                this.entriesUsed = false;
            }
        }

        @CanIgnoreReturnValue
        public Builder<K, V> put(K key, V value) {
            this.ensureCapacity(this.size + 1);
            Map.Entry<K, V> entry = ImmutableMap.entryOf(key, value);
            this.entries[this.size++] = entry;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            return this.put(entry.getKey(), entry.getValue());
        }

        @CanIgnoreReturnValue
        public Builder<K, V> putAll(Map<? extends K, ? extends V> map) {
            return this.putAll((Iterable<? extends Map.Entry<? extends K, ? extends V>>)map.entrySet());
        }

        @CanIgnoreReturnValue
        public Builder<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
            if (entries instanceof Collection) {
                this.ensureCapacity(this.size + ((Collection)entries).size());
            }
            for (Map.Entry entry : entries) {
                this.put(entry);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<K, V> orderEntriesByValue(Comparator<? super V> valueComparator) {
            Preconditions.checkState(this.valueComparator == null, (Object)"org.rascalmpl.org.rascalmpl.valueComparator was already set");
            this.valueComparator = Preconditions.checkNotNull(valueComparator, (Object)"org.rascalmpl.org.rascalmpl.valueComparator");
            return this;
        }

        @CanIgnoreReturnValue
        Builder<K, V> combine(Builder<K, V> other) {
            Preconditions.checkNotNull(other);
            this.ensureCapacity(this.size + other.size);
            System.arraycopy(other.entries, (int)0, this.entries, (int)this.size, (int)other.size);
            this.size += other.size;
            return this;
        }

        private ImmutableMap<K, V> build(boolean throwIfDuplicateKeys) {
            Map.Entry<K, V>[] localEntries;
            switch (this.size) {
                case 0: {
                    return ImmutableMap.of();
                }
                case 1: {
                    Map.Entry onlyEntry = (Map.Entry)Objects.requireNonNull(this.entries[0]);
                    return ImmutableMap.of(onlyEntry.getKey(), onlyEntry.getValue());
                }
            }
            int localSize = this.size;
            if (this.valueComparator == null) {
                localEntries = this.entries;
            } else {
                Map.Entry<K, V>[] lastEntryForEachKey;
                if (this.entriesUsed) {
                    this.entries = (Map.Entry[])Arrays.copyOf(this.entries, (int)this.size);
                }
                Map.Entry<K, V>[] nonNullEntries = this.entries;
                if (!throwIfDuplicateKeys && (lastEntryForEachKey = Builder.lastEntryForEachKey(nonNullEntries, this.size)) != null) {
                    nonNullEntries = lastEntryForEachKey;
                    localSize = lastEntryForEachKey.length;
                }
                Arrays.sort(nonNullEntries, (int)0, (int)localSize, Ordering.from(this.valueComparator).onResultOf(Maps.valueFunction()));
                localEntries = nonNullEntries;
            }
            this.entriesUsed = true;
            return RegularImmutableMap.fromEntryArray(localSize, localEntries, throwIfDuplicateKeys);
        }

        public ImmutableMap<K, V> build() {
            return this.buildOrThrow();
        }

        public ImmutableMap<K, V> buildOrThrow() {
            return this.build(true);
        }

        public ImmutableMap<K, V> buildKeepingLast() {
            return this.build(false);
        }

        @VisibleForTesting
        ImmutableMap<K, V> buildJdkBacked() {
            Preconditions.checkState(this.valueComparator == null, (Object)"org.rascalmpl.org.rascalmpl.buildJdkBacked is only for testing; can't use valueComparator");
            switch (this.size) {
                case 0: {
                    return ImmutableMap.of();
                }
                case 1: {
                    Map.Entry onlyEntry = (Map.Entry)Objects.requireNonNull(this.entries[0]);
                    return ImmutableMap.of(onlyEntry.getKey(), onlyEntry.getValue());
                }
            }
            this.entriesUsed = true;
            return JdkBackedImmutableMap.create(this.size, this.entries, true);
        }

        @CheckForNull
        private static <K extends Object, V extends Object> Map.Entry<K, V>[] lastEntryForEachKey(Map.Entry<K, V>[] entries, int size) {
            HashSet seen = new HashSet();
            BitSet dups = new BitSet();
            for (int i = size - 1; i >= 0; --i) {
                if (seen.add(entries[i].getKey())) continue;
                dups.set(i);
            }
            if (dups.isEmpty()) {
                return null;
            }
            Map.Entry[] newEntries = new Map.Entry[size - dups.cardinality()];
            int outI = 0;
            for (int inI = 0; inI < size; ++inI) {
                if (dups.get(inI)) continue;
                newEntries[outI++] = entries[inI];
            }
            return newEntries;
        }
    }
}

