/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.collect;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.MoreObjects;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.AbstractTable;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableCollection;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableMap;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableSet;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Iterables;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Lists;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.RegularImmutableTable;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.SingletonImmutableTable;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.SparseImmutableTable;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Table;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.TableCollectors;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Tables;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.UnmodifiableIterator;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.DoNotCall;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.DoNotMock;
import org.rascalmpl.org.rascalmpl.java.io.InvalidObjectException;
import org.rascalmpl.org.rascalmpl.java.io.ObjectInputStream;
import org.rascalmpl.org.rascalmpl.java.io.Serializable;
import org.rascalmpl.org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.org.rascalmpl.java.util.Comparator;
import org.rascalmpl.org.rascalmpl.java.util.Iterator;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.Spliterator;
import org.rascalmpl.org.rascalmpl.java.util.function.BinaryOperator;
import org.rascalmpl.org.rascalmpl.java.util.function.Function;
import org.rascalmpl.org.rascalmpl.java.util.stream.Collector;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ImmutableTable<R extends org.rascalmpl.org.rascalmpl.java.lang.Object, C extends org.rascalmpl.org.rascalmpl.java.lang.Object, V extends org.rascalmpl.org.rascalmpl.java.lang.Object>
extends AbstractTable<R, C, V>
implements Serializable {
    private static final long serialVersionUID = -889275714L;

    public static <T extends org.rascalmpl.org.rascalmpl.java.lang.Object, R extends org.rascalmpl.org.rascalmpl.java.lang.Object, C extends org.rascalmpl.org.rascalmpl.java.lang.Object, V extends org.rascalmpl.org.rascalmpl.java.lang.Object> Collector<T, ?, ImmutableTable<R, C, V>> toImmutableTable(Function<? super T, ? extends R> rowFunction, Function<? super T, ? extends C> columnFunction, Function<? super T, ? extends V> valueFunction) {
        return TableCollectors.toImmutableTable(rowFunction, columnFunction, valueFunction);
    }

    public static <T extends org.rascalmpl.org.rascalmpl.java.lang.Object, R extends org.rascalmpl.org.rascalmpl.java.lang.Object, C extends org.rascalmpl.org.rascalmpl.java.lang.Object, V extends org.rascalmpl.org.rascalmpl.java.lang.Object> Collector<T, ?, ImmutableTable<R, C, V>> toImmutableTable(Function<? super T, ? extends R> rowFunction, Function<? super T, ? extends C> columnFunction, Function<? super T, ? extends V> valueFunction, BinaryOperator<V> mergeFunction) {
        return TableCollectors.toImmutableTable(rowFunction, columnFunction, valueFunction, mergeFunction);
    }

    public static <R extends org.rascalmpl.org.rascalmpl.java.lang.Object, C extends org.rascalmpl.org.rascalmpl.java.lang.Object, V extends org.rascalmpl.org.rascalmpl.java.lang.Object> ImmutableTable<R, C, V> of() {
        return SparseImmutableTable.EMPTY;
    }

    public static <R extends org.rascalmpl.org.rascalmpl.java.lang.Object, C extends org.rascalmpl.org.rascalmpl.java.lang.Object, V extends org.rascalmpl.org.rascalmpl.java.lang.Object> ImmutableTable<R, C, V> of(R rowKey, C columnKey, V value) {
        return new SingletonImmutableTable<R, C, V>(rowKey, columnKey, value);
    }

    public static <R extends org.rascalmpl.org.rascalmpl.java.lang.Object, C extends org.rascalmpl.org.rascalmpl.java.lang.Object, V extends org.rascalmpl.org.rascalmpl.java.lang.Object> ImmutableTable<R, C, V> copyOf(Table<? extends R, ? extends C, ? extends V> table) {
        if (table instanceof ImmutableTable) {
            ImmutableTable parameterizedTable = (ImmutableTable)table;
            return parameterizedTable;
        }
        return ImmutableTable.copyOf(table.cellSet());
    }

    static <R extends org.rascalmpl.org.rascalmpl.java.lang.Object, C extends org.rascalmpl.org.rascalmpl.java.lang.Object, V extends org.rascalmpl.org.rascalmpl.java.lang.Object> ImmutableTable<R, C, V> copyOf(Iterable<? extends Table.Cell<? extends R, ? extends C, ? extends V>> cells) {
        Builder<R, C, V> builder = ImmutableTable.builder();
        for (Table.Cell cell : cells) {
            builder.put(cell);
        }
        return builder.build();
    }

    public static <R extends org.rascalmpl.org.rascalmpl.java.lang.Object, C extends org.rascalmpl.org.rascalmpl.java.lang.Object, V extends org.rascalmpl.org.rascalmpl.java.lang.Object> Builder<R, C, V> builder() {
        return new Builder();
    }

    static <R extends org.rascalmpl.org.rascalmpl.java.lang.Object, C extends org.rascalmpl.org.rascalmpl.java.lang.Object, V extends org.rascalmpl.org.rascalmpl.java.lang.Object> Table.Cell<R, C, V> cellOf(R rowKey, C columnKey, V value) {
        return Tables.immutableCell(Preconditions.checkNotNull(rowKey, (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.rowKey"), Preconditions.checkNotNull(columnKey, (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.columnKey"), Preconditions.checkNotNull(value, (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.value"));
    }

    ImmutableTable() {
    }

    @Override
    public ImmutableSet<Table.Cell<R, C, V>> cellSet() {
        return (ImmutableSet)super.cellSet();
    }

    @Override
    abstract ImmutableSet<Table.Cell<R, C, V>> createCellSet();

    @Override
    final UnmodifiableIterator<Table.Cell<R, C, V>> cellIterator() {
        throw new AssertionError((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.should never be called");
    }

    @Override
    final Spliterator<Table.Cell<R, C, V>> cellSpliterator() {
        throw new AssertionError((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.should never be called");
    }

    @Override
    public ImmutableCollection<V> values() {
        return (ImmutableCollection)super.values();
    }

    @Override
    abstract ImmutableCollection<V> createValues();

    @Override
    final Iterator<V> valuesIterator() {
        throw new AssertionError((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.should never be called");
    }

    @Override
    public ImmutableMap<R, V> column(C columnKey) {
        Preconditions.checkNotNull(columnKey, (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.columnKey");
        return MoreObjects.firstNonNull((ImmutableMap)((Object)this.columnMap().get((org.rascalmpl.org.rascalmpl.java.lang.Object)columnKey)), ImmutableMap.of());
    }

    @Override
    public ImmutableSet<C> columnKeySet() {
        return this.columnMap().keySet();
    }

    @Override
    public abstract ImmutableMap<C, Map<R, V>> columnMap();

    @Override
    public ImmutableMap<C, V> row(R rowKey) {
        Preconditions.checkNotNull(rowKey, (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.rowKey");
        return MoreObjects.firstNonNull((ImmutableMap)((Object)this.rowMap().get((org.rascalmpl.org.rascalmpl.java.lang.Object)rowKey)), ImmutableMap.of());
    }

    @Override
    public ImmutableSet<R> rowKeySet() {
        return this.rowMap().keySet();
    }

    @Override
    public abstract ImmutableMap<R, Map<C, V>> rowMap();

    @Override
    public boolean contains(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object rowKey, @CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object columnKey) {
        return this.get(rowKey, columnKey) != null;
    }

    @Override
    public boolean containsValue(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object value) {
        return this.values().contains(value);
    }

    @Override
    @Deprecated
    @DoNotCall(value="org.rascalmpl.org.rascalmpl.Always throws UnsupportedOperationException")
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CheckForNull
    @CanIgnoreReturnValue
    @DoNotCall(value="org.rascalmpl.org.rascalmpl.Always throws UnsupportedOperationException")
    public final V put(R rowKey, C columnKey, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @DoNotCall(value="org.rascalmpl.org.rascalmpl.Always throws UnsupportedOperationException")
    public final void putAll(Table<? extends R, ? extends C, ? extends V> table) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CheckForNull
    @CanIgnoreReturnValue
    @DoNotCall(value="org.rascalmpl.org.rascalmpl.Always throws UnsupportedOperationException")
    public final V remove(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object rowKey, @CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object columnKey) {
        throw new UnsupportedOperationException();
    }

    @J2ktIncompatible
    @GwtIncompatible
    abstract org.rascalmpl.org.rascalmpl.java.lang.Object writeReplace();

    @GwtIncompatible
    @J2ktIncompatible
    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException((String)"org.rascalmpl.org.rascalmpl.Use SerializedForm");
    }

    static final class SerializedForm
    extends org.rascalmpl.org.rascalmpl.java.lang.Object
    implements Serializable {
        private final org.rascalmpl.org.rascalmpl.java.lang.Object[] rowKeys;
        private final org.rascalmpl.org.rascalmpl.java.lang.Object[] columnKeys;
        private final org.rascalmpl.org.rascalmpl.java.lang.Object[] cellValues;
        private final int[] cellRowIndices;
        private final int[] cellColumnIndices;
        private static final long serialVersionUID = 0L;

        private SerializedForm(org.rascalmpl.org.rascalmpl.java.lang.Object[] rowKeys, org.rascalmpl.org.rascalmpl.java.lang.Object[] columnKeys, org.rascalmpl.org.rascalmpl.java.lang.Object[] cellValues, int[] cellRowIndices, int[] cellColumnIndices) {
            this.rowKeys = rowKeys;
            this.columnKeys = columnKeys;
            this.cellValues = cellValues;
            this.cellRowIndices = cellRowIndices;
            this.cellColumnIndices = cellColumnIndices;
        }

        static SerializedForm create(ImmutableTable<?, ?, ?> table, int[] cellRowIndices, int[] cellColumnIndices) {
            return new SerializedForm(table.rowKeySet().toArray(), table.columnKeySet().toArray(), table.values().toArray(), cellRowIndices, cellColumnIndices);
        }

        org.rascalmpl.org.rascalmpl.java.lang.Object readResolve() {
            if (this.cellValues.length == 0) {
                return ImmutableTable.of();
            }
            if (this.cellValues.length == 1) {
                return ImmutableTable.of(this.rowKeys[0], this.columnKeys[0], this.cellValues[0]);
            }
            ImmutableList.Builder cellListBuilder = new ImmutableList.Builder(this.cellValues.length);
            for (int i = 0; i < this.cellValues.length; ++i) {
                cellListBuilder.add(ImmutableTable.cellOf(this.rowKeys[this.cellRowIndices[i]], this.columnKeys[this.cellColumnIndices[i]], this.cellValues[i]));
            }
            return RegularImmutableTable.forOrderedComponents(cellListBuilder.build(), ImmutableSet.copyOf((org.rascalmpl.org.rascalmpl.java.lang.Object[])this.rowKeys), ImmutableSet.copyOf((org.rascalmpl.org.rascalmpl.java.lang.Object[])this.columnKeys));
        }
    }

    @DoNotMock
    public static final class Builder<R extends org.rascalmpl.org.rascalmpl.java.lang.Object, C extends org.rascalmpl.org.rascalmpl.java.lang.Object, V extends org.rascalmpl.org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.org.rascalmpl.java.lang.Object {
        private final List<Table.Cell<R, C, V>> cells = Lists.newArrayList();
        @CheckForNull
        private Comparator<? super R> rowComparator;
        @CheckForNull
        private Comparator<? super C> columnComparator;

        @CanIgnoreReturnValue
        public Builder<R, C, V> orderRowsBy(Comparator<? super R> rowComparator) {
            this.rowComparator = Preconditions.checkNotNull(rowComparator, (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.rowComparator");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<R, C, V> orderColumnsBy(Comparator<? super C> columnComparator) {
            this.columnComparator = Preconditions.checkNotNull(columnComparator, (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.columnComparator");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<R, C, V> put(R rowKey, C columnKey, V value) {
            this.cells.add(ImmutableTable.cellOf(rowKey, columnKey, value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<R, C, V> put(Table.Cell<? extends R, ? extends C, ? extends V> cell) {
            if (cell instanceof Tables.ImmutableCell) {
                Preconditions.checkNotNull(cell.getRowKey(), (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.row");
                Preconditions.checkNotNull(cell.getColumnKey(), (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.column");
                Preconditions.checkNotNull(cell.getValue(), (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.value");
                Table.Cell<R, C, V> immutableCell = cell;
                this.cells.add(immutableCell);
            } else {
                this.put(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<R, C, V> putAll(Table<? extends R, ? extends C, ? extends V> table) {
            for (Table.Cell cell : table.cellSet()) {
                this.put(cell);
            }
            return this;
        }

        @CanIgnoreReturnValue
        Builder<R, C, V> combine(Builder<R, C, V> other) {
            this.cells.addAll(other.cells);
            return this;
        }

        public ImmutableTable<R, C, V> build() {
            return this.buildOrThrow();
        }

        public ImmutableTable<R, C, V> buildOrThrow() {
            int size = this.cells.size();
            switch (size) {
                case 0: {
                    return ImmutableTable.of();
                }
                case 1: {
                    return new SingletonImmutableTable<R, C, V>(Iterables.getOnlyElement(this.cells));
                }
            }
            return RegularImmutableTable.forCells(this.cells, this.rowComparator, this.columnComparator);
        }
    }
}

