/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.collect;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ParametricNullness;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Platform;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.org.rascalmpl.java.lang.NullPointerException;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.Array;
import org.rascalmpl.org.rascalmpl.java.util.Arrays;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.NonNull;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class ObjectArrays
extends Object {
    private ObjectArrays() {
    }

    @GwtIncompatible
    public static <T extends Object> T[] newArray(Class<@NonNull T> type, int length) {
        return (Object[])Array.newInstance(type, (int)length);
    }

    public static <T extends Object> T[] newArray(T[] reference, int length) {
        return Platform.newArray(reference, (int)length);
    }

    @GwtIncompatible
    public static <T extends Object> T[] concat(T[] first, T[] second, Class<@NonNull T> type) {
        Object[] result = ObjectArrays.newArray(type, (int)(first.length + second.length));
        System.arraycopy(first, (int)0, (Object)result, (int)0, (int)first.length);
        System.arraycopy(second, (int)0, (Object)result, (int)first.length, (int)second.length);
        return result;
    }

    public static <T extends Object> T[] concat(@ParametricNullness T element, T[] array) {
        Object[] result = ObjectArrays.newArray(array, (int)(array.length + 1));
        result[0] = element;
        System.arraycopy(array, (int)0, (Object)result, (int)1, (int)array.length);
        return result;
    }

    public static <T extends Object> T[] concat(T[] array, @ParametricNullness T element) {
        Object[] result = Arrays.copyOf(array, (int)(array.length + 1));
        result[array.length] = element;
        return result;
    }

    static <T extends Object> T[] toArrayImpl(Collection<?> c, T[] array) {
        int size = c.size();
        if (array.length < size) {
            array = ObjectArrays.newArray(array, (int)size);
        }
        ObjectArrays.fillArray(c, array);
        if (array.length > size) {
            @Nullable java.lang.Object[] unsoundlyCovariantArray = array;
            unsoundlyCovariantArray[size] = null;
        }
        return array;
    }

    static <T extends Object> T[] toArrayImpl(@Nullable Object[] src, int offset, int len, T[] dst) {
        Preconditions.checkPositionIndexes(offset, offset + len, src.length);
        if (dst.length < len) {
            dst = ObjectArrays.newArray(dst, (int)len);
        } else if (dst.length > len) {
            java.lang.Object[] unsoundlyCovariantArray = dst;
            unsoundlyCovariantArray[len] = null;
        }
        System.arraycopy((Object)src, (int)offset, dst, (int)0, (int)len);
        return dst;
    }

    static @Nullable Object[] toArrayImpl(Collection<?> c) {
        return ObjectArrays.fillArray(c, new Object[c.size()]);
    }

    static @Nullable Object[] copyAsObjectArray(@Nullable Object[] elements, int offset, int length) {
        Preconditions.checkPositionIndexes(offset, offset + length, elements.length);
        if (length == 0) {
            return new Object[0];
        }
        @Nullable Object[] result = new Object[length];
        System.arraycopy((Object)elements, (int)offset, (Object)result, (int)0, (int)length);
        return result;
    }

    @CanIgnoreReturnValue
    private static @Nullable Object[] fillArray(Iterable<?> elements, @Nullable Object[] array) {
        int i = 0;
        for (Object element : elements) {
            array[i++] = element;
        }
        return array;
    }

    static void swap(Object[] array, int i, int j) {
        Object temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }

    @CanIgnoreReturnValue
    static Object[] checkElementsNotNull(Object ... array) {
        return ObjectArrays.checkElementsNotNull(array, array.length);
    }

    @CanIgnoreReturnValue
    static Object[] checkElementsNotNull(Object[] array, int length) {
        for (int i = 0; i < length; ++i) {
            ObjectArrays.checkElementNotNull(array[i], i);
        }
        return array;
    }

    @CanIgnoreReturnValue
    static Object checkElementNotNull(Object element, int index) {
        if (element == null) {
            throw new NullPointerException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.at index ").append(index).toString());
        }
        return element;
    }
}

