/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.collect;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableAsList;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableCollection;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.UnmodifiableListIterator;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.util.function.Consumer;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
class RegularImmutableAsList<E extends Object>
extends ImmutableAsList<E> {
    private final ImmutableCollection<E> delegate;
    private final ImmutableList<? extends E> delegateList;

    RegularImmutableAsList(ImmutableCollection<E> delegate, ImmutableList<? extends E> delegateList) {
        this.delegate = delegate;
        this.delegateList = delegateList;
    }

    RegularImmutableAsList(ImmutableCollection<E> delegate, Object[] array) {
        this(delegate, ImmutableList.asImmutableList(array));
    }

    @Override
    ImmutableCollection<E> delegateCollection() {
        return this.delegate;
    }

    ImmutableList<? extends E> delegateList() {
        return this.delegateList;
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        return this.delegateList.listIterator(index);
    }

    @Override
    @GwtIncompatible
    public void forEach(Consumer<? super E> action) {
        this.delegateList.forEach(action);
    }

    @Override
    @GwtIncompatible
    int copyIntoArray(@Nullable Object[] dst, int offset) {
        return this.delegateList.copyIntoArray(dst, offset);
    }

    @Override
    @CheckForNull
    Object[] internalArray() {
        return this.delegateList.internalArray();
    }

    @Override
    int internalArrayStart() {
        return this.delegateList.internalArrayStart();
    }

    @Override
    int internalArrayEnd() {
        return this.delegateList.internalArrayEnd();
    }

    public E get(int index) {
        return (E)this.delegateList.get(index);
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

