/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.collect;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Function;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Lists;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Ordering;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ParametricNullness;
import org.rascalmpl.org.rascalmpl.java.lang.Comparable;
import org.rascalmpl.org.rascalmpl.java.lang.Enum;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.util.Comparator;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.RandomAccess;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class SortedLists
extends Object {
    private SortedLists() {
    }

    public static <E extends Comparable> int binarySearch(List<? extends E> list, E e, KeyPresentBehavior presentBehavior, KeyAbsentBehavior absentBehavior) {
        Preconditions.checkNotNull(e);
        return SortedLists.binarySearch(list, e, Ordering.natural(), presentBehavior, absentBehavior);
    }

    public static <E extends Object, K extends Comparable> int binarySearch(List<E> list, Function<? super E, K> keyFunction, K key, KeyPresentBehavior presentBehavior, KeyAbsentBehavior absentBehavior) {
        Preconditions.checkNotNull(key);
        return SortedLists.binarySearch(list, keyFunction, key, Ordering.natural(), presentBehavior, absentBehavior);
    }

    public static <E extends Object, K extends Object> int binarySearch(List<E> list, Function<? super E, K> keyFunction, @ParametricNullness K key, Comparator<? super K> keyComparator, KeyPresentBehavior presentBehavior, KeyAbsentBehavior absentBehavior) {
        return SortedLists.binarySearch(Lists.transform(list, keyFunction), key, keyComparator, presentBehavior, absentBehavior);
    }

    public static <E extends Object> int binarySearch(List<? extends E> list, @ParametricNullness E key, Comparator<? super E> comparator, KeyPresentBehavior presentBehavior, KeyAbsentBehavior absentBehavior) {
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(list);
        Preconditions.checkNotNull(presentBehavior);
        Preconditions.checkNotNull(absentBehavior);
        if (!(list instanceof RandomAccess)) {
            list = Lists.newArrayList(list);
        }
        int lower = 0;
        int upper = list.size() - 1;
        while (lower <= upper) {
            int middle = lower + upper >>> 1;
            int c = comparator.compare(key, list.get(middle));
            if (c < 0) {
                upper = middle - 1;
                continue;
            }
            if (c > 0) {
                lower = middle + 1;
                continue;
            }
            return lower + presentBehavior.resultIndex(comparator, key, list.subList(lower, upper + 1), middle - lower);
        }
        return absentBehavior.resultIndex(lower);
    }

    static abstract class KeyAbsentBehavior
    extends Enum<KeyAbsentBehavior> {
        public static final /* enum */ KeyAbsentBehavior NEXT_LOWER = new KeyAbsentBehavior(){

            @Override
            int resultIndex(int higherIndex) {
                return higherIndex - 1;
            }
        };
        public static final /* enum */ KeyAbsentBehavior NEXT_HIGHER = new KeyAbsentBehavior(){

            @Override
            public int resultIndex(int higherIndex) {
                return higherIndex;
            }
        };
        public static final /* enum */ KeyAbsentBehavior INVERTED_INSERTION_INDEX = new KeyAbsentBehavior(){

            @Override
            public int resultIndex(int higherIndex) {
                return ~higherIndex;
            }
        };
        private static final /* synthetic */ KeyAbsentBehavior[] $VALUES;

        public static KeyAbsentBehavior[] values() {
            return (KeyAbsentBehavior[])$VALUES.clone();
        }

        public static KeyAbsentBehavior valueOf(String name) {
            return (KeyAbsentBehavior)Enum.valueOf(KeyAbsentBehavior.class, (String)name);
        }

        private KeyAbsentBehavior() {
            super((String)string, n);
        }

        abstract int resultIndex(int var1);

        static {
            $VALUES = new KeyAbsentBehavior[]{NEXT_LOWER, NEXT_HIGHER, INVERTED_INSERTION_INDEX};
        }
    }

    static abstract class KeyPresentBehavior
    extends Enum<KeyPresentBehavior> {
        public static final /* enum */ KeyPresentBehavior ANY_PRESENT = new KeyPresentBehavior(){

            @Override
            <E extends Object> int resultIndex(Comparator<? super E> comparator, @ParametricNullness E key, List<? extends E> list, int foundIndex) {
                return foundIndex;
            }
        };
        public static final /* enum */ KeyPresentBehavior LAST_PRESENT = new KeyPresentBehavior(){

            @Override
            <E extends Object> int resultIndex(Comparator<? super E> comparator, @ParametricNullness E key, List<? extends E> list, int foundIndex) {
                int lower = foundIndex;
                int upper = list.size() - 1;
                while (lower < upper) {
                    int middle = lower + upper + 1 >>> 1;
                    int c = comparator.compare(list.get(middle), key);
                    if (c > 0) {
                        upper = middle - 1;
                        continue;
                    }
                    lower = middle;
                }
                return lower;
            }
        };
        public static final /* enum */ KeyPresentBehavior FIRST_PRESENT = new KeyPresentBehavior(){

            @Override
            <E extends Object> int resultIndex(Comparator<? super E> comparator, @ParametricNullness E key, List<? extends E> list, int foundIndex) {
                int lower = 0;
                int upper = foundIndex;
                while (lower < upper) {
                    int middle = lower + upper >>> 1;
                    int c = comparator.compare(list.get(middle), key);
                    if (c < 0) {
                        lower = middle + 1;
                        continue;
                    }
                    upper = middle;
                }
                return lower;
            }
        };
        public static final /* enum */ KeyPresentBehavior FIRST_AFTER = new KeyPresentBehavior(){

            @Override
            public <E extends Object> int resultIndex(Comparator<? super E> comparator, @ParametricNullness E key, List<? extends E> list, int foundIndex) {
                return LAST_PRESENT.resultIndex(comparator, key, list, foundIndex) + 1;
            }
        };
        public static final /* enum */ KeyPresentBehavior LAST_BEFORE = new KeyPresentBehavior(){

            @Override
            public <E extends Object> int resultIndex(Comparator<? super E> comparator, @ParametricNullness E key, List<? extends E> list, int foundIndex) {
                return FIRST_PRESENT.resultIndex(comparator, key, list, foundIndex) - 1;
            }
        };
        private static final /* synthetic */ KeyPresentBehavior[] $VALUES;

        public static KeyPresentBehavior[] values() {
            return (KeyPresentBehavior[])$VALUES.clone();
        }

        public static KeyPresentBehavior valueOf(String name) {
            return (KeyPresentBehavior)Enum.valueOf(KeyPresentBehavior.class, (String)name);
        }

        private KeyPresentBehavior() {
            super((String)string, n);
        }

        abstract <E extends Object> int resultIndex(Comparator<? super E> var1, @ParametricNullness E var2, List<? extends E> var3, int var4);

        static {
            $VALUES = new KeyPresentBehavior[]{ANY_PRESENT, LAST_PRESENT, FIRST_PRESENT, FIRST_AFTER, LAST_BEFORE};
        }
    }
}

