/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.collect;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Supplier;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.RowSortedTable;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.StandardTable;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.util.Comparator;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.SortedMap;
import org.rascalmpl.org.rascalmpl.java.util.SortedSet;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
class StandardRowSortedTable<R extends Object, C extends Object, V extends Object>
extends StandardTable<R, C, V>
implements RowSortedTable<R, C, V> {
    private static final long serialVersionUID = 0L;

    StandardRowSortedTable(SortedMap<R, Map<C, V>> backingMap, Supplier<? extends Map<C, V>> factory) {
        super(backingMap, factory);
    }

    private SortedMap<R, Map<C, V>> sortedBackingMap() {
        return (SortedMap)this.backingMap;
    }

    @Override
    public SortedSet<R> rowKeySet() {
        return (SortedSet)this.rowMap().keySet();
    }

    @Override
    public SortedMap<R, Map<C, V>> rowMap() {
        return (SortedMap)super.rowMap();
    }

    @Override
    SortedMap<R, Map<C, V>> createRowMap() {
        return new RowSortedMap();
    }

    private class RowSortedMap
    extends StandardTable.RowMap
    implements SortedMap<R, Map<C, V>> {
        private RowSortedMap() {
            super(StandardRowSortedTable.this);
        }

        @Override
        public SortedSet<R> keySet() {
            return (SortedSet)super.keySet();
        }

        @Override
        SortedSet<R> createKeySet() {
            return new Maps.SortedKeySet(this);
        }

        @CheckForNull
        public Comparator<? super R> comparator() {
            return StandardRowSortedTable.this.sortedBackingMap().comparator();
        }

        public R firstKey() {
            return StandardRowSortedTable.this.sortedBackingMap().firstKey();
        }

        public R lastKey() {
            return StandardRowSortedTable.this.sortedBackingMap().lastKey();
        }

        public SortedMap<R, Map<C, V>> headMap(R toKey) {
            Preconditions.checkNotNull(toKey);
            return new StandardRowSortedTable(StandardRowSortedTable.this.sortedBackingMap().headMap(toKey), StandardRowSortedTable.this.factory).rowMap();
        }

        public SortedMap<R, Map<C, V>> subMap(R fromKey, R toKey) {
            Preconditions.checkNotNull(fromKey);
            Preconditions.checkNotNull(toKey);
            return new StandardRowSortedTable(StandardRowSortedTable.this.sortedBackingMap().subMap(fromKey, toKey), StandardRowSortedTable.this.factory).rowMap();
        }

        public SortedMap<R, Map<C, V>> tailMap(R fromKey) {
            Preconditions.checkNotNull(fromKey);
            return new StandardRowSortedTable(StandardRowSortedTable.this.sortedBackingMap().tailMap(fromKey), StandardRowSortedTable.this.factory).rowMap();
        }
    }
}

