/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.graph;

import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.HashMultiset;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableMap;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Multiset;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.AbstractDirectedNetworkConnections;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.MultiEdgesConnecting;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.concurrent.LazyInit;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.ref.Reference;
import org.rascalmpl.org.rascalmpl.java.lang.ref.SoftReference;
import org.rascalmpl.org.rascalmpl.java.util.Collections;
import org.rascalmpl.org.rascalmpl.java.util.HashMap;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.Set;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
final class DirectedMultiNetworkConnections<N extends Object, E extends Object>
extends AbstractDirectedNetworkConnections<N, E> {
    @CheckForNull
    @LazyInit
    private transient Reference<Multiset<N>> predecessorsReference;
    @CheckForNull
    @LazyInit
    private transient Reference<Multiset<N>> successorsReference;

    private DirectedMultiNetworkConnections(Map<E, N> inEdges, Map<E, N> outEdges, int selfLoopCount) {
        super(inEdges, outEdges, selfLoopCount);
    }

    static <N extends Object, E extends Object> DirectedMultiNetworkConnections<N, E> of() {
        return new DirectedMultiNetworkConnections<N, E>(new HashMap(2, 1.0f), new HashMap(2, 1.0f), 0);
    }

    static <N extends Object, E extends Object> DirectedMultiNetworkConnections<N, E> ofImmutable(Map<E, N> inEdges, Map<E, N> outEdges, int selfLoopCount) {
        return new DirectedMultiNetworkConnections<N, E>(ImmutableMap.copyOf(inEdges), ImmutableMap.copyOf(outEdges), selfLoopCount);
    }

    @Override
    public Set<N> predecessors() {
        return Collections.unmodifiableSet(this.predecessorsMultiset().elementSet());
    }

    private Multiset<N> predecessorsMultiset() {
        Multiset<N> predecessors = DirectedMultiNetworkConnections.getReference(this.predecessorsReference);
        if (predecessors == null) {
            predecessors = HashMultiset.create(this.inEdgeMap.values());
            this.predecessorsReference = new SoftReference(predecessors);
        }
        return predecessors;
    }

    @Override
    public Set<N> successors() {
        return Collections.unmodifiableSet(this.successorsMultiset().elementSet());
    }

    private Multiset<N> successorsMultiset() {
        Multiset<N> successors = DirectedMultiNetworkConnections.getReference(this.successorsReference);
        if (successors == null) {
            successors = HashMultiset.create(this.outEdgeMap.values());
            this.successorsReference = new SoftReference(successors);
        }
        return successors;
    }

    @Override
    public Set<E> edgesConnecting(N node) {
        return new MultiEdgesConnecting<E>(this.outEdgeMap, (Object)node, (Object)node){
            final /* synthetic */ Object val$node;
            {
                this.val$node = object;
                super(outEdgeToNode, targetNode);
            }

            public int size() {
                return DirectedMultiNetworkConnections.this.successorsMultiset().count(this.val$node);
            }
        };
    }

    @Override
    public N removeInEdge(E edge, boolean isSelfLoop) {
        java.lang.Object node = super.removeInEdge(edge, isSelfLoop);
        Multiset<N> predecessors = DirectedMultiNetworkConnections.getReference(this.predecessorsReference);
        if (predecessors != null) {
            Preconditions.checkState(predecessors.remove((Object)node));
        }
        return node;
    }

    @Override
    public N removeOutEdge(E edge) {
        java.lang.Object node = super.removeOutEdge(edge);
        Multiset<N> successors = DirectedMultiNetworkConnections.getReference(this.successorsReference);
        if (successors != null) {
            Preconditions.checkState(successors.remove((Object)node));
        }
        return node;
    }

    @Override
    public void addInEdge(E edge, N node, boolean isSelfLoop) {
        super.addInEdge(edge, node, isSelfLoop);
        Multiset<N> predecessors = DirectedMultiNetworkConnections.getReference(this.predecessorsReference);
        if (predecessors != null) {
            Preconditions.checkState(predecessors.add(node));
        }
    }

    @Override
    public void addOutEdge(E edge, N node) {
        super.addOutEdge(edge, node);
        Multiset<N> successors = DirectedMultiNetworkConnections.getReference(this.successorsReference);
        if (successors != null) {
            Preconditions.checkState(successors.add(node));
        }
    }

    @CheckForNull
    private static <T extends Object> T getReference(@CheckForNull Reference<T> reference) {
        return (T)(reference == null ? null : reference.get());
    }
}

