/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.graph;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.Beta;
import org.rascalmpl.org.rascalmpl.com.google.common.base.MoreObjects;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Objects;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Ordering;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.Immutable;
import org.rascalmpl.org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.org.rascalmpl.java.lang.Comparable;
import org.rascalmpl.org.rascalmpl.java.lang.Enum;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.org.rascalmpl.java.util.Comparator;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;

@Immutable
@ElementTypesAreNonnullByDefault
@Beta
public final class ElementOrder<T extends Object>
extends Object {
    private final Type type;
    @CheckForNull
    private final Comparator<T> comparator;

    private ElementOrder(Type type, @CheckForNull Comparator<T> comparator) {
        this.type = Preconditions.checkNotNull(type);
        this.comparator = comparator;
        Preconditions.checkState(type == Type.SORTED == (comparator != null));
    }

    public static <S extends Object> ElementOrder<S> unordered() {
        return new ElementOrder(Type.UNORDERED, null);
    }

    public static <S extends Object> ElementOrder<S> stable() {
        return new ElementOrder(Type.STABLE, null);
    }

    public static <S extends Object> ElementOrder<S> insertion() {
        return new ElementOrder(Type.INSERTION, null);
    }

    public static <S extends Comparable<? super S>> ElementOrder<S> natural() {
        return new ElementOrder(Type.SORTED, Ordering.natural());
    }

    public static <S extends Object> ElementOrder<S> sorted(Comparator<S> comparator) {
        return new ElementOrder<S>(Type.SORTED, Preconditions.checkNotNull(comparator));
    }

    public Type type() {
        return this.type;
    }

    public Comparator<T> comparator() {
        if (this.comparator != null) {
            return this.comparator;
        }
        throw new UnsupportedOperationException((String)"org.rascalmpl.org.rascalmpl.This ordering does not define a comparator.");
    }

    public boolean equals(@CheckForNull Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ElementOrder)) {
            return false;
        }
        ElementOrder other = (ElementOrder)obj;
        return this.type == other.type && Objects.equal(this.comparator, other.comparator);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.type, this.comparator});
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this).add((String)"org.rascalmpl.org.rascalmpl.type", (Object)this.type);
        if (this.comparator != null) {
            helper.add((String)"org.rascalmpl.org.rascalmpl.comparator", (Object)this.comparator);
        }
        return helper.toString();
    }

    <K extends T, V extends Object> Map<K, V> createMap(int expectedSize) {
        switch (this.type) {
            case UNORDERED: {
                return Maps.newHashMapWithExpectedSize(expectedSize);
            }
            case INSERTION: 
            case STABLE: {
                return Maps.newLinkedHashMapWithExpectedSize(expectedSize);
            }
            case SORTED: {
                return Maps.newTreeMap(this.comparator());
            }
        }
        throw new AssertionError();
    }

    <T1 extends T> ElementOrder<T1> cast() {
        return this;
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type UNORDERED = new Type((String)"org.rascalmpl.org.rascalmpl.UNORDERED", 0);
        public static final /* enum */ Type STABLE = new Type((String)"org.rascalmpl.org.rascalmpl.STABLE", 1);
        public static final /* enum */ Type INSERTION = new Type((String)"org.rascalmpl.org.rascalmpl.INSERTION", 2);
        public static final /* enum */ Type SORTED = new Type((String)"org.rascalmpl.org.rascalmpl.SORTED", 3);
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return (Type)Enum.valueOf(Type.class, (String)name);
        }

        private Type() {
            super((String)string, n);
        }

        static {
            $VALUES = new Type[]{UNORDERED, STABLE, INSERTION, SORTED};
        }
    }
}

