/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.graph;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.Beta;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableSet;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Iterables;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.EndpointPair;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.ForwardingGraph;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.ForwardingNetwork;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.ForwardingValueGraph;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.Graph;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.GraphBuilder;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.GraphsBridgeMethods;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.ImmutableGraph;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.IncidentEdgeSet;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.MutableGraph;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.MutableNetwork;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.MutableValueGraph;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.Network;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.NetworkBuilder;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.Traverser;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.ValueGraph;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.ValueGraphBuilder;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.java.lang.Enum;
import org.rascalmpl.org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.HashMap;
import org.rascalmpl.org.rascalmpl.java.util.HashSet;
import org.rascalmpl.org.rascalmpl.java.util.Iterator;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.Objects;
import org.rascalmpl.org.rascalmpl.java.util.Optional;
import org.rascalmpl.org.rascalmpl.java.util.Set;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@Beta
public final class Graphs
extends GraphsBridgeMethods {
    private Graphs() {
    }

    public static <N extends org.rascalmpl.org.rascalmpl.java.lang.Object> boolean hasCycle(Graph<N> graph) {
        int numEdges = graph.edges().size();
        if (numEdges == 0) {
            return false;
        }
        if (!graph.isDirected() && numEdges >= graph.nodes().size()) {
            return true;
        }
        HashMap visitedNodes = Maps.newHashMapWithExpectedSize(graph.nodes().size());
        for (org.rascalmpl.org.rascalmpl.java.lang.Object node : graph.nodes()) {
            if (!Graphs.subgraphHasCycle(graph, visitedNodes, node, null)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCycle(Network<?, ?> network) {
        if (!network.isDirected() && network.allowsParallelEdges() && network.edges().size() > network.asGraph().edges().size()) {
            return true;
        }
        return Graphs.hasCycle(network.asGraph());
    }

    private static <N extends org.rascalmpl.org.rascalmpl.java.lang.Object> boolean subgraphHasCycle(Graph<N> graph, Map<org.rascalmpl.org.rascalmpl.java.lang.Object, NodeVisitState> visitedNodes, N node, @CheckForNull N previousNode) {
        NodeVisitState state = (NodeVisitState)visitedNodes.get(node);
        if (state == NodeVisitState.COMPLETE) {
            return false;
        }
        if (state == NodeVisitState.PENDING) {
            return true;
        }
        visitedNodes.put(node, (org.rascalmpl.org.rascalmpl.java.lang.Object)NodeVisitState.PENDING);
        for (org.rascalmpl.org.rascalmpl.java.lang.Object nextNode : graph.successors(node)) {
            if (!Graphs.canTraverseWithoutReusingEdge(graph, nextNode, previousNode) || !Graphs.subgraphHasCycle(graph, visitedNodes, nextNode, node)) continue;
            return true;
        }
        visitedNodes.put(node, (org.rascalmpl.org.rascalmpl.java.lang.Object)NodeVisitState.COMPLETE);
        return false;
    }

    private static boolean canTraverseWithoutReusingEdge(Graph<?> graph, org.rascalmpl.org.rascalmpl.java.lang.Object nextNode, @CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object previousNode) {
        return graph.isDirected() || !org.rascalmpl.org.rascalmpl.com.google.common.base.Objects.equal(previousNode, nextNode);
    }

    public static <N extends org.rascalmpl.org.rascalmpl.java.lang.Object> ImmutableGraph<N> transitiveClosure(Graph<N> graph) {
        ImmutableGraph.Builder transitiveClosure = GraphBuilder.from(graph).allowsSelfLoops(true).immutable();
        if (graph.isDirected()) {
            for (org.rascalmpl.org.rascalmpl.java.lang.Object node : graph.nodes()) {
                Iterator iterator = Graphs.reachableNodes(graph, node).iterator();
                while (iterator.hasNext()) {
                    org.rascalmpl.org.rascalmpl.java.lang.Object reachableNode = iterator.next();
                    transitiveClosure.putEdge(node, reachableNode);
                }
            }
        } else {
            HashSet visitedNodes = new HashSet();
            for (org.rascalmpl.org.rascalmpl.java.lang.Object node : graph.nodes()) {
                if (visitedNodes.contains(node)) continue;
                ImmutableSet<org.rascalmpl.org.rascalmpl.java.lang.Object> reachableNodes = Graphs.reachableNodes(graph, node);
                visitedNodes.addAll(reachableNodes);
                int pairwiseMatch = 1;
                Iterator iterator = reachableNodes.iterator();
                while (iterator.hasNext()) {
                    org.rascalmpl.org.rascalmpl.java.lang.Object nodeU = iterator.next();
                    for (org.rascalmpl.org.rascalmpl.java.lang.Object nodeV : Iterables.limit(reachableNodes, pairwiseMatch++)) {
                        transitiveClosure.putEdge(nodeU, nodeV);
                    }
                }
            }
        }
        return transitiveClosure.build();
    }

    public static <N extends org.rascalmpl.org.rascalmpl.java.lang.Object> ImmutableSet<N> reachableNodes(Graph<N> graph, N node) {
        Preconditions.checkArgument(graph.nodes().contains(node), (String)"org.rascalmpl.org.rascalmpl.Node %s is not an element of this graph.", node);
        return ImmutableSet.copyOf(Traverser.forGraph(graph).breadthFirst(node));
    }

    public static <N extends org.rascalmpl.org.rascalmpl.java.lang.Object> Graph<N> transpose(Graph<N> graph) {
        if (!graph.isDirected()) {
            return graph;
        }
        if (graph instanceof TransposedGraph) {
            return ((TransposedGraph)graph).graph;
        }
        return new TransposedGraph<N>(graph);
    }

    public static <N extends org.rascalmpl.org.rascalmpl.java.lang.Object, V extends org.rascalmpl.org.rascalmpl.java.lang.Object> ValueGraph<N, V> transpose(ValueGraph<N, V> graph) {
        if (!graph.isDirected()) {
            return graph;
        }
        if (graph instanceof TransposedValueGraph) {
            return ((TransposedValueGraph)graph).graph;
        }
        return new TransposedValueGraph<N, V>(graph);
    }

    public static <N extends org.rascalmpl.org.rascalmpl.java.lang.Object, E extends org.rascalmpl.org.rascalmpl.java.lang.Object> Network<N, E> transpose(Network<N, E> network) {
        if (!network.isDirected()) {
            return network;
        }
        if (network instanceof TransposedNetwork) {
            return ((TransposedNetwork)network).network;
        }
        return new TransposedNetwork<N, E>(network);
    }

    static <N extends org.rascalmpl.org.rascalmpl.java.lang.Object> EndpointPair<N> transpose(EndpointPair<N> endpoints) {
        if (endpoints.isOrdered()) {
            return EndpointPair.ordered(endpoints.target(), endpoints.source());
        }
        return endpoints;
    }

    public static <N extends org.rascalmpl.org.rascalmpl.java.lang.Object> MutableGraph<N> inducedSubgraph(Graph<N> graph, Iterable<? extends N> nodes) {
        MutableGraph subgraph = nodes instanceof Collection ? GraphBuilder.from(graph).expectedNodeCount(((Collection)nodes).size()).build() : GraphBuilder.from(graph).build();
        for (org.rascalmpl.org.rascalmpl.java.lang.Object node : nodes) {
            subgraph.addNode(node);
        }
        for (org.rascalmpl.org.rascalmpl.java.lang.Object node : subgraph.nodes()) {
            for (org.rascalmpl.org.rascalmpl.java.lang.Object successorNode : graph.successors(node)) {
                if (!subgraph.nodes().contains(successorNode)) continue;
                subgraph.putEdge(node, successorNode);
            }
        }
        return subgraph;
    }

    public static <N extends org.rascalmpl.org.rascalmpl.java.lang.Object, V extends org.rascalmpl.org.rascalmpl.java.lang.Object> MutableValueGraph<N, V> inducedSubgraph(ValueGraph<N, V> graph, Iterable<? extends N> nodes) {
        MutableValueGraph subgraph = nodes instanceof Collection ? ValueGraphBuilder.from(graph).expectedNodeCount(((Collection)nodes).size()).build() : ValueGraphBuilder.from(graph).build();
        for (org.rascalmpl.org.rascalmpl.java.lang.Object node : nodes) {
            subgraph.addNode(node);
        }
        for (org.rascalmpl.org.rascalmpl.java.lang.Object node : subgraph.nodes()) {
            for (org.rascalmpl.org.rascalmpl.java.lang.Object successorNode : graph.successors(node)) {
                if (!subgraph.nodes().contains(successorNode)) continue;
                subgraph.putEdgeValue(node, successorNode, Objects.requireNonNull(graph.edgeValueOrDefault(node, successorNode, null)));
            }
        }
        return subgraph;
    }

    public static <N extends org.rascalmpl.org.rascalmpl.java.lang.Object, E extends org.rascalmpl.org.rascalmpl.java.lang.Object> MutableNetwork<N, E> inducedSubgraph(Network<N, E> network, Iterable<? extends N> nodes) {
        MutableNetwork subgraph = nodes instanceof Collection ? NetworkBuilder.from(network).expectedNodeCount(((Collection)nodes).size()).build() : NetworkBuilder.from(network).build();
        for (org.rascalmpl.org.rascalmpl.java.lang.Object node : nodes) {
            subgraph.addNode(node);
        }
        for (org.rascalmpl.org.rascalmpl.java.lang.Object node : subgraph.nodes()) {
            for (org.rascalmpl.org.rascalmpl.java.lang.Object edge : network.outEdges(node)) {
                org.rascalmpl.org.rascalmpl.java.lang.Object successorNode = network.incidentNodes(edge).adjacentNode(node);
                if (!subgraph.nodes().contains(successorNode)) continue;
                subgraph.addEdge(node, successorNode, edge);
            }
        }
        return subgraph;
    }

    public static <N extends org.rascalmpl.org.rascalmpl.java.lang.Object> MutableGraph<N> copyOf(Graph<N> graph) {
        MutableGraph copy = GraphBuilder.from(graph).expectedNodeCount(graph.nodes().size()).build();
        for (org.rascalmpl.org.rascalmpl.java.lang.Object node : graph.nodes()) {
            copy.addNode(node);
        }
        for (EndpointPair edge : graph.edges()) {
            copy.putEdge(edge.nodeU(), edge.nodeV());
        }
        return copy;
    }

    public static <N extends org.rascalmpl.org.rascalmpl.java.lang.Object, V extends org.rascalmpl.org.rascalmpl.java.lang.Object> MutableValueGraph<N, V> copyOf(ValueGraph<N, V> graph) {
        MutableValueGraph copy = ValueGraphBuilder.from(graph).expectedNodeCount(graph.nodes().size()).build();
        for (org.rascalmpl.org.rascalmpl.java.lang.Object node : graph.nodes()) {
            copy.addNode(node);
        }
        for (EndpointPair edge : graph.edges()) {
            copy.putEdgeValue(edge.nodeU(), edge.nodeV(), Objects.requireNonNull(graph.edgeValueOrDefault(edge.nodeU(), edge.nodeV(), null)));
        }
        return copy;
    }

    public static <N extends org.rascalmpl.org.rascalmpl.java.lang.Object, E extends org.rascalmpl.org.rascalmpl.java.lang.Object> MutableNetwork<N, E> copyOf(Network<N, E> network) {
        MutableNetwork copy = NetworkBuilder.from(network).expectedNodeCount(network.nodes().size()).expectedEdgeCount(network.edges().size()).build();
        for (org.rascalmpl.org.rascalmpl.java.lang.Object node : network.nodes()) {
            copy.addNode(node);
        }
        for (org.rascalmpl.org.rascalmpl.java.lang.Object edge : network.edges()) {
            EndpointPair<N> endpointPair = network.incidentNodes(edge);
            copy.addEdge(endpointPair.nodeU(), endpointPair.nodeV(), edge);
        }
        return copy;
    }

    @CanIgnoreReturnValue
    static int checkNonNegative(int value) {
        Preconditions.checkArgument(value >= 0, (String)"org.rascalmpl.org.rascalmpl.Not true that %s is non-negative.", value);
        return value;
    }

    @CanIgnoreReturnValue
    static long checkNonNegative(long value) {
        Preconditions.checkArgument(value >= 0L, (String)"org.rascalmpl.org.rascalmpl.Not true that %s is non-negative.", value);
        return value;
    }

    @CanIgnoreReturnValue
    static int checkPositive(int value) {
        Preconditions.checkArgument(value > 0, (String)"org.rascalmpl.org.rascalmpl.Not true that %s is positive.", value);
        return value;
    }

    @CanIgnoreReturnValue
    static long checkPositive(long value) {
        Preconditions.checkArgument(value > 0L, (String)"org.rascalmpl.org.rascalmpl.Not true that %s is positive.", value);
        return value;
    }

    private static final class NodeVisitState
    extends Enum<NodeVisitState> {
        public static final /* enum */ NodeVisitState PENDING = new NodeVisitState((String)"org.rascalmpl.org.rascalmpl.PENDING", 0);
        public static final /* enum */ NodeVisitState COMPLETE = new NodeVisitState((String)"org.rascalmpl.org.rascalmpl.COMPLETE", 1);
        private static final /* synthetic */ NodeVisitState[] $VALUES;

        public static NodeVisitState[] values() {
            return (NodeVisitState[])$VALUES.clone();
        }

        public static NodeVisitState valueOf(String name) {
            return (NodeVisitState)Enum.valueOf(NodeVisitState.class, (String)name);
        }

        private NodeVisitState() {
            super((String)string, n);
        }

        static {
            $VALUES = new NodeVisitState[]{PENDING, COMPLETE};
        }
    }

    private static class TransposedNetwork<N extends org.rascalmpl.org.rascalmpl.java.lang.Object, E extends org.rascalmpl.org.rascalmpl.java.lang.Object>
    extends ForwardingNetwork<N, E> {
        private final Network<N, E> network;

        TransposedNetwork(Network<N, E> network) {
            this.network = network;
        }

        @Override
        Network<N, E> delegate() {
            return this.network;
        }

        @Override
        public Set<N> predecessors(N node) {
            return this.delegate().successors(node);
        }

        @Override
        public Set<N> successors(N node) {
            return this.delegate().predecessors(node);
        }

        @Override
        public int inDegree(N node) {
            return this.delegate().outDegree(node);
        }

        @Override
        public int outDegree(N node) {
            return this.delegate().inDegree(node);
        }

        @Override
        public Set<E> inEdges(N node) {
            return this.delegate().outEdges(node);
        }

        @Override
        public Set<E> outEdges(N node) {
            return this.delegate().inEdges(node);
        }

        @Override
        public EndpointPair<N> incidentNodes(E edge) {
            EndpointPair<N> endpointPair = this.delegate().incidentNodes(edge);
            return EndpointPair.of(this.network, endpointPair.nodeV(), endpointPair.nodeU());
        }

        @Override
        public Set<E> edgesConnecting(N nodeU, N nodeV) {
            return this.delegate().edgesConnecting(nodeV, nodeU);
        }

        @Override
        public Set<E> edgesConnecting(EndpointPair<N> endpoints) {
            return this.delegate().edgesConnecting(Graphs.transpose(endpoints));
        }

        @Override
        public Optional<E> edgeConnecting(N nodeU, N nodeV) {
            return this.delegate().edgeConnecting(nodeV, nodeU);
        }

        @Override
        public Optional<E> edgeConnecting(EndpointPair<N> endpoints) {
            return this.delegate().edgeConnecting(Graphs.transpose(endpoints));
        }

        @Override
        @CheckForNull
        public E edgeConnectingOrNull(N nodeU, N nodeV) {
            return this.delegate().edgeConnectingOrNull(nodeV, nodeU);
        }

        @Override
        @CheckForNull
        public E edgeConnectingOrNull(EndpointPair<N> endpoints) {
            return this.delegate().edgeConnectingOrNull(Graphs.transpose(endpoints));
        }

        @Override
        public boolean hasEdgeConnecting(N nodeU, N nodeV) {
            return this.delegate().hasEdgeConnecting(nodeV, nodeU);
        }

        @Override
        public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
            return this.delegate().hasEdgeConnecting(Graphs.transpose(endpoints));
        }
    }

    private static class TransposedValueGraph<N extends org.rascalmpl.org.rascalmpl.java.lang.Object, V extends org.rascalmpl.org.rascalmpl.java.lang.Object>
    extends ForwardingValueGraph<N, V> {
        private final ValueGraph<N, V> graph;

        TransposedValueGraph(ValueGraph<N, V> graph) {
            this.graph = graph;
        }

        @Override
        ValueGraph<N, V> delegate() {
            return this.graph;
        }

        @Override
        public Set<N> predecessors(N node) {
            return this.delegate().successors(node);
        }

        @Override
        public Set<N> successors(N node) {
            return this.delegate().predecessors(node);
        }

        @Override
        public int inDegree(N node) {
            return this.delegate().outDegree(node);
        }

        @Override
        public int outDegree(N node) {
            return this.delegate().inDegree(node);
        }

        @Override
        public boolean hasEdgeConnecting(N nodeU, N nodeV) {
            return this.delegate().hasEdgeConnecting(nodeV, nodeU);
        }

        @Override
        public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
            return this.delegate().hasEdgeConnecting(Graphs.transpose(endpoints));
        }

        @Override
        public Optional<V> edgeValue(N nodeU, N nodeV) {
            return this.delegate().edgeValue(nodeV, nodeU);
        }

        @Override
        public Optional<V> edgeValue(EndpointPair<N> endpoints) {
            return this.delegate().edgeValue(Graphs.transpose(endpoints));
        }

        @Override
        @CheckForNull
        public V edgeValueOrDefault(N nodeU, N nodeV, @CheckForNull V defaultValue) {
            return this.delegate().edgeValueOrDefault(nodeV, nodeU, defaultValue);
        }

        @Override
        @CheckForNull
        public V edgeValueOrDefault(EndpointPair<N> endpoints, @CheckForNull V defaultValue) {
            return this.delegate().edgeValueOrDefault(Graphs.transpose(endpoints), defaultValue);
        }
    }

    private static class TransposedGraph<N extends org.rascalmpl.org.rascalmpl.java.lang.Object>
    extends ForwardingGraph<N> {
        private final Graph<N> graph;

        TransposedGraph(Graph<N> graph) {
            this.graph = graph;
        }

        @Override
        Graph<N> delegate() {
            return this.graph;
        }

        @Override
        public Set<N> predecessors(N node) {
            return this.delegate().successors(node);
        }

        @Override
        public Set<N> successors(N node) {
            return this.delegate().predecessors(node);
        }

        @Override
        public Set<EndpointPair<N>> incidentEdges(N node) {
            return new IncidentEdgeSet<N>(this, (org.rascalmpl.org.rascalmpl.java.lang.Object)node){

                /*
                 * Exception decompiling
                 */
                public Iterator<EndpointPair<N>> iterator() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/org/rascalmpl/java/lang/Object;)Lorg/rascalmpl/org/rascalmpl/java/lang/Object;
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
                     *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                private /* synthetic */ EndpointPair lambda$iterator$0(EndpointPair edge) {
                    return EndpointPair.of(this.delegate(), edge.nodeV(), edge.nodeU());
                }
            };
        }

        @Override
        public int inDegree(N node) {
            return this.delegate().outDegree(node);
        }

        @Override
        public int outDegree(N node) {
            return this.delegate().inDegree(node);
        }

        @Override
        public boolean hasEdgeConnecting(N nodeU, N nodeV) {
            return this.delegate().hasEdgeConnecting(nodeV, nodeU);
        }

        @Override
        public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
            return this.delegate().hasEdgeConnecting(Graphs.transpose(endpoints));
        }
    }
}

