/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.graph;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.Beta;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Function;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Functions;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableMap;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.BaseGraph;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.DirectedGraphConnections;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.ElementOrder;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.EndpointPair;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.ForwardingGraph;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.Graph;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.GraphBuilder;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.GraphConnections;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.GraphConstants;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.MutableGraph;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.StandardValueGraph;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.UndirectedGraphConnections;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.Immutable;
import org.rascalmpl.org.rascalmpl.java.lang.Deprecated;

@Immutable(containerOf={"org.rascalmpl.org.rascalmpl.N"})
@ElementTypesAreNonnullByDefault
@Beta
public class ImmutableGraph<N extends org.rascalmpl.org.rascalmpl.java.lang.Object>
extends ForwardingGraph<N> {
    private final BaseGraph<N> backingGraph;

    ImmutableGraph(BaseGraph<N> backingGraph) {
        this.backingGraph = backingGraph;
    }

    public static <N extends org.rascalmpl.org.rascalmpl.java.lang.Object> ImmutableGraph<N> copyOf(Graph<N> graph) {
        return graph instanceof ImmutableGraph ? (ImmutableGraph<N>)graph : new ImmutableGraph<N>(new StandardValueGraph<N, GraphConstants.Presence>(GraphBuilder.from(graph), ImmutableGraph.getNodeConnections(graph), graph.edges().size()));
    }

    @Deprecated
    public static <N extends org.rascalmpl.org.rascalmpl.java.lang.Object> ImmutableGraph<N> copyOf(ImmutableGraph<N> graph) {
        return Preconditions.checkNotNull(graph);
    }

    @Override
    public ElementOrder<N> incidentEdgeOrder() {
        return ElementOrder.stable();
    }

    private static <N extends org.rascalmpl.org.rascalmpl.java.lang.Object> ImmutableMap<N, GraphConnections<N, GraphConstants.Presence>> getNodeConnections(Graph<N> graph) {
        ImmutableMap.Builder<org.rascalmpl.org.rascalmpl.java.lang.Object, GraphConnections<org.rascalmpl.org.rascalmpl.java.lang.Object, GraphConstants.Presence>> nodeConnections = ImmutableMap.builder();
        for (org.rascalmpl.org.rascalmpl.java.lang.Object node : graph.nodes()) {
            nodeConnections.put(node, ImmutableGraph.connectionsOf(graph, node));
        }
        return nodeConnections.buildOrThrow();
    }

    private static <N extends org.rascalmpl.org.rascalmpl.java.lang.Object> GraphConnections<N, GraphConstants.Presence> connectionsOf(Graph<N> graph, N node) {
        Function<org.rascalmpl.org.rascalmpl.java.lang.Object, GraphConstants.Presence> edgeValueFn = Functions.constant(GraphConstants.Presence.EDGE_EXISTS);
        return graph.isDirected() ? DirectedGraphConnections.ofImmutable(node, graph.incidentEdges(node), edgeValueFn) : UndirectedGraphConnections.ofImmutable(Maps.asMap(graph.adjacentNodes(node), edgeValueFn));
    }

    @Override
    BaseGraph<N> delegate() {
        return this.backingGraph;
    }

    public static class Builder<N extends org.rascalmpl.org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.org.rascalmpl.java.lang.Object {
        private final MutableGraph<N> mutableGraph;

        Builder(GraphBuilder<N> graphBuilder) {
            this.mutableGraph = graphBuilder.copy().incidentEdgeOrder(ElementOrder.stable()).build();
        }

        @CanIgnoreReturnValue
        public Builder<N> addNode(N node) {
            this.mutableGraph.addNode(node);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<N> putEdge(N nodeU, N nodeV) {
            this.mutableGraph.putEdge(nodeU, nodeV);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<N> putEdge(EndpointPair<N> endpoints) {
            this.mutableGraph.putEdge(endpoints);
            return this;
        }

        public ImmutableGraph<N> build() {
            return ImmutableGraph.copyOf(this.mutableGraph);
        }
    }
}

