/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.graph;

import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Supplier;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ForwardingSet;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.util.Set;

@ElementTypesAreNonnullByDefault
final class InvalidatableSet<E extends Object>
extends ForwardingSet<E> {
    private final Supplier<Boolean> validator;
    private final Set<E> delegate;
    private final Supplier<String> errorMessage;

    public static final <E extends Object> InvalidatableSet<E> of(Set<E> delegate, Supplier<Boolean> validator, Supplier<String> errorMessage) {
        return new InvalidatableSet<E>(Preconditions.checkNotNull(delegate), Preconditions.checkNotNull(validator), Preconditions.checkNotNull(errorMessage));
    }

    @Override
    protected Set<E> delegate() {
        this.validate();
        return this.delegate;
    }

    private InvalidatableSet(Set<E> delegate, Supplier<Boolean> validator, Supplier<String> errorMessage) {
        this.delegate = delegate;
        this.validator = validator;
        this.errorMessage = errorMessage;
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    private void validate() {
        if (!this.validator.get().booleanValue()) {
            throw new IllegalStateException(this.errorMessage.get());
        }
    }
}

