/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.graph;

import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableSet;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.AbstractNetwork;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.ElementOrder;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.EndpointPair;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.MapIteratorCache;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.MapRetrievalCache;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.NetworkBuilder;
import org.rascalmpl.org.rascalmpl.com.google.common.graph.NetworkConnections;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.Integer;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.Objects;
import org.rascalmpl.org.rascalmpl.java.util.Set;
import org.rascalmpl.org.rascalmpl.java.util.TreeMap;

@ElementTypesAreNonnullByDefault
class StandardNetwork<N extends Object, E extends Object>
extends AbstractNetwork<N, E> {
    private final boolean isDirected;
    private final boolean allowsParallelEdges;
    private final boolean allowsSelfLoops;
    private final ElementOrder<N> nodeOrder;
    private final ElementOrder<E> edgeOrder;
    final MapIteratorCache<N, NetworkConnections<N, E>> nodeConnections;
    final MapIteratorCache<E, N> edgeToReferenceNode;

    StandardNetwork(NetworkBuilder<? super N, ? super E> builder) {
        this(builder, builder.nodeOrder.createMap(builder.expectedNodeCount.or(Integer.valueOf((int)10)).intValue()), builder.edgeOrder.createMap(builder.expectedEdgeCount.or(Integer.valueOf((int)20)).intValue()));
    }

    StandardNetwork(NetworkBuilder<? super N, ? super E> builder, Map<N, NetworkConnections<N, E>> nodeConnections, Map<E, N> edgeToReferenceNode) {
        this.isDirected = builder.directed;
        this.allowsParallelEdges = builder.allowsParallelEdges;
        this.allowsSelfLoops = builder.allowsSelfLoops;
        this.nodeOrder = builder.nodeOrder.cast();
        this.edgeOrder = builder.edgeOrder.cast();
        this.nodeConnections = nodeConnections instanceof TreeMap ? new MapRetrievalCache<N, NetworkConnections<N, E>>(nodeConnections) : new MapIteratorCache<N, NetworkConnections<N, E>>(nodeConnections);
        this.edgeToReferenceNode = new MapIteratorCache<E, N>(edgeToReferenceNode);
    }

    @Override
    public Set<N> nodes() {
        return this.nodeConnections.unmodifiableKeySet();
    }

    @Override
    public Set<E> edges() {
        return this.edgeToReferenceNode.unmodifiableKeySet();
    }

    @Override
    public boolean isDirected() {
        return this.isDirected;
    }

    @Override
    public boolean allowsParallelEdges() {
        return this.allowsParallelEdges;
    }

    @Override
    public boolean allowsSelfLoops() {
        return this.allowsSelfLoops;
    }

    @Override
    public ElementOrder<N> nodeOrder() {
        return this.nodeOrder;
    }

    @Override
    public ElementOrder<E> edgeOrder() {
        return this.edgeOrder;
    }

    @Override
    public Set<E> incidentEdges(N node) {
        return this.nodeInvalidatableSet(this.checkedConnections(node).incidentEdges(), node);
    }

    @Override
    public EndpointPair<N> incidentNodes(E edge) {
        N nodeU = this.checkedReferenceNode(edge);
        java.lang.Object nodeV = ((NetworkConnections)Objects.requireNonNull(this.nodeConnections.get((Object)nodeU))).adjacentNode(edge);
        return EndpointPair.of(this, nodeU, nodeV);
    }

    @Override
    public Set<N> adjacentNodes(N node) {
        return this.nodeInvalidatableSet(this.checkedConnections(node).adjacentNodes(), node);
    }

    @Override
    public Set<E> edgesConnecting(N nodeU, N nodeV) {
        NetworkConnections<N, E> connectionsU = this.checkedConnections(nodeU);
        if (!this.allowsSelfLoops && nodeU == nodeV) {
            return ImmutableSet.of();
        }
        Preconditions.checkArgument(this.containsNode(nodeV), (String)"org.rascalmpl.org.rascalmpl.Node %s is not an element of this graph.", nodeV);
        return this.nodePairInvalidatableSet(connectionsU.edgesConnecting(nodeV), nodeU, nodeV);
    }

    @Override
    public Set<E> inEdges(N node) {
        return this.nodeInvalidatableSet(this.checkedConnections(node).inEdges(), node);
    }

    @Override
    public Set<E> outEdges(N node) {
        return this.nodeInvalidatableSet(this.checkedConnections(node).outEdges(), node);
    }

    @Override
    public Set<N> predecessors(N node) {
        return this.nodeInvalidatableSet(this.checkedConnections(node).predecessors(), node);
    }

    @Override
    public Set<N> successors(N node) {
        return this.nodeInvalidatableSet(this.checkedConnections(node).successors(), node);
    }

    final NetworkConnections<N, E> checkedConnections(N node) {
        NetworkConnections<N, E> connections = this.nodeConnections.get((Object)node);
        if (connections == null) {
            Preconditions.checkNotNull(node);
            throw new IllegalArgumentException(String.format((String)"org.rascalmpl.org.rascalmpl.Node %s is not an element of this graph.", (Object[])new Object[]{node}));
        }
        return connections;
    }

    final N checkedReferenceNode(E edge) {
        N referenceNode = this.edgeToReferenceNode.get((Object)edge);
        if (referenceNode == null) {
            Preconditions.checkNotNull(edge);
            throw new IllegalArgumentException(String.format((String)"org.rascalmpl.org.rascalmpl.Edge %s is not an element of this graph.", (Object[])new Object[]{edge}));
        }
        return referenceNode;
    }

    final boolean containsNode(N node) {
        return this.nodeConnections.containsKey((Object)node);
    }

    final boolean containsEdge(E edge) {
        return this.edgeToReferenceNode.containsKey((Object)edge);
    }
}

