/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.hash;

import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.AbstractByteHasher;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.AbstractHashFunction;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.HashCode;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.Hasher;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.IgnoreJRERequirement;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.ImmutableSupplier;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.Immutable;
import org.rascalmpl.org.rascalmpl.java.io.Serializable;
import org.rascalmpl.org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.org.rascalmpl.java.lang.Error;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalAccessException;
import org.rascalmpl.org.rascalmpl.java.lang.LinkageError;
import org.rascalmpl.org.rascalmpl.java.lang.NoSuchMethodException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.lang.Void;
import org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodHandle;
import org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodHandles;
import org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodType;
import org.rascalmpl.org.rascalmpl.java.nio.ByteBuffer;
import org.rascalmpl.org.rascalmpl.java.util.zip.Checksum;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
@ElementTypesAreNonnullByDefault
final class ChecksumHashFunction
extends AbstractHashFunction
implements Serializable {
    private final ImmutableSupplier<? extends Checksum> checksumSupplier;
    private final int bits;
    private final String toString;
    private static final long serialVersionUID = 0L;

    ChecksumHashFunction(ImmutableSupplier<? extends Checksum> checksumSupplier, int bits, String toString) {
        this.checksumSupplier = Preconditions.checkNotNull(checksumSupplier);
        Preconditions.checkArgument(bits == 32 || bits == 64, (String)"org.rascalmpl.org.rascalmpl.bits (%s) must be either 32 or 64", bits);
        this.bits = bits;
        this.toString = Preconditions.checkNotNull(toString);
    }

    @Override
    public int bits() {
        return this.bits;
    }

    @Override
    public Hasher newHasher() {
        return new ChecksumHasher((Checksum)this.checksumSupplier.get());
    }

    public String toString() {
        return this.toString;
    }

    private static final class ChecksumMethodHandles
    extends org.rascalmpl.org.rascalmpl.java.lang.Object {
        private static final @Nullable MethodHandle UPDATE_BB = ChecksumMethodHandles.updateByteBuffer();

        private ChecksumMethodHandles() {
        }

        @IgnoreJRERequirement
        static boolean updateByteBuffer(Checksum cs, ByteBuffer bb) {
            if (UPDATE_BB != null) {
                try {
                    UPDATE_BB.invokeExact(cs, bb);
                }
                catch (Error t2) {
                    throw t2;
                }
                catch (Throwable t3) {
                    throw new AssertionError((org.rascalmpl.org.rascalmpl.java.lang.Object)t3);
                }
                return true;
            }
            return false;
        }

        private static @Nullable MethodHandle updateByteBuffer() {
            try {
                Class clazz = Class.forName((String)"org.rascalmpl.org.rascalmpl.java.util.zip.Checksum");
                return MethodHandles.lookup().findVirtual(clazz, (String)"org.rascalmpl.org.rascalmpl.update", MethodType.methodType((Class)Void.TYPE, ByteBuffer.class));
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((org.rascalmpl.org.rascalmpl.java.lang.Object)e);
            }
            catch (IllegalAccessException e) {
                throw ChecksumMethodHandles.newLinkageError((Throwable)((Object)e));
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }

        private static LinkageError newLinkageError(Throwable cause) {
            return new LinkageError(cause.toString(), cause);
        }
    }

    private final class ChecksumHasher
    extends AbstractByteHasher {
        private final Checksum checksum;

        private ChecksumHasher(Checksum checksum) {
            this.checksum = Preconditions.checkNotNull(checksum);
        }

        @Override
        protected void update(byte b) {
            this.checksum.update((int)b);
        }

        @Override
        protected void update(byte[] bytes, int off, int len) {
            this.checksum.update(bytes, off, len);
        }

        @Override
        protected void update(ByteBuffer b) {
            if (!ChecksumMethodHandles.updateByteBuffer(this.checksum, b)) {
                super.update(b);
            }
        }

        @Override
        public HashCode hash() {
            long value = this.checksum.getValue();
            if (ChecksumHashFunction.this.bits == 32) {
                return HashCode.fromInt((int)value);
            }
            return HashCode.fromLong(value);
        }
    }
}

