/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.hash;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.Beta;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.Funnel;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.PrimitiveSink;
import org.rascalmpl.org.rascalmpl.java.io.InvalidObjectException;
import org.rascalmpl.org.rascalmpl.java.io.ObjectInputStream;
import org.rascalmpl.org.rascalmpl.java.io.OutputStream;
import org.rascalmpl.org.rascalmpl.java.io.Serializable;
import org.rascalmpl.org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.org.rascalmpl.java.lang.Enum;
import org.rascalmpl.org.rascalmpl.java.lang.Integer;
import org.rascalmpl.org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.org.rascalmpl.java.lang.Long;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.nio.charset.Charset;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@Beta
public final class Funnels
extends org.rascalmpl.org.rascalmpl.java.lang.Object {
    private Funnels() {
    }

    public static Funnel<byte[]> byteArrayFunnel() {
        return ByteArrayFunnel.INSTANCE;
    }

    public static Funnel<CharSequence> unencodedCharsFunnel() {
        return UnencodedCharsFunnel.INSTANCE;
    }

    public static Funnel<CharSequence> stringFunnel(Charset charset) {
        return new StringCharsetFunnel(charset);
    }

    public static Funnel<Integer> integerFunnel() {
        return IntegerFunnel.INSTANCE;
    }

    public static <E extends org.rascalmpl.org.rascalmpl.java.lang.Object> Funnel<Iterable<? extends E>> sequentialFunnel(Funnel<E> elementFunnel) {
        return new SequentialFunnel<E>(elementFunnel);
    }

    public static Funnel<Long> longFunnel() {
        return LongFunnel.INSTANCE;
    }

    public static OutputStream asOutputStream(PrimitiveSink sink) {
        return new SinkAsStream(sink);
    }

    private static class SinkAsStream
    extends OutputStream {
        final PrimitiveSink sink;

        SinkAsStream(PrimitiveSink sink) {
            this.sink = Preconditions.checkNotNull(sink);
        }

        public void write(int b) {
            this.sink.putByte((byte)b);
        }

        public void write(byte[] bytes) {
            this.sink.putBytes(bytes);
        }

        public void write(byte[] bytes, int off, int len) {
            this.sink.putBytes(bytes, off, len);
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Funnels.asOutputStream(").append((org.rascalmpl.org.rascalmpl.java.lang.Object)this.sink).append((String)"org.rascalmpl.org.rascalmpl.)").toString();
        }
    }

    private static final class LongFunnel
    extends Enum<LongFunnel>
    implements Funnel<Long> {
        public static final /* enum */ LongFunnel INSTANCE = new LongFunnel((String)"org.rascalmpl.org.rascalmpl.INSTANCE", 0);
        private static final /* synthetic */ LongFunnel[] $VALUES;

        public static LongFunnel[] values() {
            return (LongFunnel[])$VALUES.clone();
        }

        public static LongFunnel valueOf(String name) {
            return (LongFunnel)Enum.valueOf(LongFunnel.class, (String)name);
        }

        private LongFunnel() {
            super((String)string, n);
        }

        @Override
        public void funnel(Long from, PrimitiveSink into) {
            into.putLong(from.longValue());
        }

        public String toString() {
            return "org.rascalmpl.org.rascalmpl.Funnels.longFunnel()";
        }

        static {
            $VALUES = new LongFunnel[]{INSTANCE};
        }
    }

    private static class SequentialFunnel<E extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.org.rascalmpl.java.lang.Object
    implements Funnel<Iterable<? extends E>>,
    Serializable {
        private final Funnel<E> elementFunnel;

        SequentialFunnel(Funnel<E> elementFunnel) {
            this.elementFunnel = Preconditions.checkNotNull(elementFunnel);
        }

        @Override
        public void funnel(Iterable<? extends E> from, PrimitiveSink into) {
            for (org.rascalmpl.org.rascalmpl.java.lang.Object e : from) {
                this.elementFunnel.funnel(e, into);
            }
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Funnels.sequentialFunnel(").append(this.elementFunnel).append((String)"org.rascalmpl.org.rascalmpl.)").toString();
        }

        public boolean equals(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object o) {
            if (o instanceof SequentialFunnel) {
                SequentialFunnel funnel = (SequentialFunnel)o;
                return this.elementFunnel.equals(funnel.elementFunnel);
            }
            return false;
        }

        public int hashCode() {
            return SequentialFunnel.class.hashCode() ^ this.elementFunnel.hashCode();
        }
    }

    private static final class IntegerFunnel
    extends Enum<IntegerFunnel>
    implements Funnel<Integer> {
        public static final /* enum */ IntegerFunnel INSTANCE = new IntegerFunnel((String)"org.rascalmpl.org.rascalmpl.INSTANCE", 0);
        private static final /* synthetic */ IntegerFunnel[] $VALUES;

        public static IntegerFunnel[] values() {
            return (IntegerFunnel[])$VALUES.clone();
        }

        public static IntegerFunnel valueOf(String name) {
            return (IntegerFunnel)Enum.valueOf(IntegerFunnel.class, (String)name);
        }

        private IntegerFunnel() {
            super((String)string, n);
        }

        @Override
        public void funnel(Integer from, PrimitiveSink into) {
            into.putInt(from.intValue());
        }

        public String toString() {
            return "org.rascalmpl.org.rascalmpl.Funnels.integerFunnel()";
        }

        static {
            $VALUES = new IntegerFunnel[]{INSTANCE};
        }
    }

    private static class StringCharsetFunnel
    extends org.rascalmpl.org.rascalmpl.java.lang.Object
    implements Funnel<CharSequence>,
    Serializable {
        private final Charset charset;

        StringCharsetFunnel(Charset charset) {
            this.charset = Preconditions.checkNotNull(charset);
        }

        @Override
        public void funnel(CharSequence from, PrimitiveSink into) {
            into.putString(from, this.charset);
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Funnels.stringFunnel(").append(this.charset.name()).append((String)"org.rascalmpl.org.rascalmpl.)").toString();
        }

        public boolean equals(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object o) {
            if (o instanceof StringCharsetFunnel) {
                StringCharsetFunnel funnel = (StringCharsetFunnel)o;
                return this.charset.equals((org.rascalmpl.org.rascalmpl.java.lang.Object)funnel.charset);
            }
            return false;
        }

        public int hashCode() {
            return StringCharsetFunnel.class.hashCode() ^ this.charset.hashCode();
        }

        org.rascalmpl.org.rascalmpl.java.lang.Object writeReplace() {
            return new SerializedForm(this.charset);
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException((String)"org.rascalmpl.org.rascalmpl.Use SerializedForm");
        }

        private static class SerializedForm
        extends org.rascalmpl.org.rascalmpl.java.lang.Object
        implements Serializable {
            private final String charsetCanonicalName;
            private static final long serialVersionUID = 0L;

            SerializedForm(Charset charset) {
                this.charsetCanonicalName = charset.name();
            }

            private org.rascalmpl.org.rascalmpl.java.lang.Object readResolve() {
                return Funnels.stringFunnel(Charset.forName((String)this.charsetCanonicalName));
            }
        }
    }

    private static final class UnencodedCharsFunnel
    extends Enum<UnencodedCharsFunnel>
    implements Funnel<CharSequence> {
        public static final /* enum */ UnencodedCharsFunnel INSTANCE = new UnencodedCharsFunnel((String)"org.rascalmpl.org.rascalmpl.INSTANCE", 0);
        private static final /* synthetic */ UnencodedCharsFunnel[] $VALUES;

        public static UnencodedCharsFunnel[] values() {
            return (UnencodedCharsFunnel[])$VALUES.clone();
        }

        public static UnencodedCharsFunnel valueOf(String name) {
            return (UnencodedCharsFunnel)Enum.valueOf(UnencodedCharsFunnel.class, (String)name);
        }

        private UnencodedCharsFunnel() {
            super((String)string, n);
        }

        @Override
        public void funnel(CharSequence from, PrimitiveSink into) {
            into.putUnencodedChars(from);
        }

        public String toString() {
            return "org.rascalmpl.org.rascalmpl.Funnels.unencodedCharsFunnel()";
        }

        static {
            $VALUES = new UnencodedCharsFunnel[]{INSTANCE};
        }
    }

    private static final class ByteArrayFunnel
    extends Enum<ByteArrayFunnel>
    implements Funnel<byte[]> {
        public static final /* enum */ ByteArrayFunnel INSTANCE = new ByteArrayFunnel((String)"org.rascalmpl.org.rascalmpl.INSTANCE", 0);
        private static final /* synthetic */ ByteArrayFunnel[] $VALUES;

        public static ByteArrayFunnel[] values() {
            return (ByteArrayFunnel[])$VALUES.clone();
        }

        public static ByteArrayFunnel valueOf(String name) {
            return (ByteArrayFunnel)Enum.valueOf(ByteArrayFunnel.class, (String)name);
        }

        private ByteArrayFunnel() {
            super((String)string, n);
        }

        @Override
        public void funnel(byte[] from, PrimitiveSink into) {
            into.putBytes(from);
        }

        public String toString() {
            return "org.rascalmpl.org.rascalmpl.Funnels.byteArrayFunnel()";
        }

        static {
            $VALUES = new ByteArrayFunnel[]{INSTANCE};
        }
    }
}

