/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.hash;

import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Throwables;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.AbstractCompositeHashFunction;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.ChecksumHashFunction;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.Crc32cHashFunction;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.FarmHashFingerprint64;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.Fingerprint2011;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.HashCode;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.HashFunction;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.Hasher;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.IgnoreJRERequirement;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.ImmutableSupplier;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.MacHashFunction;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.MessageDigestHashFunction;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.Murmur3_128HashFunction;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.Murmur3_32HashFunction;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.SipHashFunction;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.Immutable;
import org.rascalmpl.org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.org.rascalmpl.java.lang.Enum;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalAccessException;
import org.rascalmpl.org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.org.rascalmpl.java.lang.LinkageError;
import org.rascalmpl.org.rascalmpl.java.lang.NoSuchMethodException;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.lang.Void;
import org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodHandle;
import org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodHandles;
import org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodType;
import org.rascalmpl.org.rascalmpl.java.security.Key;
import org.rascalmpl.org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.org.rascalmpl.java.util.Arrays;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.Collections;
import org.rascalmpl.org.rascalmpl.java.util.Iterator;
import org.rascalmpl.org.rascalmpl.java.util.zip.Adler32;
import org.rascalmpl.org.rascalmpl.java.util.zip.CRC32;
import org.rascalmpl.org.rascalmpl.java.util.zip.Checksum;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.rascalmpl.javax.crypto.spec.SecretKeySpec;

@ElementTypesAreNonnullByDefault
public final class Hashing
extends Object {
    static final int GOOD_FAST_HASH_SEED = (int)System.currentTimeMillis();

    public static HashFunction goodFastHash(int minimumBits) {
        int bits = Hashing.checkPositiveAndMakeMultipleOf32(minimumBits);
        if (bits == 32) {
            return Murmur3_32HashFunction.GOOD_FAST_HASH_32;
        }
        if (bits <= 128) {
            return Murmur3_128HashFunction.GOOD_FAST_HASH_128;
        }
        int hashFunctionsNeeded = (bits + 127) / 128;
        HashFunction[] hashFunctions = new HashFunction[hashFunctionsNeeded];
        hashFunctions[0] = Murmur3_128HashFunction.GOOD_FAST_HASH_128;
        int seed = GOOD_FAST_HASH_SEED;
        for (int i = 1; i < hashFunctionsNeeded; ++i) {
            hashFunctions[i] = Hashing.murmur3_128(seed += 1500450271);
        }
        return new ConcatenatedHashFunction(hashFunctions);
    }

    @Deprecated
    public static HashFunction murmur3_32(int seed) {
        return new Murmur3_32HashFunction(seed, false);
    }

    @Deprecated
    public static HashFunction murmur3_32() {
        return Murmur3_32HashFunction.MURMUR3_32;
    }

    public static HashFunction murmur3_32_fixed(int seed) {
        return new Murmur3_32HashFunction(seed, true);
    }

    public static HashFunction murmur3_32_fixed() {
        return Murmur3_32HashFunction.MURMUR3_32_FIXED;
    }

    public static HashFunction murmur3_128(int seed) {
        return new Murmur3_128HashFunction(seed);
    }

    public static HashFunction murmur3_128() {
        return Murmur3_128HashFunction.MURMUR3_128;
    }

    public static HashFunction sipHash24() {
        return SipHashFunction.SIP_HASH_24;
    }

    public static HashFunction sipHash24(long k0, long k1) {
        return new SipHashFunction(2, 4, k0, k1);
    }

    @Deprecated
    public static HashFunction md5() {
        return Md5Holder.MD5;
    }

    @Deprecated
    public static HashFunction sha1() {
        return Sha1Holder.SHA_1;
    }

    public static HashFunction sha256() {
        return Sha256Holder.SHA_256;
    }

    public static HashFunction sha384() {
        return Sha384Holder.SHA_384;
    }

    public static HashFunction sha512() {
        return Sha512Holder.SHA_512;
    }

    public static HashFunction hmacMd5(Key key) {
        return new MacHashFunction((String)"org.rascalmpl.org.rascalmpl.HmacMD5", key, Hashing.hmacToString((String)"org.rascalmpl.org.rascalmpl.hmacMd5", key));
    }

    public static HashFunction hmacMd5(byte[] key) {
        return Hashing.hmacMd5((Key)new SecretKeySpec(Preconditions.checkNotNull(key), (String)"org.rascalmpl.org.rascalmpl.HmacMD5"));
    }

    public static HashFunction hmacSha1(Key key) {
        return new MacHashFunction((String)"org.rascalmpl.org.rascalmpl.HmacSHA1", key, Hashing.hmacToString((String)"org.rascalmpl.org.rascalmpl.hmacSha1", key));
    }

    public static HashFunction hmacSha1(byte[] key) {
        return Hashing.hmacSha1((Key)new SecretKeySpec(Preconditions.checkNotNull(key), (String)"org.rascalmpl.org.rascalmpl.HmacSHA1"));
    }

    public static HashFunction hmacSha256(Key key) {
        return new MacHashFunction((String)"org.rascalmpl.org.rascalmpl.HmacSHA256", key, Hashing.hmacToString((String)"org.rascalmpl.org.rascalmpl.hmacSha256", key));
    }

    public static HashFunction hmacSha256(byte[] key) {
        return Hashing.hmacSha256((Key)new SecretKeySpec(Preconditions.checkNotNull(key), (String)"org.rascalmpl.org.rascalmpl.HmacSHA256"));
    }

    public static HashFunction hmacSha512(Key key) {
        return new MacHashFunction((String)"org.rascalmpl.org.rascalmpl.HmacSHA512", key, Hashing.hmacToString((String)"org.rascalmpl.org.rascalmpl.hmacSha512", key));
    }

    public static HashFunction hmacSha512(byte[] key) {
        return Hashing.hmacSha512((Key)new SecretKeySpec(Preconditions.checkNotNull(key), (String)"org.rascalmpl.org.rascalmpl.HmacSHA512"));
    }

    private static String hmacToString(String methodName, Key key) {
        return new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Hashing.").append(methodName).append((String)"org.rascalmpl.org.rascalmpl.(Key[algorithm=").append(key.getAlgorithm()).append((String)"org.rascalmpl.org.rascalmpl., format=").append(key.getFormat()).append((String)"org.rascalmpl.org.rascalmpl.])").toString();
    }

    public static HashFunction crc32c() {
        return Crc32CSupplier.HASH_FUNCTION;
    }

    public static HashFunction crc32() {
        return ChecksumType.CRC_32.hashFunction;
    }

    public static HashFunction adler32() {
        return ChecksumType.ADLER_32.hashFunction;
    }

    public static HashFunction farmHashFingerprint64() {
        return FarmHashFingerprint64.FARMHASH_FINGERPRINT_64;
    }

    public static HashFunction fingerprint2011() {
        return Fingerprint2011.FINGERPRINT_2011;
    }

    public static int consistentHash(HashCode hashCode, int buckets) {
        return Hashing.consistentHash(hashCode.padToLong(), buckets);
    }

    public static int consistentHash(long input, int buckets) {
        int next;
        Preconditions.checkArgument(buckets > 0, (String)"org.rascalmpl.org.rascalmpl.buckets must be positive: %s", buckets);
        LinearCongruentialGenerator generator = new LinearCongruentialGenerator(input);
        int candidate = 0;
        while ((next = (int)((double)(candidate + 1) / generator.nextDouble())) >= 0 && next < buckets) {
            candidate = next;
        }
        return candidate;
    }

    public static HashCode combineOrdered(Iterable<HashCode> hashCodes) {
        Iterator iterator = hashCodes.iterator();
        Preconditions.checkArgument(iterator.hasNext(), (Object)"org.rascalmpl.org.rascalmpl.Must be at least 1 hash code to combine.");
        int bits = ((HashCode)iterator.next()).bits();
        byte[] resultBytes = new byte[bits / 8];
        for (HashCode hashCode : hashCodes) {
            byte[] nextBytes = hashCode.asBytes();
            Preconditions.checkArgument(nextBytes.length == resultBytes.length, (Object)"org.rascalmpl.org.rascalmpl.All hashcodes must have the same bit length.");
            for (int i = 0; i < nextBytes.length; ++i) {
                resultBytes[i] = (byte)(resultBytes[i] * 37 ^ nextBytes[i]);
            }
        }
        return HashCode.fromBytesNoCopy(resultBytes);
    }

    public static HashCode combineUnordered(Iterable<HashCode> hashCodes) {
        Iterator iterator = hashCodes.iterator();
        Preconditions.checkArgument(iterator.hasNext(), (Object)"org.rascalmpl.org.rascalmpl.Must be at least 1 hash code to combine.");
        byte[] resultBytes = new byte[((HashCode)iterator.next()).bits() / 8];
        for (HashCode hashCode : hashCodes) {
            byte[] nextBytes = hashCode.asBytes();
            Preconditions.checkArgument(nextBytes.length == resultBytes.length, (Object)"org.rascalmpl.org.rascalmpl.All hashcodes must have the same bit length.");
            for (int i = 0; i < nextBytes.length; ++i) {
                int n = i;
                resultBytes[n] = (byte)(resultBytes[n] + nextBytes[i]);
            }
        }
        return HashCode.fromBytesNoCopy(resultBytes);
    }

    static int checkPositiveAndMakeMultipleOf32(int bits) {
        Preconditions.checkArgument(bits > 0, (Object)"org.rascalmpl.org.rascalmpl.Number of bits must be positive");
        return bits + 31 & 0xFFFFFFE0;
    }

    public static HashFunction concatenating(HashFunction first, HashFunction second, HashFunction ... rest) {
        ArrayList list = new ArrayList();
        list.add((Object)first);
        list.add((Object)second);
        Collections.addAll((Collection)list, (Object[])rest);
        return new ConcatenatedHashFunction((HashFunction[])list.toArray((Object[])new HashFunction[0]));
    }

    public static HashFunction concatenating(Iterable<HashFunction> hashFunctions) {
        Preconditions.checkNotNull(hashFunctions);
        ArrayList list = new ArrayList();
        for (HashFunction hashFunction : hashFunctions) {
            list.add((Object)hashFunction);
        }
        Preconditions.checkArgument(!list.isEmpty(), (String)"org.rascalmpl.org.rascalmpl.number of hash functions (%s) must be > 0", list.size());
        return new ConcatenatedHashFunction((HashFunction[])list.toArray((Object[])new HashFunction[0]));
    }

    private Hashing() {
    }

    private static final class LinearCongruentialGenerator
    extends Object {
        private long state;

        public LinearCongruentialGenerator(long seed) {
            this.state = seed;
        }

        public double nextDouble() {
            this.state = 2862933555777941757L * this.state + 1L;
            return (double)((int)(this.state >>> 33) + 1) / 2.147483648E9;
        }
    }

    private static final class ConcatenatedHashFunction
    extends AbstractCompositeHashFunction {
        private ConcatenatedHashFunction(HashFunction ... functions) {
            super(functions);
            for (HashFunction function : functions) {
                Preconditions.checkArgument(function.bits() % 8 == 0, (String)"org.rascalmpl.org.rascalmpl.the number of bits (%s) in hashFunction (%s) must be divisible by 8", function.bits(), (Object)function);
            }
        }

        @Override
        HashCode makeHash(Hasher[] hashers) {
            byte[] bytes = new byte[this.bits() / 8];
            int i = 0;
            for (Hasher hasher : hashers) {
                HashCode newHash = hasher.hash();
                i += newHash.writeBytesTo(bytes, i, newHash.bits() / 8);
            }
            return HashCode.fromBytesNoCopy(bytes);
        }

        @Override
        public int bits() {
            int bitSum = 0;
            for (HashFunction function : this.functions) {
                bitSum += function.bits();
            }
            return bitSum;
        }

        public boolean equals(@CheckForNull Object object) {
            if (object instanceof ConcatenatedHashFunction) {
                ConcatenatedHashFunction other = (ConcatenatedHashFunction)object;
                return Arrays.equals((Object[])this.functions, (Object[])other.functions);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode((Object[])this.functions);
        }
    }

    private static final class Crc32cMethodHandles
    extends Object {
        private static final MethodHandle CONSTRUCTOR = Crc32cMethodHandles.crc32cConstructor();

        private Crc32cMethodHandles() {
        }

        @IgnoreJRERequirement
        static Checksum newCrc32c() {
            try {
                return CONSTRUCTOR.invokeExact();
            }
            catch (Throwable e) {
                Throwables.throwIfUnchecked(e);
                throw Crc32cMethodHandles.newLinkageError(e);
            }
        }

        private static MethodHandle crc32cConstructor() {
            try {
                Class clazz = Class.forName((String)"org.rascalmpl.org.rascalmpl.java.util.zip.CRC32C");
                return MethodHandles.lookup().findConstructor(clazz, MethodType.methodType((Class)Void.TYPE)).asType(MethodType.methodType(Checksum.class));
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw Crc32cMethodHandles.newLinkageError((Throwable)((java.lang.Object)e));
            }
            catch (NoSuchMethodException e) {
                throw Crc32cMethodHandles.newLinkageError((Throwable)((java.lang.Object)e));
            }
        }

        private static LinkageError newLinkageError(Throwable cause) {
            return new LinkageError(cause.toString(), cause);
        }
    }

    @Immutable
    static abstract class ChecksumType
    extends Enum<ChecksumType>
    implements ImmutableSupplier<Checksum> {
        public static final /* enum */ ChecksumType CRC_32 = new ChecksumType((String)"org.rascalmpl.org.rascalmpl.Hashing.crc32()"){

            @Override
            public Checksum get() {
                return new CRC32();
            }
        };
        public static final /* enum */ ChecksumType CRC_32C = new ChecksumType((String)"org.rascalmpl.org.rascalmpl.Hashing.crc32c()"){

            @Override
            public Checksum get() {
                return Crc32cMethodHandles.newCrc32c();
            }
        };
        public static final /* enum */ ChecksumType ADLER_32 = new ChecksumType((String)"org.rascalmpl.org.rascalmpl.Hashing.adler32()"){

            @Override
            public Checksum get() {
                return new Adler32();
            }
        };
        public final HashFunction hashFunction;
        private static final /* synthetic */ ChecksumType[] $VALUES;

        public static ChecksumType[] values() {
            return (ChecksumType[])$VALUES.clone();
        }

        public static ChecksumType valueOf(String name) {
            return (ChecksumType)Enum.valueOf(ChecksumType.class, (String)name);
        }

        private ChecksumType(String toString) {
            super((String)string, n);
            this.hashFunction = new ChecksumHashFunction(this, 32, toString);
        }

        static {
            $VALUES = new ChecksumType[]{CRC_32, CRC_32C, ADLER_32};
        }
    }

    @Immutable
    private static abstract class Crc32CSupplier
    extends Enum<Crc32CSupplier>
    implements ImmutableSupplier<HashFunction> {
        public static final /* enum */ Crc32CSupplier JAVA_UTIL_ZIP = new Crc32CSupplier(){

            @Override
            public HashFunction get() {
                return ChecksumType.CRC_32C.hashFunction;
            }
        };
        public static final /* enum */ Crc32CSupplier ABSTRACT_HASH_FUNCTION = new Crc32CSupplier(){

            @Override
            public HashFunction get() {
                return Crc32cHashFunction.CRC_32_C;
            }
        };
        static final HashFunction HASH_FUNCTION;
        private static final /* synthetic */ Crc32CSupplier[] $VALUES;

        public static Crc32CSupplier[] values() {
            return (Crc32CSupplier[])$VALUES.clone();
        }

        public static Crc32CSupplier valueOf(String name) {
            return (Crc32CSupplier)Enum.valueOf(Crc32CSupplier.class, (String)name);
        }

        private Crc32CSupplier() {
            super((String)string, n);
        }

        private static Crc32CSupplier pickFunction() {
            Crc32CSupplier[] functions = Crc32CSupplier.values();
            if (functions.length == 1) {
                return functions[0];
            }
            Crc32CSupplier javaUtilZip = functions[0];
            try {
                Class.forName((String)"org.rascalmpl.org.rascalmpl.java.util.zip.CRC32C");
                return javaUtilZip;
            }
            catch (ClassNotFoundException runningUnderJava8) {
                return ABSTRACT_HASH_FUNCTION;
            }
        }

        static {
            $VALUES = new Crc32CSupplier[]{JAVA_UTIL_ZIP, ABSTRACT_HASH_FUNCTION};
            HASH_FUNCTION = (HashFunction)Crc32CSupplier.pickFunction().get();
        }
    }

    private static class Sha512Holder
    extends Object {
        static final HashFunction SHA_512 = new MessageDigestHashFunction((String)"org.rascalmpl.org.rascalmpl.SHA-512", (String)"org.rascalmpl.org.rascalmpl.Hashing.sha512()");

        private Sha512Holder() {
        }
    }

    private static class Sha384Holder
    extends Object {
        static final HashFunction SHA_384 = new MessageDigestHashFunction((String)"org.rascalmpl.org.rascalmpl.SHA-384", (String)"org.rascalmpl.org.rascalmpl.Hashing.sha384()");

        private Sha384Holder() {
        }
    }

    private static class Sha256Holder
    extends Object {
        static final HashFunction SHA_256 = new MessageDigestHashFunction((String)"org.rascalmpl.org.rascalmpl.SHA-256", (String)"org.rascalmpl.org.rascalmpl.Hashing.sha256()");

        private Sha256Holder() {
        }
    }

    private static class Sha1Holder
    extends Object {
        static final HashFunction SHA_1 = new MessageDigestHashFunction((String)"org.rascalmpl.org.rascalmpl.SHA-1", (String)"org.rascalmpl.org.rascalmpl.Hashing.sha1()");

        private Sha1Holder() {
        }
    }

    private static class Md5Holder
    extends Object {
        static final HashFunction MD5 = new MessageDigestHashFunction((String)"org.rascalmpl.org.rascalmpl.MD5", (String)"org.rascalmpl.org.rascalmpl.Hashing.md5()");

        private Md5Holder() {
        }
    }
}

