/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.hash;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.Beta;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.HashCode;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.HashFunction;
import org.rascalmpl.org.rascalmpl.com.google.common.hash.Hasher;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.java.io.FilterInputStream;
import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.io.InputStream;
import org.rascalmpl.org.rascalmpl.java.lang.String;

@ElementTypesAreNonnullByDefault
@Beta
public final class HashingInputStream
extends FilterInputStream {
    private final Hasher hasher;

    public HashingInputStream(HashFunction hashFunction, InputStream in) {
        super(Preconditions.checkNotNull(in));
        this.hasher = Preconditions.checkNotNull(hashFunction.newHasher());
    }

    @CanIgnoreReturnValue
    public int read() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            this.hasher.putByte((byte)b);
        }
        return b;
    }

    @CanIgnoreReturnValue
    public int read(byte[] bytes, int off, int len) throws IOException {
        int numOfBytesRead = this.in.read(bytes, off, len);
        if (numOfBytesRead != -1) {
            this.hasher.putBytes(bytes, off, numOfBytesRead);
        }
        return numOfBytesRead;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readlimit) {
    }

    public void reset() throws IOException {
        throw new IOException((String)"org.rascalmpl.org.rascalmpl.reset not supported");
    }

    public HashCode hash() {
        return this.hasher.hash();
    }
}

