/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.io;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.io.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.java.io.Closeable;
import org.rascalmpl.org.rascalmpl.java.io.Flushable;
import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.io.Writer;
import org.rascalmpl.org.rascalmpl.java.lang.Appendable;
import org.rascalmpl.org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
class AppendableWriter
extends Writer {
    private final Appendable target;
    private boolean closed;

    AppendableWriter(Appendable target) {
        this.target = Preconditions.checkNotNull(target);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.checkNotClosed();
        this.target.append((CharSequence)new String(cbuf, off, len));
    }

    public void write(int c) throws IOException {
        this.checkNotClosed();
        this.target.append((char)c);
    }

    public void write(String str) throws IOException {
        Preconditions.checkNotNull(str);
        this.checkNotClosed();
        this.target.append((CharSequence)str);
    }

    public void write(String str, int off, int len) throws IOException {
        Preconditions.checkNotNull(str);
        this.checkNotClosed();
        this.target.append((CharSequence)str, off, off + len);
    }

    public void flush() throws IOException {
        this.checkNotClosed();
        if (this.target instanceof Flushable) {
            ((Flushable)this.target).flush();
        }
    }

    public void close() throws IOException {
        this.closed = true;
        if (this.target instanceof Closeable) {
            ((Closeable)this.target).close();
        }
    }

    public Writer append(char c) throws IOException {
        this.checkNotClosed();
        this.target.append(c);
        return this;
    }

    public Writer append(@CheckForNull CharSequence charSeq) throws IOException {
        this.checkNotClosed();
        this.target.append(charSeq);
        return this;
    }

    public Writer append(@CheckForNull CharSequence charSeq, int start, int end) throws IOException {
        this.checkNotClosed();
        this.target.append(charSeq, start, end);
        return this;
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException((String)"org.rascalmpl.org.rascalmpl.Cannot write to a closed writer.");
        }
    }
}

